/*
 * Decompiled with CFR 0.152.
 */
package leakcanary.internal;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.ContextWrapper;
import android.os.Looper;
import android.os.MessageQueue;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.inputmethod.InputMethodManager;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import shark.SharkLog;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B%\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001c\u0010\u0012\u001a\u00020\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0014H\u0016J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0014H\u0016J\u0010\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0014H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lleakcanary/internal/ReferenceCleaner;", "Landroid/os/MessageQueue$IdleHandler;", "Landroid/view/View$OnAttachStateChangeListener;", "Landroid/view/ViewTreeObserver$OnGlobalFocusChangeListener;", "inputMethodManager", "Landroid/view/inputmethod/InputMethodManager;", "mHField", "Ljava/lang/reflect/Field;", "mServedViewField", "finishInputLockedMethod", "Ljava/lang/reflect/Method;", "(Landroid/view/inputmethod/InputMethodManager;Ljava/lang/reflect/Field;Ljava/lang/reflect/Field;Ljava/lang/reflect/Method;)V", "clearInputMethodManagerLeak", "", "extractActivity", "Landroid/app/Activity;", "sourceContext", "Landroid/content/Context;", "onGlobalFocusChanged", "oldFocus", "Landroid/view/View;", "newFocus", "onViewAttachedToWindow", "v", "onViewDetachedFromWindow", "queueIdle", "", "plumber-android-core_release"})
public final class ReferenceCleaner
implements MessageQueue.IdleHandler,
View.OnAttachStateChangeListener,
ViewTreeObserver.OnGlobalFocusChangeListener {
    private final InputMethodManager inputMethodManager;
    private final Field mHField;
    private final Field mServedViewField;
    private final Method finishInputLockedMethod;

    public void onGlobalFocusChanged(@Nullable View oldFocus, @Nullable View newFocus) {
        if (newFocus == null) {
            return;
        }
        View view = oldFocus;
        if (view != null) {
            view.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
        }
        Looper.myQueue().removeIdleHandler((MessageQueue.IdleHandler)this);
        newFocus.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
    }

    public void onViewAttachedToWindow(@NotNull View v) {
        Intrinsics.checkParameterIsNotNull((Object)v, (String)"v");
    }

    public void onViewDetachedFromWindow(@NotNull View v) {
        Intrinsics.checkParameterIsNotNull((Object)v, (String)"v");
        v.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
        Looper.myQueue().removeIdleHandler((MessageQueue.IdleHandler)this);
        Looper.myQueue().addIdleHandler((MessageQueue.IdleHandler)this);
    }

    public boolean queueIdle() {
        this.clearInputMethodManagerLeak();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void clearInputMethodManagerLeak() {
        try {
            Object lock = this.mHField.get(this.inputMethodManager);
            if (lock == null) {
                SharkLog this_$iv = SharkLog.INSTANCE;
                boolean $i$f$d2 = false;
                SharkLog.Logger logger = this_$iv.getLogger();
                if (logger == null) {
                } else {
                    SharkLog.Logger logger$iv;
                    SharkLog.Logger logger2 = logger$iv = logger;
                    boolean bl = false;
                    String string = "InputMethodManager.mH was null, could not fix leak.";
                    logger2.d(string);
                }
                return;
            }
            boolean this_$iv = false;
            boolean $i$f$d2 = false;
            synchronized (lock) {
                boolean bl = false;
                View servedView = (View)this.mServedViewField.get(this.inputMethodManager);
                if (servedView != null) {
                    boolean servedViewAttached;
                    boolean bl2 = servedViewAttached = servedView.getWindowVisibility() != 8;
                    if (servedViewAttached) {
                        servedView.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
                        servedView.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
                    } else {
                        Context context = servedView.getContext();
                        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"servedView.context");
                        Activity activity = this.extractActivity(context);
                        if (activity == null || activity.getWindow() == null) {
                            this.finishInputLockedMethod.invoke((Object)this.inputMethodManager, new Object[0]);
                        } else {
                            boolean windowAttached;
                            View decorView;
                            View view = decorView = activity.getWindow().peekDecorView();
                            Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"decorView");
                            boolean bl3 = windowAttached = view.getWindowVisibility() != 8;
                            if (!windowAttached) {
                                this.finishInputLockedMethod.invoke((Object)this.inputMethodManager, new Object[0]);
                            }
                        }
                    }
                }
                Unit $i$f$d2 = Unit.INSTANCE;
            }
        }
        catch (Throwable ignored) {
            SharkLog this_$iv = SharkLog.INSTANCE;
            boolean $i$f$d = false;
            SharkLog.Logger logger = this_$iv.getLogger();
            if (logger == null) {
            }
            SharkLog.Logger logger$iv = logger;
            Throwable throwable = ignored;
            SharkLog.Logger logger3 = logger$iv;
            boolean bl = false;
            String string = "Could not fix leak";
            logger3.d(throwable, string);
        }
    }

    private final Activity extractActivity(Context sourceContext) {
        Context context = sourceContext;
        Context context2;
        while (!((context2 = context) instanceof Application)) {
            Context baseContext;
            if (context2 instanceof Activity) {
                return (Activity)context;
            }
            if (context2 instanceof ContextWrapper) {
                baseContext = ((ContextWrapper)context).getBaseContext();
                if (baseContext == context) {
                    return null;
                }
            } else {
                return null;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)baseContext, (String)"baseContext");
        }
        return null;
    }

    public ReferenceCleaner(@NotNull InputMethodManager inputMethodManager, @NotNull Field mHField, @NotNull Field mServedViewField, @NotNull Method finishInputLockedMethod) {
        Intrinsics.checkParameterIsNotNull((Object)inputMethodManager, (String)"inputMethodManager");
        Intrinsics.checkParameterIsNotNull((Object)mHField, (String)"mHField");
        Intrinsics.checkParameterIsNotNull((Object)mServedViewField, (String)"mServedViewField");
        Intrinsics.checkParameterIsNotNull((Object)finishInputLockedMethod, (String)"finishInputLockedMethod");
        this.inputMethodManager = inputMethodManager;
        this.mHField = mHField;
        this.mServedViewField = mServedViewField;
        this.finishInputLockedMethod = finishInputLockedMethod;
    }
}

