/*
 * Decompiled with CFR 0.152.
 */
package leakcanary.internal;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.database.sqlite.SQLiteDatabase;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import leakcanary.EventListener;
import leakcanary.LeakCanary;
import leakcanary.internal.AndroidDebugHeapAnalyzer;
import leakcanary.internal.InternalLeakCanary;
import leakcanary.internal.LeakDirectoryProvider;
import leakcanary.internal.activity.LeakActivity;
import leakcanary.internal.activity.db.HeapAnalysisTable;
import leakcanary.internal.activity.db.LeakTable;
import leakcanary.internal.activity.db.ScopedLeaksDb;
import org.jetbrains.annotations.NotNull;
import shark.CloseableHeapGraph;
import shark.ConstantMemoryMetricsDualSourceProvider;
import shark.DualSourceProvider;
import shark.HeapAnalysis;
import shark.HeapAnalysisException;
import shark.HeapAnalysisFailure;
import shark.HeapAnalysisSuccess;
import shark.HeapAnalyzer;
import shark.HeapGraph;
import shark.HprofHeapGraph;
import shark.OnAnalysisProgressListener;
import shark.ProguardMapping;
import shark.ProguardMappingReader;
import shark.ThrowingCancelableFileSourceProvider;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\nH\u0002J6\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lleakcanary/internal/AndroidDebugHeapAnalyzer;", "", "()V", "PROGUARD_MAPPING_FILE_NAME", "", "application", "Landroid/app/Application;", "analyzeHeap", "Lshark/HeapAnalysis;", "heapDumpFile", "Ljava/io/File;", "progressListener", "Lshark/OnAnalysisProgressListener;", "isCanceled", "Lkotlin/Function0;", "", "missingFileFailure", "Lshark/HeapAnalysisFailure;", "runAnalysisBlocking", "Lleakcanary/EventListener$Event$HeapAnalysisDone;", "heapDumped", "Lleakcanary/EventListener$Event$HeapDump;", "progressEventListener", "Lkotlin/Function1;", "Lleakcanary/EventListener$Event$HeapAnalysisProgress;", "", "leakcanary-android-core_release"})
public final class AndroidDebugHeapAnalyzer {
    private static final String PROGUARD_MAPPING_FILE_NAME = "leakCanaryObfuscationMapping.txt";
    private static final Application application;
    @NotNull
    public static final AndroidDebugHeapAnalyzer INSTANCE;

    @NotNull
    public final EventListener.Event.HeapAnalysisDone<?> runAnalysisBlocking(@NotNull EventListener.Event.HeapDump heapDumped, @NotNull Function0<Boolean> isCanceled, @NotNull Function1<? super EventListener.Event.HeapAnalysisProgress, Unit> progressEventListener) {
        HeapAnalysis heapAnalysis;
        HeapAnalysis heapAnalysis2;
        Intrinsics.checkParameterIsNotNull((Object)heapDumped, (String)"heapDumped");
        Intrinsics.checkParameterIsNotNull(isCanceled, (String)"isCanceled");
        Intrinsics.checkParameterIsNotNull(progressEventListener, (String)"progressEventListener");
        OnAnalysisProgressListener progressListener2 = new OnAnalysisProgressListener(progressEventListener, heapDumped){
            final /* synthetic */ Function1 $progressEventListener;
            final /* synthetic */ EventListener.Event.HeapDump $heapDumped;

            public final void onAnalysisProgress(@NotNull OnAnalysisProgressListener.Step step) {
                Intrinsics.checkParameterIsNotNull((Object)step, (String)"step");
                double percent = (double)step.ordinal() * 1.0 / (double)OnAnalysisProgressListener.Step.values().length;
                this.$progressEventListener.invoke((Object)new EventListener.Event.HeapAnalysisProgress(this.$heapDumped.getUniqueId(), step, percent));
            }
            {
                this.$progressEventListener = function1;
                this.$heapDumped = heapDump;
            }
        };
        File heapDumpFile = heapDumped.getFile();
        long heapDumpDurationMillis = heapDumped.getDurationMillis();
        String heapDumpReason = heapDumped.getReason();
        HeapAnalysis heapAnalysis3 = heapAnalysis2 = heapDumpFile.exists() ? this.analyzeHeap(heapDumpFile, progressListener2, isCanceled) : (HeapAnalysis)this.missingFileFailure(heapDumpFile);
        if (heapAnalysis3 instanceof HeapAnalysisSuccess) {
            heapAnalysis = (HeapAnalysis)HeapAnalysisSuccess.copy$default((HeapAnalysisSuccess)((HeapAnalysisSuccess)heapAnalysis2), null, (long)0L, (long)heapDumpDurationMillis, (long)0L, (Map)MapsKt.plus((Map)((HeapAnalysisSuccess)heapAnalysis2).getMetadata(), (Pair)TuplesKt.to((Object)"Heap dump reason", (Object)heapDumpReason)), null, null, null, (int)235, null);
        } else if (heapAnalysis3 instanceof HeapAnalysisFailure) {
            Throwable failureCause;
            Throwable throwable = ((HeapAnalysisFailure)heapAnalysis2).getException().getCause();
            if (throwable == null) {
                Intrinsics.throwNpe();
            }
            heapAnalysis = (HeapAnalysis)((failureCause = throwable) instanceof OutOfMemoryError ? HeapAnalysisFailure.copy$default((HeapAnalysisFailure)((HeapAnalysisFailure)heapAnalysis2), null, (long)0L, (long)heapDumpDurationMillis, (long)0L, (HeapAnalysisException)new HeapAnalysisException((Throwable)new RuntimeException("Not enough memory to analyze heap. You can:\n- Kill the app then restart the analysis from the LeakCanary activity.\n- Increase the memory available to your debug app with largeHeap=true: https://developer.android.com/guide/topics/manifest/application-element#largeHeap\n- Set up LeakCanary to run in a separate process: https://square.github.io/leakcanary/recipes/#running-the-leakcanary-analysis-in-a-separate-process\n- Download the heap dump from the LeakCanary activity then run the analysis from your computer with shark-cli: https://square.github.io/leakcanary/shark/#shark-cli", failureCause)), (int)11, null) : HeapAnalysisFailure.copy$default((HeapAnalysisFailure)((HeapAnalysisFailure)heapAnalysis2), null, (long)0L, (long)heapDumpDurationMillis, (long)0L, null, (int)27, null));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        HeapAnalysis fullHeapAnalysis = heapAnalysis;
        progressListener2.onAnalysisProgress(OnAnalysisProgressListener.Step.REPORTING_HEAP_ANALYSIS);
        EventListener.Event.HeapAnalysisDone analysisDoneEvent2 = (EventListener.Event.HeapAnalysisDone)ScopedLeaksDb.INSTANCE.writableDatabase((Context)application, (Function1)new Function1<SQLiteDatabase, EventListener.Event.HeapAnalysisDone<? extends HeapAnalysis>>(heapAnalysis2, fullHeapAnalysis, heapDumped){
            final /* synthetic */ HeapAnalysis $heapAnalysis;
            final /* synthetic */ HeapAnalysis $fullHeapAnalysis;
            final /* synthetic */ EventListener.Event.HeapDump $heapDumped;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final EventListener.Event.HeapAnalysisDone<? extends HeapAnalysis> invoke(@NotNull SQLiteDatabase db) {
                EventListener.Event.HeapAnalysisDone heapAnalysisDone;
                Intrinsics.checkParameterIsNotNull((Object)db, (String)"db");
                long id2 = HeapAnalysisTable.INSTANCE.insert(db, this.$heapAnalysis);
                HeapAnalysis heapAnalysis = this.$fullHeapAnalysis;
                if (heapAnalysis instanceof HeapAnalysisSuccess) {
                    void $this$filterTo$iv$iv;
                    Map<String, Boolean> leakSignatureStatuses;
                    Intent showIntent = LeakActivity.Companion.createSuccessIntent((Context)AndroidDebugHeapAnalyzer.access$getApplication$p(AndroidDebugHeapAnalyzer.INSTANCE), id2);
                    Set leakSignatures2 = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)((HeapAnalysisSuccess)this.$fullHeapAnalysis).getAllLeaks(), (Function1)runAnalysisBlocking.analysisDoneEvent.leakSignatures.1.INSTANCE));
                    Map<String, Boolean> $this$filter$iv = leakSignatureStatuses = LeakTable.INSTANCE.retrieveLeakReadStatuses(db, leakSignatures2);
                    boolean $i$f$filter = false;
                    Map<String, Boolean> map = $this$filter$iv;
                    Map destination$iv$iv = new LinkedHashMap<K, V>();
                    boolean $i$f$filterTo = false;
                    void var14_13 = $this$filterTo$iv$iv;
                    boolean bl = false;
                    Iterator<Map.Entry<K, V>> iterator = var14_13.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<K, V> element$iv$iv;
                        Map.Entry<K, V> $dstr$_u24__u24$read = element$iv$iv = iterator.next();
                        boolean bl2 = false;
                        Map.Entry<K, V> entry = $dstr$_u24__u24$read;
                        boolean bl3 = false;
                        boolean read = (Boolean)entry.getValue();
                        if (!(!read)) continue;
                        destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                    }
                    Set unreadLeakSignatures = CollectionsKt.toSet((Iterable)destination$iv$iv.keySet());
                    heapAnalysisDone = new EventListener.Event.HeapAnalysisDone.HeapAnalysisSucceeded(this.$heapDumped.getUniqueId(), (HeapAnalysisSuccess)this.$fullHeapAnalysis, unreadLeakSignatures, showIntent);
                } else if (heapAnalysis instanceof HeapAnalysisFailure) {
                    Intent showIntent = LeakActivity.Companion.createFailureIntent((Context)AndroidDebugHeapAnalyzer.access$getApplication$p(AndroidDebugHeapAnalyzer.INSTANCE), id2);
                    heapAnalysisDone = new EventListener.Event.HeapAnalysisDone.HeapAnalysisFailed(this.$heapDumped.getUniqueId(), (HeapAnalysisFailure)this.$fullHeapAnalysis, showIntent);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                return heapAnalysisDone;
            }
            {
                this.$heapAnalysis = heapAnalysis;
                this.$fullHeapAnalysis = heapAnalysis2;
                this.$heapDumped = heapDump;
                super(1);
            }
        });
        LeakCanary.getConfig().getOnHeapAnalyzedListener().onHeapAnalyzed(fullHeapAnalysis);
        return analysisDoneEvent2;
    }

    public static /* synthetic */ EventListener.Event.HeapAnalysisDone runAnalysisBlocking$default(AndroidDebugHeapAnalyzer androidDebugHeapAnalyzer, EventListener.Event.HeapDump heapDump, Function0 function0, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function0 = runAnalysisBlocking.1.INSTANCE;
        }
        return androidDebugHeapAnalyzer.runAnalysisBlocking(heapDump, (Function0<Boolean>)function0, (Function1<? super EventListener.Event.HeapAnalysisProgress, Unit>)function1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final HeapAnalysis analyzeHeap(File heapDumpFile, OnAnalysisProgressListener progressListener2, Function0<Boolean> isCanceled) {
        HeapAnalysis heapAnalysis;
        Object object;
        ProguardMappingReader proguardMappingReader;
        LeakCanary.Config config = LeakCanary.getConfig();
        HeapAnalyzer heapAnalyzer = new HeapAnalyzer(progressListener2);
        try {
            InputStream inputStream = application.getAssets().open(PROGUARD_MAPPING_FILE_NAME);
            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"application.assets.open(\u2026OGUARD_MAPPING_FILE_NAME)");
            proguardMappingReader = new ProguardMappingReader(inputStream);
        }
        catch (IOException e) {
            proguardMappingReader = null;
        }
        ProguardMappingReader proguardMappingReader2 = proguardMappingReader;
        progressListener2.onAnalysisProgress(OnAnalysisProgressListener.Step.PARSING_HEAP_DUMP);
        ConstantMemoryMetricsDualSourceProvider sourceProvider2 = new ConstantMemoryMetricsDualSourceProvider((DualSourceProvider)new ThrowingCancelableFileSourceProvider(heapDumpFile, new Runnable(isCanceled){
            final /* synthetic */ Function0 $isCanceled;

            public final void run() {
                if (((Boolean)this.$isCanceled.invoke()).booleanValue()) {
                    throw (Throwable)new RuntimeException("Analysis canceled");
                }
            }
            {
                this.$isCanceled = function0;
            }
        }));
        try {
            ProguardMappingReader proguardMappingReader3 = proguardMappingReader2;
            object = HprofHeapGraph.Companion.openHeapGraph$default((HprofHeapGraph.Companion)HprofHeapGraph.Companion, (DualSourceProvider)((DualSourceProvider)sourceProvider2), (ProguardMapping)(proguardMappingReader3 != null ? proguardMappingReader3.readProguardMapping() : null), null, (int)2, null);
        }
        catch (Throwable throwable) {
            return (HeapAnalysis)new HeapAnalysisFailure(heapDumpFile, System.currentTimeMillis(), 0L, 0L, new HeapAnalysisException(throwable), 4, null);
        }
        CloseableHeapGraph closeableGraph = object;
        object = (Closeable)closeableGraph;
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            HeapAnalysis heapAnalysis2;
            Object graph = object;
            boolean bl3 = false;
            HeapAnalysis result = heapAnalyzer.analyze(heapDumpFile, (HeapGraph)graph, config.getLeakingObjectFinder(), config.getReferenceMatchers(), config.getComputeRetainedHeapSize(), config.getObjectInspectors(), config.getMetadataExtractor());
            if (result instanceof HeapAnalysisSuccess) {
                Object object2 = graph;
                if (object2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type shark.HprofHeapGraph");
                }
                String lruCacheStats = ((HprofHeapGraph)object2).lruCacheStats();
                String randomAccessStats = "RandomAccess[" + "bytes=" + sourceProvider2.getRandomAccessByteReads() + ',' + "reads=" + sourceProvider2.getRandomAccessReadCount() + ',' + "travel=" + sourceProvider2.getRandomAccessByteTravel() + ',' + "range=" + sourceProvider2.getByteTravelRange() + ',' + "size=" + heapDumpFile.length() + "]";
                String stats = lruCacheStats + ' ' + randomAccessStats;
                heapAnalysis2 = (HeapAnalysis)HeapAnalysisSuccess.copy$default((HeapAnalysisSuccess)((HeapAnalysisSuccess)result), null, (long)0L, (long)0L, (long)0L, (Map)MapsKt.plus((Map)((HeapAnalysisSuccess)result).getMetadata(), (Pair)TuplesKt.to((Object)"Stats", (Object)stats)), null, null, null, (int)239, null);
            } else {
                heapAnalysis2 = result;
            }
            heapAnalysis = heapAnalysis2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        return heapAnalysis;
    }

    private final HeapAnalysisFailure missingFileFailure(File heapDumpFile) {
        String deletedReason = LeakDirectoryProvider.Companion.hprofDeleteReason(heapDumpFile);
        IllegalStateException exception = new IllegalStateException("Hprof file " + heapDumpFile + " missing, deleted because: " + deletedReason);
        return new HeapAnalysisFailure(heapDumpFile, System.currentTimeMillis(), 0L, 0L, new HeapAnalysisException((Throwable)exception), 4, null);
    }

    private AndroidDebugHeapAnalyzer() {
    }

    static {
        AndroidDebugHeapAnalyzer androidDebugHeapAnalyzer;
        INSTANCE = androidDebugHeapAnalyzer = new AndroidDebugHeapAnalyzer();
        application = InternalLeakCanary.INSTANCE.getApplication();
    }

    public static final /* synthetic */ Application access$getApplication$p(AndroidDebugHeapAnalyzer $this) {
        AndroidDebugHeapAnalyzer androidDebugHeapAnalyzer = $this;
        return application;
    }
}

