/*
 * Decompiled with CFR 0.152.
 */
package leakcanary;

import android.app.Activity;
import android.app.Application;
import com.squareup.leakcanary.core.R;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import leakcanary.EventListener;
import leakcanary.internal.HandlersKt;
import leakcanary.internal.InternalLeakCanary;
import leakcanary.internal.activity.LeakActivity;
import leakcanary.internal.tv.TvToast;
import org.jetbrains.annotations.NotNull;
import shark.HeapAnalysis;
import shark.HeapAnalysisFailure;
import shark.HeapAnalysisSuccess;
import shark.SharkLog;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\u0006H\u0002J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lleakcanary/TvEventListener;", "Lleakcanary/EventListener;", "()V", "appContext", "Landroid/app/Application;", "onEvent", "", "event", "Lleakcanary/EventListener$Event;", "printIntentInfo", "showToast", "heapAnalysis", "Lshark/HeapAnalysis;", "leakcanary-android-core_release"})
public final class TvEventListener
implements EventListener {
    private static final Application appContext;
    @NotNull
    public static final TvEventListener INSTANCE;

    @Override
    public void onEvent(@NotNull EventListener.Event event) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            EventListener.Event event2 = event;
            if (!(event2 instanceof EventListener.Event.HeapAnalysisDone)) break block0;
            this.showToast((HeapAnalysis)((EventListener.Event.HeapAnalysisDone)event).getHeapAnalysis());
            this.printIntentInfo();
        }
    }

    private final void showToast(HeapAnalysis heapAnalysis) {
        boolean $i$f$getMainHandler = false;
        HandlersKt.getMainHandler().post(new Runnable(heapAnalysis){
            final /* synthetic */ HeapAnalysis $heapAnalysis;

            public final void run() {
                String string2;
                Activity activity = InternalLeakCanary.INSTANCE.getResumedActivity();
                if (activity == null) {
                    return;
                }
                Activity resumedActivity = activity;
                HeapAnalysis heapAnalysis = this.$heapAnalysis;
                if (heapAnalysis instanceof HeapAnalysisSuccess) {
                    String string3 = TvEventListener.access$getAppContext$p(TvEventListener.INSTANCE).getString(R.string.leak_canary_tv_analysis_success, new Object[]{((HeapAnalysisSuccess)this.$heapAnalysis).getApplicationLeaks().size(), ((HeapAnalysisSuccess)this.$heapAnalysis).getLibraryLeaks().size()});
                    string2 = string3;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"appContext.getString(\n  \u2026aryLeaks.size\n          )");
                } else if (heapAnalysis instanceof HeapAnalysisFailure) {
                    String string4 = TvEventListener.access$getAppContext$p(TvEventListener.INSTANCE).getString(R.string.leak_canary_tv_analysis_failure);
                    string2 = string4;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"appContext.getString(R.s\u2026nary_tv_analysis_failure)");
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                String message = string2;
                TvToast.INSTANCE.makeText(resumedActivity, message).show();
            }
            {
                this.$heapAnalysis = heapAnalysis;
            }
        });
    }

    private final void printIntentInfo() {
        Class<LeakActivity> leakClass = LeakActivity.class;
        SharkLog this_$iv = SharkLog.INSTANCE;
        boolean $i$f$d = false;
        SharkLog.Logger logger = this_$iv.getLogger();
        if (logger == null) {
        } else {
            SharkLog.Logger logger$iv;
            SharkLog.Logger logger2 = logger$iv = logger;
            boolean bl = false;
            Package package_ = leakClass.getPackage();
            String string2 = StringsKt.trimIndent((String)("\n      ====================================\n      ANDROID TV LAUNCH INTENT\n      ====================================\n      Run the following adb command to display the list of leaks:\n\n      adb shell am start -n \"" + appContext.getPackageName() + '/' + (package_ != null ? package_.getName() : null) + ".LeakLauncherActivity\"\n      ===================================="));
            logger2.d(string2);
        }
    }

    private TvEventListener() {
    }

    static {
        TvEventListener tvEventListener;
        INSTANCE = tvEventListener = new TvEventListener();
        appContext = InternalLeakCanary.INSTANCE.getApplication();
    }

    public static final /* synthetic */ Application access$getAppContext$p(TvEventListener $this) {
        TvEventListener tvEventListener = $this;
        return appContext;
    }
}

