/*
 * Decompiled with CFR 0.152.
 */
package leakcanary.internal.tv;

import android.app.Activity;
import android.app.Application;
import com.squareup.leakcanary.core.R;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import leakcanary.LeakCanary;
import leakcanary.internal.HandlersKt;
import leakcanary.internal.InternalLeakCanary;
import leakcanary.internal.OnRetainInstanceListener;
import leakcanary.internal.RetainInstanceEvent;
import leakcanary.internal.tv.TvToast;
import org.jetbrains.annotations.NotNull;
import shark.SharkLog;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lleakcanary/internal/tv/TvOnRetainInstanceListener;", "Lleakcanary/internal/OnRetainInstanceListener;", "application", "Landroid/app/Application;", "(Landroid/app/Application;)V", "onEvent", "", "event", "Lleakcanary/internal/RetainInstanceEvent;", "leakcanary-android-core_release"})
public final class TvOnRetainInstanceListener
implements OnRetainInstanceListener {
    private final Application application;

    @Override
    public void onEvent(@NotNull RetainInstanceEvent event) {
        String string2;
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        RetainInstanceEvent retainInstanceEvent = event;
        if (Intrinsics.areEqual((Object)retainInstanceEvent, (Object)RetainInstanceEvent.NoMoreObjects.INSTANCE)) {
            string2 = this.application.getString(R.string.leak_canary_notification_no_retained_object_title);
        } else if (retainInstanceEvent instanceof RetainInstanceEvent.CountChanged.BelowThreshold) {
            string2 = this.application.getString(R.string.leak_canary_tv_toast_retained_objects, new Object[]{((RetainInstanceEvent.CountChanged.BelowThreshold)event).getRetainedCount(), LeakCanary.getConfig().getRetainedVisibleThreshold()});
        } else if (retainInstanceEvent instanceof RetainInstanceEvent.CountChanged.DumpingDisabled) {
            string2 = ((RetainInstanceEvent.CountChanged.DumpingDisabled)event).getReason();
        } else if (retainInstanceEvent instanceof RetainInstanceEvent.CountChanged.DumpHappenedRecently) {
            string2 = this.application.getString(R.string.leak_canary_notification_retained_dump_wait);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"when (event) {\n      NoM\u2026_dump_wait)\n      }\n    }");
        String message = string2;
        SharkLog this_$iv = SharkLog.INSTANCE;
        boolean $i$f$d = false;
        SharkLog.Logger logger = this_$iv.getLogger();
        if (logger == null) {
        } else {
            SharkLog.Logger logger$iv;
            SharkLog.Logger logger2 = logger$iv = logger;
            boolean bl = false;
            String string3 = message;
            logger2.d(string3);
        }
        boolean $i$f$getMainHandler = false;
        HandlersKt.getMainHandler().post(new Runnable(message){
            final /* synthetic */ String $message;

            public final void run() {
                Activity activity = InternalLeakCanary.INSTANCE.getResumedActivity();
                if (activity == null) {
                    return;
                }
                Activity resumedActivity = activity;
                TvToast.INSTANCE.makeText(resumedActivity, this.$message).show();
            }
            {
                this.$message = string2;
            }
        });
    }

    public TvOnRetainInstanceListener(@NotNull Application application2) {
        Intrinsics.checkParameterIsNotNull((Object)application2, (String)"application");
        this.application = application2;
    }
}

