/*
 * Decompiled with CFR 0.152.
 */
package leakcanary.internal.navigation;

import android.app.ActionBar;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AnimationUtils;
import com.squareup.leakcanary.core.R;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import leakcanary.internal.navigation.BackstackFrame;
import leakcanary.internal.navigation.NavigatingActivity;
import leakcanary.internal.navigation.Screen;
import leakcanary.internal.navigation.ViewsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b \u0018\u0000 ,2\u00020\u0001:\u0001,B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0015\u001a\u00020\nH\u0016J\u0006\u0010\u0016\u001a\u00020\u0010J\u000e\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\nJ\u0018\u0010\u0019\u001a\u00020\u00102\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0007\u001a\u00020\bJ\b\u0010\u001c\u001a\u00020\u0010H\u0016J\u0010\u0010\r\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u000fH\u0016J\b\u0010\u001f\u001a\u00020\u0010H\u0014J\u0010\u0010 \u001a\u00020\u00102\u0006\u0010!\u001a\u00020\"H\u0014J\u0010\u0010#\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\nH\u0014J\u0010\u0010$\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020\u00102\u0006\u0010(\u001a\u00020\u001bH\u0016J\u0006\u0010)\u001a\u00020\u0010J\u000e\u0010*\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\nJ\b\u0010+\u001a\u00020\u0010H\u0002R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R&\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006-"}, d2={"Lleakcanary/internal/navigation/NavigatingActivity;", "Landroid/app/Activity;", "()V", "backstack", "Ljava/util/ArrayList;", "Lleakcanary/internal/navigation/BackstackFrame;", "Lkotlin/collections/ArrayList;", "container", "Landroid/view/ViewGroup;", "currentScreen", "Lleakcanary/internal/navigation/Screen;", "currentView", "Landroid/view/View;", "onCreateOptionsMenu", "Lkotlin/Function1;", "Landroid/view/Menu;", "", "getOnCreateOptionsMenu", "()Lkotlin/jvm/functions/Function1;", "setOnCreateOptionsMenu", "(Lkotlin/jvm/functions/Function1;)V", "getLauncherScreen", "goBack", "goTo", "screen", "installNavigation", "savedInstanceState", "Landroid/os/Bundle;", "onBackPressed", "", "menu", "onDestroy", "onNewIntent", "intent", "Landroid/content/Intent;", "onNewScreen", "onOptionsItemSelected", "item", "Landroid/view/MenuItem;", "onSaveInstanceState", "outState", "refreshCurrentScreen", "resetTo", "screenUpdated", "Companion", "leakcanary-android-core_release"})
public abstract class NavigatingActivity
extends Activity {
    private ArrayList<BackstackFrame> backstack;
    private Screen currentScreen;
    private ViewGroup container;
    private View currentView;
    @NotNull
    private Function1<? super Menu, Unit> onCreateOptionsMenu = NO_MENU;
    @NotNull
    private static final Function1<Menu, Unit> NO_MENU;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final Function1<Menu, Unit> getOnCreateOptionsMenu() {
        return this.onCreateOptionsMenu;
    }

    public final void setOnCreateOptionsMenu(@NotNull Function1<? super Menu, Unit> function1) {
        Intrinsics.checkParameterIsNotNull(function1, (String)"<set-?>");
        this.onCreateOptionsMenu = function1;
    }

    /*
     * WARNING - void declaration
     */
    public final void installNavigation(@Nullable Bundle savedInstanceState, @NotNull ViewGroup container) {
        Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
        this.container = container;
        if (savedInstanceState == null) {
            Screen screen;
            this.backstack = new ArrayList();
            NavigatingActivity navigatingActivity = this;
            if (this.getIntent().hasExtra("screens")) {
                void $this$forEach$iv;
                Serializable serializable = this.getIntent().getSerializableExtra("screens");
                if (serializable == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.List<leakcanary.internal.navigation.Screen>");
                }
                List screens = (List)((Object)serializable);
                Iterable iterable = CollectionsKt.dropLast((List)screens, (int)1);
                NavigatingActivity navigatingActivity2 = navigatingActivity;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Screen screen2 = (Screen)element$iv;
                    boolean bl = false;
                    ArrayList<BackstackFrame> arrayList = this.backstack;
                    if (arrayList == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"backstack");
                    }
                    arrayList.add(new BackstackFrame(screen2));
                }
                navigatingActivity = navigatingActivity2;
                screen = (Screen)CollectionsKt.last((List)screens);
            } else {
                screen = this.getLauncherScreen();
            }
            navigatingActivity.currentScreen = screen;
        } else {
            Serializable serializable = savedInstanceState.getSerializable("currentScreen");
            if (serializable == null) {
                throw new TypeCastException("null cannot be cast to non-null type leakcanary.internal.navigation.Screen");
            }
            this.currentScreen = (Screen)serializable;
            ArrayList arrayList = savedInstanceState.getParcelableArrayList("backstack");
            if (arrayList == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.ArrayList<leakcanary.internal.navigation.BackstackFrame> /* = java.util.ArrayList<leakcanary.internal.navigation.BackstackFrame> */");
            }
            this.backstack = arrayList;
        }
        Screen screen = this.currentScreen;
        if (screen == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentScreen");
        }
        View view = this.currentView = screen.createView(container);
        if (view == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentView");
        }
        container.addView(view);
        ActionBar actionBar = this.getActionBar();
        if (actionBar != null) {
            ActionBar actionBar2 = actionBar;
            boolean bl = false;
            boolean bl2 = false;
            ActionBar $this$run = actionBar2;
            boolean bl3 = false;
            $this$run.setHomeButtonEnabled(true);
            $this$run.setDisplayHomeAsUpEnabled(true);
        }
        this.screenUpdated();
    }

    protected void onNewIntent(@NotNull Intent intent) {
        Intrinsics.checkParameterIsNotNull((Object)intent, (String)"intent");
        if (intent.hasExtra("screens")) {
            Serializable serializable = intent.getSerializableExtra("screens");
            if (serializable == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.List<leakcanary.internal.navigation.Screen>");
            }
            List screens = (List)((Object)serializable);
            Serializable serializable2 = intent.getSerializableExtra("screen");
            if (serializable2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type leakcanary.internal.navigation.Screen");
            }
            this.goTo((Screen)serializable2);
            ArrayList<BackstackFrame> arrayList = this.backstack;
            if (arrayList == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"backstack");
            }
            arrayList.clear();
            Iterable $this$forEach$iv = CollectionsKt.dropLast((List)screens, (int)1);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Screen screen = (Screen)element$iv;
                boolean bl = false;
                ArrayList<BackstackFrame> arrayList2 = this.backstack;
                if (arrayList2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"backstack");
                }
                arrayList2.add(new BackstackFrame(screen));
            }
        }
    }

    @NotNull
    public Screen getLauncherScreen() {
        String string2 = "Launcher activities should override getLauncherScreen()";
        boolean bl = false;
        throw (Throwable)new NotImplementedError("An operation is not implemented: " + string2);
    }

    public void onSaveInstanceState(@NotNull Bundle outState) {
        Intrinsics.checkParameterIsNotNull((Object)outState, (String)"outState");
        super.onSaveInstanceState(outState);
        Screen screen = this.currentScreen;
        if (screen == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentScreen");
        }
        outState.putSerializable("currentScreen", (Serializable)screen);
        ArrayList<BackstackFrame> arrayList = this.backstack;
        if (arrayList == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"backstack");
        }
        outState.putParcelableArrayList("backstack", arrayList);
    }

    public void onBackPressed() {
        ArrayList<BackstackFrame> arrayList = this.backstack;
        if (arrayList == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"backstack");
        }
        if (arrayList.size() > 0) {
            this.goBack();
            return;
        }
        super.onBackPressed();
    }

    public final void resetTo(@NotNull Screen screen) {
        Intrinsics.checkParameterIsNotNull((Object)screen, (String)"screen");
        this.onCreateOptionsMenu = NO_MENU;
        View view = this.currentView;
        if (view == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentView");
        }
        view.startAnimation(AnimationUtils.loadAnimation((Context)((Context)this), (int)R.anim.leak_canary_exit_alpha));
        ViewGroup viewGroup = this.container;
        if (viewGroup == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"container");
        }
        View view2 = this.currentView;
        if (view2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentView");
        }
        viewGroup.removeView(view2);
        View view3 = this.currentView;
        if (view3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentView");
        }
        ViewsKt.notifyScreenExiting(view3);
        ArrayList<BackstackFrame> arrayList = this.backstack;
        if (arrayList == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"backstack");
        }
        arrayList.clear();
        Screen screen2 = this.currentScreen = screen;
        if (screen2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentScreen");
        }
        ViewGroup viewGroup2 = this.container;
        if (viewGroup2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"container");
        }
        View view4 = this.currentView = screen2.createView(viewGroup2);
        if (view4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentView");
        }
        view4.startAnimation(AnimationUtils.loadAnimation((Context)((Context)this), (int)R.anim.leak_canary_enter_alpha));
        ViewGroup viewGroup3 = this.container;
        if (viewGroup3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"container");
        }
        View view5 = this.currentView;
        if (view5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentView");
        }
        viewGroup3.addView(view5);
        this.screenUpdated();
    }

    public final void goTo(@NotNull Screen screen) {
        Intrinsics.checkParameterIsNotNull((Object)screen, (String)"screen");
        this.onCreateOptionsMenu = NO_MENU;
        View view = this.currentView;
        if (view == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentView");
        }
        view.startAnimation(AnimationUtils.loadAnimation((Context)((Context)this), (int)R.anim.leak_canary_exit_forward));
        ViewGroup viewGroup = this.container;
        if (viewGroup == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"container");
        }
        View view2 = this.currentView;
        if (view2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentView");
        }
        viewGroup.removeView(view2);
        View view3 = this.currentView;
        if (view3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentView");
        }
        ViewsKt.notifyScreenExiting(view3);
        Screen screen2 = this.currentScreen;
        if (screen2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentScreen");
        }
        View view4 = this.currentView;
        if (view4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentView");
        }
        BackstackFrame backstackFrame = new BackstackFrame(screen2, view4);
        ArrayList<BackstackFrame> arrayList = this.backstack;
        if (arrayList == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"backstack");
        }
        arrayList.add(backstackFrame);
        Screen screen3 = this.currentScreen = screen;
        if (screen3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentScreen");
        }
        ViewGroup viewGroup2 = this.container;
        if (viewGroup2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"container");
        }
        View view5 = this.currentView = screen3.createView(viewGroup2);
        if (view5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentView");
        }
        view5.startAnimation(AnimationUtils.loadAnimation((Context)((Context)this), (int)R.anim.leak_canary_enter_forward));
        ViewGroup viewGroup3 = this.container;
        if (viewGroup3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"container");
        }
        View view6 = this.currentView;
        if (view6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentView");
        }
        viewGroup3.addView(view6);
        this.screenUpdated();
    }

    public final void refreshCurrentScreen() {
        this.onCreateOptionsMenu = NO_MENU;
        ViewGroup viewGroup = this.container;
        if (viewGroup == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"container");
        }
        View view = this.currentView;
        if (view == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentView");
        }
        viewGroup.removeView(view);
        View view2 = this.currentView;
        if (view2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentView");
        }
        ViewsKt.notifyScreenExiting(view2);
        Screen screen = this.currentScreen;
        if (screen == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentScreen");
        }
        ViewGroup viewGroup2 = this.container;
        if (viewGroup2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"container");
        }
        this.currentView = screen.createView(viewGroup2);
        ViewGroup viewGroup3 = this.container;
        if (viewGroup3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"container");
        }
        View view3 = this.currentView;
        if (view3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentView");
        }
        viewGroup3.addView(view3);
        this.screenUpdated();
    }

    public final void goBack() {
        this.onCreateOptionsMenu = NO_MENU;
        View view = this.currentView;
        if (view == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentView");
        }
        view.startAnimation(AnimationUtils.loadAnimation((Context)((Context)this), (int)R.anim.leak_canary_exit_backward));
        ViewGroup viewGroup = this.container;
        if (viewGroup == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"container");
        }
        View view2 = this.currentView;
        if (view2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentView");
        }
        viewGroup.removeView(view2);
        View view3 = this.currentView;
        if (view3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentView");
        }
        ViewsKt.notifyScreenExiting(view3);
        ArrayList<BackstackFrame> arrayList = this.backstack;
        if (arrayList == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"backstack");
        }
        ArrayList<BackstackFrame> arrayList2 = this.backstack;
        if (arrayList2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"backstack");
        }
        BackstackFrame backstackFrame = arrayList.remove(arrayList2.size() - 1);
        Intrinsics.checkExpressionValueIsNotNull((Object)backstackFrame, (String)"backstack.removeAt(backstack.size - 1)");
        BackstackFrame latest = backstackFrame;
        Screen screen = this.currentScreen = latest.getScreen();
        if (screen == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentScreen");
        }
        ViewGroup viewGroup2 = this.container;
        if (viewGroup2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"container");
        }
        View view4 = this.currentView = screen.createView(viewGroup2);
        if (view4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentView");
        }
        view4.startAnimation(AnimationUtils.loadAnimation((Context)((Context)this), (int)R.anim.leak_canary_enter_backward));
        ViewGroup viewGroup3 = this.container;
        if (viewGroup3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"container");
        }
        View view5 = this.currentView;
        if (view5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentView");
        }
        viewGroup3.addView(view5, 0);
        View view6 = this.currentView;
        if (view6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentView");
        }
        latest.restore(view6);
        this.screenUpdated();
    }

    private final void screenUpdated() {
        this.invalidateOptionsMenu();
        if (Build.VERSION.SDK_INT >= 18) {
            ActionBar actionBar = this.getActionBar();
            if (actionBar != null) {
                ActionBar actionBar2 = actionBar;
                boolean bl = false;
                boolean bl2 = false;
                ActionBar $this$run = actionBar2;
                boolean bl3 = false;
                ArrayList<BackstackFrame> arrayList = this.backstack;
                if (arrayList == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"backstack");
                }
                boolean goBack = arrayList.size() > 0;
                int indicator = goBack ? 0 : 17301560;
                $this$run.setHomeAsUpIndicator(indicator);
            }
        }
        Screen screen = this.currentScreen;
        if (screen == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentScreen");
        }
        this.onNewScreen(screen);
    }

    protected void onNewScreen(@NotNull Screen screen) {
        Intrinsics.checkParameterIsNotNull((Object)screen, (String)"screen");
    }

    public boolean onCreateOptionsMenu(@NotNull Menu menu) {
        Intrinsics.checkParameterIsNotNull((Object)menu, (String)"menu");
        this.onCreateOptionsMenu.invoke((Object)menu);
        return true;
    }

    public boolean onOptionsItemSelected(@NotNull MenuItem item) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        switch (item.getItemId()) {
            case 16908332: {
                this.onBackPressed();
                bl = true;
                break;
            }
            default: {
                bl = super.onOptionsItemSelected(item);
            }
        }
        return bl;
    }

    protected void onDestroy() {
        super.onDestroy();
        View view = this.currentView;
        if (view == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentView");
        }
        ViewsKt.notifyScreenExiting(view);
    }

    static {
        Companion = new Companion(null);
        NO_MENU = Companion.NO_MENU.1.INSTANCE;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lleakcanary/internal/navigation/NavigatingActivity$Companion;", "", "()V", "NO_MENU", "Lkotlin/Function1;", "Landroid/view/Menu;", "", "getNO_MENU", "()Lkotlin/jvm/functions/Function1;", "leakcanary-android-core_release"})
    public static final class Companion {
        @NotNull
        public final Function1<Menu, Unit> getNO_MENU() {
            return NO_MENU;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

