/*
 * Decompiled with CFR 0.152.
 */
package leakcanary.internal.activity.screen;

import android.app.ActivityManager;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.squareup.leakcanary.core.R;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import leakcanary.internal.activity.LeakActivity;
import leakcanary.internal.activity.db.Db;
import leakcanary.internal.activity.db.DbKt;
import leakcanary.internal.activity.db.HeapAnalysisTable;
import leakcanary.internal.activity.screen.HeapAnalysisFailureScreen;
import leakcanary.internal.activity.screen.HeapDumpScreen;
import leakcanary.internal.activity.screen.HeapDumpsScreen;
import leakcanary.internal.activity.screen.HeapDumpsScreen$createView$;
import leakcanary.internal.activity.ui.SimpleListAdapter;
import leakcanary.internal.activity.ui.TimeFormatter;
import leakcanary.internal.navigation.NavigatingActivity;
import leakcanary.internal.navigation.Screen;
import leakcanary.internal.navigation.ViewsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001a\u0010\u0007\u001a\u00020\b*\u00020\u00042\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002\u00a8\u0006\f"}, d2={"Lleakcanary/internal/activity/screen/HeapDumpsScreen;", "Lleakcanary/internal/navigation/Screen;", "()V", "createView", "Landroid/view/View;", "container", "Landroid/view/ViewGroup;", "onAnalysesRetrieved", "", "projections", "", "Lleakcanary/internal/activity/db/HeapAnalysisTable$Projection;", "leakcanary-android-core_release"})
public final class HeapDumpsScreen
extends Screen {
    @Override
    @NotNull
    public View createView(@NotNull ViewGroup container) {
        Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
        View view = ViewsKt.inflate(container, R.layout.leak_canary_heap_dumps_screen);
        boolean bl = false;
        boolean bl2 = false;
        View $this$apply = view;
        boolean bl3 = false;
        Function0<Unit> unsubscribeRefresh2 = HeapAnalysisTable.INSTANCE.onUpdate((Function0<Unit>)((Function0)new Function0<Unit>($this$apply){
            final /* synthetic */ View $this_apply;

            public final void invoke() {
                ((NavigatingActivity)((Object)ViewsKt.activity(this.$this_apply))).refreshCurrentScreen();
            }
            {
                this.$this_apply = view;
                super(0);
            }
        }));
        ViewsKt.onScreenExiting($this$apply, (Function0<Unit>)((Function0)new Function0<Unit>(unsubscribeRefresh2){
            final /* synthetic */ Function0 $unsubscribeRefresh;

            public final void invoke() {
                this.$unsubscribeRefresh.invoke();
            }
            {
                this.$unsubscribeRefresh = function0;
                super(0);
            }
        }));
        ViewsKt.onCreateOptionsMenu($this$apply, (Function1<? super Menu, Unit>)((Function1)new Function1<Menu, Unit>($this$apply){
            final /* synthetic */ View $this_apply;

            public final void invoke(@NotNull Menu menu) {
                Intrinsics.checkParameterIsNotNull((Object)menu, (String)"menu");
                if (!ActivityManager.isUserAMonkey()) {
                    menu.add(R.string.leak_canary_delete_all).setOnMenuItemClickListener(new MenuItem.OnMenuItemClickListener(this){
                        final /* synthetic */ createView.1.2 this$0;

                        public final boolean onMenuItemClick(MenuItem it) {
                            new AlertDialog.Builder(this.this$0.$this_apply.getContext()).setIcon(17301543).setTitle(R.string.leak_canary_delete_all).setMessage(R.string.leak_canary_delete_all_leaks_title).setPositiveButton(17039370, new DialogInterface.OnClickListener(this){
                                final /* synthetic */ createView.1.1 this$0;

                                public final void onClick(DialogInterface $noName_0, int $noName_1) {
                                    DbKt.executeOnDb(this.this$0.this$0.$this_apply, (Function1<? super Db.OnDb, Unit>)((Function1)createView.1.1.INSTANCE));
                                }
                                {
                                    this.this$0 = var1_1;
                                }
                            }).setNegativeButton(0x1040000, null).show();
                            return true;
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                }
            }
            {
                this.$this_apply = view;
                super(1);
            }
        }));
        $this$apply.findViewById(R.id.leak_canary_import_heap_dump).setOnClickListener(new View.OnClickListener($this$apply){
            final /* synthetic */ View $this_apply;

            public final void onClick(View it) {
                ((LeakActivity)((Object)ViewsKt.activity(this.$this_apply))).requestImportHprof();
            }
            {
                this.$this_apply = view;
            }
        });
        $this$apply.findViewById(R.id.leak_canary_dump_heap_now).setOnClickListener((View.OnClickListener)createView.1.4.INSTANCE);
        DbKt.executeOnDb($this$apply, (Function1<? super Db.OnDb, Unit>)((Function1)new Function1<Db.OnDb, Unit>(this){
            final /* synthetic */ HeapDumpsScreen this$0;
            {
                this.this$0 = heapDumpsScreen;
                super(1);
            }

            public final void invoke(@NotNull Db.OnDb $this$executeOnDb) {
                Intrinsics.checkParameterIsNotNull((Object)$this$executeOnDb, (String)"$receiver");
                List<HeapAnalysisTable.Projection> projections = HeapAnalysisTable.INSTANCE.retrieveAll($this$executeOnDb.getDb());
                $this$executeOnDb.updateUi((Function1<? super View, Unit>)((Function1)new Function1<View, Unit>(this, projections){
                    final /* synthetic */ createView$$inlined$apply$lambda$1 this$0;
                    final /* synthetic */ List $projections;
                    {
                        this.this$0 = var1_1;
                        this.$projections = list;
                        super(1);
                    }

                    public final void invoke(@NotNull View $this$updateUi) {
                        Intrinsics.checkParameterIsNotNull((Object)$this$updateUi, (String)"$receiver");
                        HeapDumpsScreen.access$onAnalysesRetrieved(this.this$0.this$0, $this$updateUi, this.$projections);
                    }
                }));
            }
        }));
        return view;
    }

    private final void onAnalysesRetrieved(View $this$onAnalysesRetrieved, List<HeapAnalysisTable.Projection> projections) {
        ViewsKt.getActivity($this$onAnalysesRetrieved).setTitle((CharSequence)$this$onAnalysesRetrieved.getResources().getString(R.string.leak_canary_heap_analysis_list_screen_title, new Object[]{projections.size()}));
        ListView listView = (ListView)$this$onAnalysesRetrieved.findViewById(R.id.leak_canary_list);
        listView.setOnItemClickListener(new AdapterView.OnItemClickListener($this$onAnalysesRetrieved, projections){
            final /* synthetic */ View $this_onAnalysesRetrieved;
            final /* synthetic */ List $projections;

            public final void onItemClick(AdapterView<?> $noName_0, View $noName_1, int position, long $noName_3) {
                HeapAnalysisTable.Projection projection = (HeapAnalysisTable.Projection)this.$projections.get(position);
                Screen analysisScreen = projection.getExceptionSummary() != null ? (Screen)new HeapAnalysisFailureScreen(projection.getId()) : (Screen)new HeapDumpScreen(projection.getId());
                ViewsKt.goTo(this.$this_onAnalysesRetrieved, analysisScreen);
            }
            {
                this.$this_onAnalysesRetrieved = view;
                this.$projections = list;
            }
        });
        ListView listView2 = listView;
        Intrinsics.checkExpressionValueIsNotNull((Object)listView2, (String)"listView");
        listView2.setAdapter((ListAdapter)new SimpleListAdapter<HeapAnalysisTable.Projection>(R.layout.leak_canary_leak_row, projections, (Function3)new Function3<SimpleListAdapter<HeapAnalysisTable.Projection>, View, Integer, Unit>($this$onAnalysesRetrieved){
            final /* synthetic */ View $this_onAnalysesRetrieved;

            public final void invoke(@NotNull SimpleListAdapter<HeapAnalysisTable.Projection> $receiver, @NotNull View view, int position) {
                TextView goneView;
                Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
                TextView textView = goneView = (TextView)view.findViewById(R.id.leak_canary_count_text);
                Intrinsics.checkExpressionValueIsNotNull((Object)textView, (String)"goneView");
                textView.setVisibility(8);
                TextView timeView = (TextView)view.findViewById(R.id.leak_canary_leak_text);
                TextView countView = (TextView)view.findViewById(R.id.leak_canary_time_text);
                HeapAnalysisTable.Projection projection = $receiver.getItem(position);
                TextView textView2 = countView;
                Intrinsics.checkExpressionValueIsNotNull((Object)textView2, (String)"countView");
                textView2.setEnabled(false);
                TextView textView3 = timeView;
                Intrinsics.checkExpressionValueIsNotNull((Object)textView3, (String)"timeView");
                Context context = view.getContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"view.context");
                textView3.setText((CharSequence)TimeFormatter.INSTANCE.formatTimestamp(context, projection.getCreatedAtTimeMillis()));
                String string2 = projection.getExceptionSummary();
                if (string2 == null) {
                    String string3 = this.$this_onAnalysesRetrieved.getResources().getQuantityString(R.plurals.leak_canary_distinct_leaks, projection.getLeakCount(), new Object[]{projection.getLeakCount()});
                    string2 = string3;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"resources.getQuantityStr\u2026ction.leakCount\n        )");
                }
                String count = string2;
                countView.setText((CharSequence)count);
            }
            {
                this.$this_onAnalysesRetrieved = view;
                super(3);
            }
        }));
    }

    public static final /* synthetic */ void access$onAnalysesRetrieved(HeapDumpsScreen $this, View $this$access_u24onAnalysesRetrieved, List projections) {
        $this.onAnalysesRetrieved($this$access_u24onAnalysesRetrieved, projections);
    }
}

