/*
 * Decompiled with CFR 0.152.
 */
package leakcanary.internal.activity.screen;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import com.squareup.leakcanary.core.R;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import leakcanary.internal.navigation.ViewsKt;
import org.jetbrains.annotations.NotNull;
import shark.HprofRecord;
import shark.OnHprofRecordListener;
import shark.StreamingHprofReader;
import shark.StreamingRecordReaderAdapter;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\rB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n\u00a8\u0006\u000e"}, d2={"Lleakcanary/internal/activity/screen/HeapDumpRenderer;", "", "()V", "render", "Landroid/graphics/Bitmap;", "context", "Landroid/content/Context;", "heapDumpFile", "Ljava/io/File;", "sourceWidth", "", "sourceHeight", "sourceBytesPerPixel", "HasDensity", "leakcanary-android-core_release"})
public final class HeapDumpRenderer {
    @NotNull
    public static final HeapDumpRenderer INSTANCE;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Bitmap render(@NotNull Context context, @NotNull File heapDumpFile, int sourceWidth, int sourceHeight, int sourceBytesPerPixel) {
        int n;
        float padding;
        void currentRecord;
        void lastPosition;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)heapDumpFile, (String)"heapDumpFile");
        Resources resources = context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        HasDensity hasDensity = new HasDensity(resources);
        boolean bl = false;
        boolean bl2 = false;
        HasDensity $this$with = hasDensity;
        boolean bl3 = false;
        boolean bl4 = false;
        List recordPositions = new ArrayList();
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        int otherColor = ViewsKt.getColorCompat(context, R.color.leak_canary_heap_other);
        int stackTraceColor = ViewsKt.getColorCompat(context, R.color.leak_canary_heap_stack_trace);
        int hprofStringColor = ViewsKt.getColorCompat(context, R.color.leak_canary_heap_hprof_string);
        int loadClassColor = ViewsKt.getColorCompat(context, R.color.leak_canary_heap_load_class);
        int classDumpColor = ViewsKt.getColorCompat(context, R.color.leak_canary_heap_class_dump);
        int instanceColor = ViewsKt.getColorCompat(context, R.color.leak_canary_heap_instance);
        int objectArrayColor = ViewsKt.getColorCompat(context, R.color.leak_canary_heap_object_array);
        int booleanArrayColor = ViewsKt.getColorCompat(context, R.color.leak_canary_heap_boolean_array);
        int charArrayColor = ViewsKt.getColorCompat(context, R.color.leak_canary_heap_char_array);
        int floatArrayColor = ViewsKt.getColorCompat(context, R.color.leak_canary_heap_float_array);
        int doubleArrayColor = ViewsKt.getColorCompat(context, R.color.leak_canary_heap_double_array);
        int byteArrayColor = ViewsKt.getColorCompat(context, R.color.leak_canary_heap_byte_array);
        int shortArrayColor = ViewsKt.getColorCompat(context, R.color.leak_canary_heap_short_array);
        int intArrayColor = ViewsKt.getColorCompat(context, R.color.leak_canary_heap_int_array);
        int longArrayColor = ViewsKt.getColorCompat(context, R.color.leak_canary_heap_long_array);
        Map colors = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(HprofRecord.StringRecord.class), (Object)hprofStringColor), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(HprofRecord.LoadClassRecord.class), (Object)loadClassColor), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(HprofRecord.HeapDumpRecord.ObjectRecord.ClassDumpRecord.class), (Object)classDumpColor), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(HprofRecord.HeapDumpRecord.ObjectRecord.InstanceDumpRecord.class), (Object)instanceColor), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(HprofRecord.HeapDumpRecord.ObjectRecord.ObjectArrayDumpRecord.class), (Object)objectArrayColor), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(HprofRecord.HeapDumpRecord.ObjectRecord.PrimitiveArrayDumpRecord.BooleanArrayDump.class), (Object)booleanArrayColor), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(HprofRecord.HeapDumpRecord.ObjectRecord.PrimitiveArrayDumpRecord.CharArrayDump.class), (Object)charArrayColor), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(HprofRecord.HeapDumpRecord.ObjectRecord.PrimitiveArrayDumpRecord.FloatArrayDump.class), (Object)floatArrayColor), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(HprofRecord.HeapDumpRecord.ObjectRecord.PrimitiveArrayDumpRecord.DoubleArrayDump.class), (Object)doubleArrayColor), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(HprofRecord.HeapDumpRecord.ObjectRecord.PrimitiveArrayDumpRecord.ByteArrayDump.class), (Object)byteArrayColor), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(HprofRecord.HeapDumpRecord.ObjectRecord.PrimitiveArrayDumpRecord.ShortArrayDump.class), (Object)shortArrayColor), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(HprofRecord.HeapDumpRecord.ObjectRecord.PrimitiveArrayDumpRecord.IntArrayDump.class), (Object)intArrayColor), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(HprofRecord.HeapDumpRecord.ObjectRecord.PrimitiveArrayDumpRecord.LongArrayDump.class), (Object)longArrayColor), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(HprofRecord.StackTraceRecord.class), (Object)stackTraceColor), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(HprofRecord.HeapDumpEndRecord.class), (Object)otherColor), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(HprofRecord.HeapDumpRecord.GcRootRecord.class), (Object)otherColor)});
        int appHeapColor = ViewsKt.getColorCompat(context, R.color.leak_canary_heap_app);
        int imageHeapColor = ViewsKt.getColorCompat(context, R.color.leak_canary_heap_image);
        int zygoteHeapColor = ViewsKt.getColorCompat(context, R.color.leak_canary_heap_zygote);
        int stringColor = ViewsKt.getColorCompat(context, R.color.leak_canary_heap_instance_string);
        Ref.LongRef longRef = new Ref.LongRef();
        longRef.element = 0L;
        StreamingRecordReaderAdapter reader = StreamingRecordReaderAdapter.Companion.asStreamingRecordReader(StreamingHprofReader.Companion.readerFor$default((StreamingHprofReader.Companion)StreamingHprofReader.Companion, (File)heapDumpFile, null, (int)2, null));
        boolean bl5 = false;
        Map hprofStringCache = new LinkedHashMap();
        boolean bl6 = false;
        Map classNames = new LinkedHashMap();
        reader.readRecords(SetsKt.setOf((Object)Reflection.getOrCreateKotlinClass(HprofRecord.class)), new OnHprofRecordListener((Ref.LongRef)lastPosition, hprofStringCache, classNames, (Ref.ObjectRef)currentRecord, appHeapColor, imageHeapColor, zygoteHeapColor, otherColor, recordPositions, stringColor, colors){
            final /* synthetic */ Ref.LongRef $lastPosition;
            final /* synthetic */ Map $hprofStringCache;
            final /* synthetic */ Map $classNames;
            final /* synthetic */ Ref.ObjectRef $currentRecord;
            final /* synthetic */ int $appHeapColor;
            final /* synthetic */ int $imageHeapColor;
            final /* synthetic */ int $zygoteHeapColor;
            final /* synthetic */ int $otherColor;
            final /* synthetic */ List $recordPositions;
            final /* synthetic */ int $stringColor;
            final /* synthetic */ Map $colors;

            /*
             * Unable to fully structure code
             */
            public final void onHprofRecord(long position, @NotNull HprofRecord record) {
                block16: {
                    block19: {
                        block17: {
                            block18: {
                                block15: {
                                    Intrinsics.checkParameterIsNotNull((Object)record, (String)"record");
                                    this.$lastPosition.element = position;
                                    var4_3 = record;
                                    if (var4_3 instanceof HprofRecord.StringRecord) {
                                        this.$hprofStringCache.put(((HprofRecord.StringRecord)record).getId(), ((HprofRecord.StringRecord)record).getString());
                                    } else if (var4_3 instanceof HprofRecord.LoadClassRecord) {
                                        this.$classNames.put(((HprofRecord.LoadClassRecord)record).getId(), ((HprofRecord.LoadClassRecord)record).getClassNameStringId());
                                    }
                                    localCurrentRecord = (HprofRecord)this.$currentRecord.element;
                                    if (!(localCurrentRecord instanceof HprofRecord.HeapDumpRecord.HeapDumpInfoRecord)) break block15;
                                    v0 = (String)this.$hprofStringCache.get(((HprofRecord.HeapDumpRecord.HeapDumpInfoRecord)localCurrentRecord).getHeapNameStringId());
                                    if (v0 == null) ** GOTO lbl-1000
                                    var6_4 = v0;
                                    tmp = -1;
                                    switch (var6_4.hashCode()) {
                                        case 96801: {
                                            if (!var6_4.equals("app")) break;
                                            tmp = 1;
                                            break;
                                        }
                                        case -687285992: {
                                            if (!var6_4.equals("zygote")) break;
                                            tmp = 2;
                                            break;
                                        }
                                        case 100313435: {
                                            if (!var6_4.equals("image")) break;
                                            tmp = 3;
                                            break;
                                        }
                                    }
                                    switch (tmp) {
                                        case 1: {
                                            v1 = this.$appHeapColor;
                                            break;
                                        }
                                        case 3: {
                                            v1 = this.$imageHeapColor;
                                            break;
                                        }
                                        case 2: {
                                            v1 = this.$zygoteHeapColor;
                                            break;
                                        }
                                        default: lbl-1000:
                                        // 2 sources

                                        {
                                            v1 = this.$otherColor;
                                        }
                                    }
                                    colorForHeapInfo = v1;
                                    this.$recordPositions.add(TuplesKt.to((Object)colorForHeapInfo, (Object)position));
                                    this.$currentRecord.element = record;
                                    break block16;
                                }
                                if (!(localCurrentRecord instanceof HprofRecord.HeapDumpRecord.ObjectRecord.InstanceDumpRecord)) break block17;
                                var5_7 = this.$hprofStringCache;
                                var6_5 = this.$classNames.get(((HprofRecord.HeapDumpRecord.ObjectRecord.InstanceDumpRecord)localCurrentRecord).getClassId());
                                var7_8 = false;
                                if (!Intrinsics.areEqual((Object)((String)var5_7.get(var6_5)), (Object)"java.lang.String")) break block17;
                                if (!(record instanceof HprofRecord.HeapDumpRecord.ObjectRecord.InstanceDumpRecord)) break block18;
                                var5_7 = this.$hprofStringCache;
                                var6_5 = this.$classNames.get(((HprofRecord.HeapDumpRecord.ObjectRecord.InstanceDumpRecord)record).getClassId());
                                var7_8 = false;
                                if (!(Intrinsics.areEqual((Object)((String)var5_7.get(var6_5)), (Object)"java.lang.String") ^ true)) break block17;
                            }
                            this.$recordPositions.add(TuplesKt.to((Object)this.$stringColor, (Object)position));
                            this.$currentRecord.element = record;
                            break block16;
                        }
                        if ((HprofRecord)this.$currentRecord.element != null) break block19;
                        this.$recordPositions.add(TuplesKt.to((Object)this.$otherColor, (Object)position));
                        this.$currentRecord.element = record;
                        break block16;
                    }
                    v2 = (HprofRecord)this.$currentRecord.element;
                    if (v2 == null) {
                        Intrinsics.throwNpe();
                    }
                    if (!(Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(v2.getClass()), (Object)Reflection.getOrCreateKotlinClass(record.getClass())) ^ true)) break block16;
                    v3 = (HprofRecord)this.$currentRecord.element;
                    if (v3 == null) {
                        Intrinsics.throwNpe();
                    }
                    this.$recordPositions.add(TuplesKt.to((Object)MapsKt.getValue((Map)this.$colors, (Object)Reflection.getOrCreateKotlinClass(v3.getClass())), (Object)position));
                    this.$currentRecord.element = record;
                }
            }
            {
                this.$lastPosition = longRef;
                this.$hprofStringCache = map;
                this.$classNames = map2;
                this.$currentRecord = objectRef;
                this.$appHeapColor = n;
                this.$imageHeapColor = n2;
                this.$zygoteHeapColor = n3;
                this.$otherColor = n4;
                this.$recordPositions = list;
                this.$stringColor = n5;
                this.$colors = map3;
            }
        });
        long heapLength = lastPosition.element;
        int width = sourceWidth;
        int height = 0;
        double bytesPerPixel = 0.0;
        if (sourceBytesPerPixel > 0) {
            bytesPerPixel = sourceBytesPerPixel;
            height = (int)Math.ceil((double)heapLength / bytesPerPixel / (double)width);
        } else {
            height = sourceHeight;
            bytesPerPixel = (double)heapLength * 1.0 / (double)(width * height);
        }
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"Bitmap.createBitmap(width, height, ARGB_8888)");
        Bitmap bitmap2 = bitmap;
        Canvas canvas = new Canvas(bitmap2);
        Map legend = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"Hprof string", (Object)hprofStringColor), TuplesKt.to((Object)"Class name", (Object)loadClassColor), TuplesKt.to((Object)"App heap", (Object)appHeapColor), TuplesKt.to((Object)"Image heap", (Object)imageHeapColor), TuplesKt.to((Object)"Zygote heap", (Object)zygoteHeapColor), TuplesKt.to((Object)"Other heap", (Object)otherColor), TuplesKt.to((Object)"Class content", (Object)classDumpColor), TuplesKt.to((Object)"Instance", (Object)instanceColor), TuplesKt.to((Object)"String", (Object)stringColor), TuplesKt.to((Object)"Object array", (Object)objectArrayColor), TuplesKt.to((Object)"Boolean array", (Object)booleanArrayColor), TuplesKt.to((Object)"Char array", (Object)charArrayColor), TuplesKt.to((Object)"Float array", (Object)floatArrayColor), TuplesKt.to((Object)"Double array", (Object)doubleArrayColor), TuplesKt.to((Object)"Byte array", (Object)byteArrayColor), TuplesKt.to((Object)"Short array", (Object)shortArrayColor), TuplesKt.to((Object)"Int array", (Object)intArrayColor), TuplesKt.to((Object)"Long array", (Object)longArrayColor), TuplesKt.to((Object)"Stack trace", (Object)stackTraceColor), TuplesKt.to((Object)"Heap End", (Object)otherColor)});
        Paint legendTextPaint = new Paint(1);
        legendTextPaint.setColor(-1);
        legendTextPaint.setStyle(Paint.Style.FILL);
        canvas.drawPaint(legendTextPaint);
        Paint legendSquareFillPaint = new Paint();
        legendSquareFillPaint.setStyle(Paint.Style.FILL);
        Paint legendSquareStrokePaint = new Paint();
        legendSquareStrokePaint.setStyle(Paint.Style.STROKE);
        legendSquareStrokePaint.setStrokeWidth($this$with.getDp(0.8f));
        legendSquareStrokePaint.setColor(-16777216);
        legendTextPaint.setColor(-16777216);
        legendTextPaint.setTextSize($this$with.getDp(16));
        Paint.FontMetrics metrics = legendTextPaint.getFontMetrics();
        float textHeight = metrics.descent - metrics.ascent;
        Rect xBounds = new Rect();
        legendTextPaint.getTextBounds("x", 0, 1, xBounds);
        int squareSize = xBounds.height();
        float squarePaddingTop = (textHeight - (float)squareSize) / (float)2;
        float squareToTextPadding = $this$with.getDp(4);
        float blockToBlockPadding = $this$with.getDp(8);
        float maxTextWidth = 0.0f;
        for (String name : legend.keySet()) {
            maxTextWidth = Math.max(maxTextWidth, legendTextPaint.measureText(name));
        }
        float blockLeft = padding = $this$with.getDp(8);
        float blockTop = padding;
        float legendWidth = (float)width - (float)2 * padding;
        Object object = legend;
        boolean bl7 = false;
        Iterator iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            void name;
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator.next();
            n = 0;
            object = (String)entry2.getKey();
            entry2 = entry;
            n = 0;
            int color2 = ((Number)entry2.getValue()).intValue();
            if (blockLeft + (float)squareSize + squareToTextPadding + maxTextWidth > legendWidth) {
                blockLeft = padding;
                blockTop += textHeight;
            }
            legendSquareFillPaint.setColor(color2);
            canvas.drawRect(blockLeft, blockTop + squarePaddingTop, blockLeft + (float)squareSize, blockTop + squarePaddingTop + (float)squareSize, legendSquareFillPaint);
            canvas.drawRect(blockLeft, blockTop + squarePaddingTop, blockLeft + (float)squareSize, blockTop + squarePaddingTop + (float)squareSize, legendSquareStrokePaint);
            canvas.drawText((String)name, blockLeft += (float)squareSize + squareToTextPadding, blockTop - metrics.ascent, legendTextPaint);
            blockLeft += maxTextWidth;
            blockLeft += blockToBlockPadding;
        }
        float legendHeight = blockTop + textHeight + padding;
        Rect source = new Rect(0, 0, width, (int)legendHeight);
        Rect destination = new Rect(0, (int)((float)height - legendHeight), width, height);
        canvas.drawBitmap(bitmap2, source, destination, null);
        Paint pixelPaint = new Paint();
        pixelPaint.setStyle(Paint.Style.FILL);
        int recordIndex = 0;
        n = 0;
        int n2 = height -= (int)legendHeight;
        while (n < n2) {
            void y;
            int n3 = 0;
            int n4 = width;
            while (n3 < n4) {
                void x;
                void bitmapPosition = y * width + x;
                int heapPosition = (int)((double)bitmapPosition * bytesPerPixel);
                while ((long)heapPosition > ((Number)((Pair)recordPositions.get(recordIndex)).getSecond()).longValue() && recordIndex < CollectionsKt.getLastIndex((List)recordPositions)) {
                    ++recordIndex;
                }
                pixelPaint.setColor(((Number)((Pair)recordPositions.get(recordIndex)).getFirst()).intValue());
                canvas.drawPoint((float)x, (float)y, pixelPaint);
                ++x;
            }
            ++y;
        }
        return bitmap2;
    }

    private HeapDumpRenderer() {
    }

    static {
        HeapDumpRenderer heapDumpRenderer;
        INSTANCE = heapDumpRenderer = new HeapDumpRenderer();
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0015\u0010\t\u001a\u00020\u0006*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0015\u0010\t\u001a\u00020\u0006*\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\r\u00a8\u0006\u000e"}, d2={"Lleakcanary/internal/activity/screen/HeapDumpRenderer$HasDensity;", "", "resources", "Landroid/content/res/Resources;", "(Landroid/content/res/Resources;)V", "density", "", "getDensity", "()F", "dp", "getDp", "(F)F", "", "(I)F", "leakcanary-android-core_release"})
    private static final class HasDensity {
        private final float density;

        public final float getDensity() {
            return this.density;
        }

        public final float getDp(int $this$dp) {
            return (float)$this$dp * this.density;
        }

        public final float getDp(float $this$dp) {
            return $this$dp * this.density;
        }

        public HasDensity(@NotNull Resources resources) {
            Intrinsics.checkParameterIsNotNull((Object)resources, (String)"resources");
            this.density = resources.getDisplayMetrics().density;
        }
    }
}

