/*
 * Decompiled with CFR 0.152.
 */
package leakcanary.internal.activity.db;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.os.AsyncTask;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import leakcanary.internal.HandlersKt;
import leakcanary.internal.LeakDirectoryProvider;
import leakcanary.internal.Serializables;
import leakcanary.internal.SerializablesKt;
import leakcanary.internal.activity.db.CursorsKt;
import leakcanary.internal.activity.db.HeapAnalysisTable;
import leakcanary.internal.activity.db.LeakTable;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import shark.HeapAnalysis;
import shark.HeapAnalysisFailure;
import shark.HeapAnalysisSuccess;
import shark.Leak;
import shark.SharkLog;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u001fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\u000e\u0010\u0011\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014J\b\u0010\u0015\u001a\u00020\tH\u0002J\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\bJ,\u0010\u0018\u001a\u0004\u0018\u0001H\u0019\"\n\b\u0000\u0010\u0019\u0018\u0001*\u00020\u00142\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u000eH\u0086\b\u00a2\u0006\u0002\u0010\u001bJ\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u000b\u001a\u00020\fR\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lleakcanary/internal/activity/db/HeapAnalysisTable;", "", "()V", "create", "", "drop", "updateListeners", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lkotlin/Function0;", "", "delete", "db", "Landroid/database/sqlite/SQLiteDatabase;", "heapAnalysisId", "", "heapDumpFile", "Ljava/io/File;", "deleteAll", "insert", "heapAnalysis", "Lshark/HeapAnalysis;", "notifyUpdateOnMainThread", "onUpdate", "block", "retrieve", "T", "id", "(Landroid/database/sqlite/SQLiteDatabase;J)Lshark/HeapAnalysis;", "retrieveAll", "", "Lleakcanary/internal/activity/db/HeapAnalysisTable$Projection;", "Projection", "leakcanary-android-core_release"})
public final class HeapAnalysisTable {
    private static final CopyOnWriteArrayList<Function0<Unit>> updateListeners;
    @Language(value="RoomSql")
    @NotNull
    public static final String create = "CREATE TABLE heap_analysis\n        (\n        id INTEGER PRIMARY KEY AUTOINCREMENT,\n        created_at_time_millis INTEGER,\n        dump_duration_millis INTEGER DEFAULT -1,\n        leak_count INTEGER DEFAULT 0,\n        exception_summary TEXT DEFAULT NULL,\n        object BLOB\n        )";
    @Language(value="RoomSql")
    @NotNull
    public static final String drop = "DROP TABLE IF EXISTS heap_analysis";
    @NotNull
    public static final HeapAnalysisTable INSTANCE;

    @NotNull
    public final Function0<Unit> onUpdate(@NotNull Function0<Unit> block) {
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        updateListeners.add(block);
        return (Function0)new Function0<Unit>(block){
            final /* synthetic */ Function0 $block;

            public final void invoke() {
                HeapAnalysisTable.access$getUpdateListeners$p(HeapAnalysisTable.INSTANCE).remove(this.$block);
            }
            {
                this.$block = function0;
                super(0);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long insert(@NotNull SQLiteDatabase db, @NotNull HeapAnalysis heapAnalysis) {
        long l;
        boolean bl;
        Leak leakingInstance;
        boolean $i$f$forEach;
        Sequence $this$forEach$iv;
        long heapAnalysisId;
        boolean bl2;
        SQLiteDatabase $this$inTransaction;
        Object exceptionSummary;
        Intrinsics.checkParameterIsNotNull((Object)db, (String)"db");
        Intrinsics.checkParameterIsNotNull((Object)heapAnalysis, (String)"heapAnalysis");
        ContentValues values = new ContentValues();
        values.put("created_at_time_millis", Long.valueOf(heapAnalysis.getCreatedAtTimeMillis()));
        values.put("dump_duration_millis", Long.valueOf(heapAnalysis.getDumpDurationMillis()));
        values.put("object", SerializablesKt.toByteArray((Serializable)heapAnalysis));
        HeapAnalysis heapAnalysis2 = heapAnalysis;
        if (heapAnalysis2 instanceof HeapAnalysisSuccess) {
            int leakCount = ((HeapAnalysisSuccess)heapAnalysis).getApplicationLeaks().size() + ((HeapAnalysisSuccess)heapAnalysis).getLibraryLeaks().size();
            values.put("leak_count", Integer.valueOf(leakCount));
        } else if (heapAnalysis2 instanceof HeapAnalysisFailure) {
            Throwable throwable = ((HeapAnalysisFailure)heapAnalysis).getException().getCause();
            if (throwable == null) {
                Intrinsics.throwNpe();
            }
            Throwable cause = throwable;
            exceptionSummary = cause.getClass().getSimpleName() + ' ' + cause.getMessage();
            values.put("exception_summary", (String)exceptionSummary);
        }
        SQLiteDatabase $this$inTransaction$iv = db;
        boolean $i$f$inTransaction = false;
        exceptionSummary = CursorsKt.access$getInTransaction$p();
        boolean bl3 = false;
        Object object = ((ThreadLocal)exceptionSummary).get();
        if (object == null) {
            boolean bl4 = false;
            Boolean bl5 = false;
            boolean bl6 = false;
            boolean bl7 = false;
            Boolean bl8 = bl5;
            boolean bl9 = false;
            ((ThreadLocal)exceptionSummary).set(bl8);
            object = bl5;
        }
        if (((Boolean)object).booleanValue()) {
            $this$inTransaction = $this$inTransaction$iv;
            bl2 = false;
            heapAnalysisId = db.insertOrThrow("heap_analysis", null, values);
            if (heapAnalysis instanceof HeapAnalysisSuccess) {
                $this$forEach$iv = ((HeapAnalysisSuccess)heapAnalysis).getAllLeaks();
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    leakingInstance = (Leak)element$iv;
                    bl = false;
                    LeakTable.INSTANCE.insert(db, heapAnalysisId, leakingInstance);
                }
            }
            l = heapAnalysisId;
        } else {
            try {
                CursorsKt.access$getInTransaction$p().set(true);
                $this$inTransaction$iv.beginTransaction();
                $this$inTransaction = $this$inTransaction$iv;
                bl2 = false;
                heapAnalysisId = db.insertOrThrow("heap_analysis", null, values);
                if (heapAnalysis instanceof HeapAnalysisSuccess) {
                    $this$forEach$iv = ((HeapAnalysisSuccess)heapAnalysis).getAllLeaks();
                    $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        leakingInstance = (Leak)element$iv;
                        bl = false;
                        LeakTable.INSTANCE.insert(db, heapAnalysisId, leakingInstance);
                    }
                }
                long result$iv = heapAnalysisId;
                $this$inTransaction$iv.setTransactionSuccessful();
                long l2 = result$iv;
                l = l2;
            }
            finally {
                $this$inTransaction$iv.endTransaction();
                CursorsKt.access$getInTransaction$p().set(false);
            }
        }
        long l3 = l;
        boolean bl10 = false;
        boolean bl11 = false;
        long $this$apply = l3;
        boolean bl12 = false;
        INSTANCE.notifyUpdateOnMainThread();
        return l3;
    }

    private final void notifyUpdateOnMainThread() {
        boolean $i$f$checkNotMainThread = false;
        HandlersKt.checkNotMainThread();
        boolean $i$f$getMainHandler = false;
        HandlersKt.getMainHandler().post((Runnable)notifyUpdateOnMainThread.1.INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final /* synthetic */ <T extends HeapAnalysis> T retrieve(SQLiteDatabase db, long id) {
        HeapAnalysis heapAnalysis;
        int $i$f$retrieve = 0;
        Intrinsics.checkParameterIsNotNull((Object)db, (String)"db");
        Cursor cursor = db.rawQuery("\n              SELECT\n              object\n              FROM heap_analysis\n              WHERE id=" + id + "\n              ", null);
        Intrinsics.checkExpressionValueIsNotNull((Object)cursor, (String)"db.rawQuery(\n      \"\"\"\n \u2026          \"\"\", null\n    )");
        Cursor $this$use$iv = cursor;
        boolean $i$f$use = false;
        Throwable exception$iv = null;
        try {
            HeapAnalysis heapAnalysis2;
            Cursor cursor2 = $this$use$iv;
            boolean bl = false;
            if (cursor2.moveToNext()) {
                Object object;
                Serializables serializables = Serializables.INSTANCE;
                byte[] byArray = cursor2.getBlob(0);
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"cursor.getBlob(0)");
                byte[] byteArray$iv = byArray;
                boolean $i$f$fromByteArray = false;
                ByteArrayInputStream inputStream$iv = new ByteArrayInputStream(byteArray$iv);
                try {
                    Object object2 = new ObjectInputStream(inputStream$iv).readObject();
                    Intrinsics.reifiedOperationMarker((int)2, (String)"T");
                    object = object2;
                }
                catch (Throwable ignored$iv) {
                    SharkLog this_$iv$iv = SharkLog.INSTANCE;
                    boolean $i$f$d = false;
                    SharkLog.Logger logger = this_$iv$iv.getLogger();
                    if (logger != null) {
                        SharkLog.Logger logger$iv$iv = logger;
                        Throwable throwable = ignored$iv;
                        SharkLog.Logger logger2 = logger$iv$iv;
                        boolean bl2 = false;
                        String string2 = "Could not deserialize bytes, ignoring";
                        logger2.d(throwable, string2);
                    }
                    object = null;
                }
                HeapAnalysis analysis = (HeapAnalysis)object;
                if (analysis == null) {
                    INSTANCE.delete(db, id, null);
                }
                heapAnalysis2 = analysis;
            } else {
                heapAnalysis2 = null;
            }
            heapAnalysis = heapAnalysis2;
        }
        catch (Throwable e$iv) {
            try {
                exception$iv = e$iv;
                throw e$iv;
            }
            catch (Throwable throwable) {
                InlineMarker.finallyStart((int)1);
                Throwable throwable2 = exception$iv;
                if (throwable2 == null) {
                    $this$use$iv.close();
                } else {
                    try {
                        $this$use$iv.close();
                    }
                    catch (Throwable throwable3) {
                        // empty catch block
                    }
                }
                InlineMarker.finallyEnd((int)1);
                throw throwable;
            }
        }
        InlineMarker.finallyStart((int)1);
        Throwable throwable = exception$iv;
        $this$use$iv.close();
        InlineMarker.finallyEnd((int)1);
        return (T)heapAnalysis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<Projection> retrieveAll(@NotNull SQLiteDatabase db) {
        Object cursor;
        Intrinsics.checkParameterIsNotNull((Object)db, (String)"db");
        Cursor cursor2 = db.rawQuery("\n          SELECT\n          id\n          , created_at_time_millis\n          , leak_count\n          , exception_summary\n          FROM heap_analysis\n          ORDER BY created_at_time_millis DESC\n          ", null);
        Intrinsics.checkExpressionValueIsNotNull((Object)cursor2, (String)"db.rawQuery(\n      \"\"\"\n \u2026          \"\"\", null\n    )");
        Cursor $this$use$iv = cursor2;
        boolean $i$f$use = false;
        Throwable exception$iv = null;
        try {
            cursor = $this$use$iv;
            boolean bl = false;
            boolean bl2 = false;
            List all = new ArrayList();
            while (cursor.moveToNext()) {
                Projection summary = new Projection(cursor.getLong(0), cursor.getLong(1), cursor.getInt(2), cursor.getString(3));
                all.add(summary);
            }
            cursor = all;
            Throwable throwable = exception$iv;
        }
        catch (Throwable e$iv) {
            try {
                exception$iv = e$iv;
                throw e$iv;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = exception$iv;
                if (throwable2 == null) {
                    $this$use$iv.close();
                } else {
                    try {
                        $this$use$iv.close();
                    }
                    catch (Throwable throwable3) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        $this$use$iv.close();
        return cursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void delete(@NotNull SQLiteDatabase db, long heapAnalysisId, @Nullable File heapDumpFile) {
        Intrinsics.checkParameterIsNotNull((Object)db, (String)"db");
        if (heapDumpFile != null) {
            AsyncTask.SERIAL_EXECUTOR.execute(new Runnable(heapDumpFile){
                final /* synthetic */ File $heapDumpFile;

                public final void run() {
                    String path = this.$heapDumpFile.getAbsolutePath();
                    boolean heapDumpDeleted = this.$heapDumpFile.delete();
                    if (heapDumpDeleted) {
                        Collection collection = LeakDirectoryProvider.Companion.getFilesDeletedRemoveLeak();
                        boolean bl = false;
                        collection.add(path);
                    } else {
                        SharkLog this_$iv = SharkLog.INSTANCE;
                        boolean $i$f$d = false;
                        SharkLog.Logger logger = this_$iv.getLogger();
                        if (logger == null) {
                        } else {
                            SharkLog.Logger logger$iv;
                            SharkLog.Logger logger2 = logger$iv = logger;
                            boolean bl = false;
                            String string2 = "Could not delete heap dump file " + this.$heapDumpFile.getPath();
                            logger2.d(string2);
                        }
                    }
                }
                {
                    this.$heapDumpFile = file;
                }
            });
        }
        SQLiteDatabase $this$inTransaction$iv = db;
        boolean $i$f$inTransaction = false;
        ThreadLocal threadLocal = CursorsKt.access$getInTransaction$p();
        boolean bl = false;
        Object object = threadLocal.get();
        if (object == null) {
            boolean bl2 = false;
            Boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            Boolean bl6 = bl3;
            boolean bl7 = false;
            threadLocal.set(bl6);
            object = bl3;
        }
        if (((Boolean)object).booleanValue()) {
            SQLiteDatabase $this$inTransaction = $this$inTransaction$iv;
            boolean bl8 = false;
            db.delete("heap_analysis", "id=" + heapAnalysisId, null);
            LeakTable.INSTANCE.deleteByHeapAnalysisId(db, heapAnalysisId);
        } else {
            try {
                CursorsKt.access$getInTransaction$p().set(true);
                $this$inTransaction$iv.beginTransaction();
                SQLiteDatabase $this$inTransaction = $this$inTransaction$iv;
                boolean bl9 = false;
                db.delete("heap_analysis", "id=" + heapAnalysisId, null);
                LeakTable.INSTANCE.deleteByHeapAnalysisId(db, heapAnalysisId);
                Unit result$iv = Unit.INSTANCE;
                $this$inTransaction$iv.setTransactionSuccessful();
                Unit unit = result$iv;
            }
            finally {
                $this$inTransaction$iv.endTransaction();
                CursorsKt.access$getInTransaction$p().set(false);
            }
        }
        this.notifyUpdateOnMainThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deleteAll(@NotNull SQLiteDatabase db) {
        block32: {
            SQLiteDatabase $this$inTransaction$iv;
            block33: {
                Intrinsics.checkParameterIsNotNull((Object)db, (String)"db");
                $this$inTransaction$iv = db;
                boolean $i$f$inTransaction = false;
                ThreadLocal threadLocal = CursorsKt.access$getInTransaction$p();
                boolean bl = false;
                Object object = threadLocal.get();
                if (object == null) {
                    boolean bl2 = false;
                    Boolean bl3 = false;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    Boolean bl6 = bl3;
                    boolean bl7 = false;
                    threadLocal.set(bl6);
                    object = bl3;
                }
                if (!((Boolean)object).booleanValue()) break block33;
                SQLiteDatabase $this$inTransaction = $this$inTransaction$iv;
                boolean bl8 = false;
                Cursor cursor = $this$inTransaction.rawQuery("\n              SELECT\n              id,\n              object\n              FROM heap_analysis\n              ", null);
                Intrinsics.checkExpressionValueIsNotNull((Object)cursor, (String)"rawQuery(\n        \"\"\"\n  \u2026        \"\"\", null\n      )");
                Cursor $this$use$iv = cursor;
                boolean $i$f$use = false;
                Throwable exception$iv = null;
                try {
                    Cursor cursor2 = $this$use$iv;
                    boolean $i$a$-use-HeapAnalysisTable$deleteAll$1$22 = false;
                    boolean bl9 = false;
                    List all = new ArrayList();
                    while (cursor2.moveToNext()) {
                        HeapAnalysis analysis;
                        HeapAnalysis heapAnalysis;
                        Object byteArray$iv;
                        long id = cursor2.getLong(0);
                        Serializables serializables = Serializables.INSTANCE;
                        Intrinsics.checkExpressionValueIsNotNull((Object)cursor2.getBlob(1), (String)"cursor.getBlob(1)");
                        boolean $i$f$fromByteArray = false;
                        ByteArrayInputStream inputStream$iv = new ByteArrayInputStream((byte[])byteArray$iv);
                        try {
                            Object object2 = new ObjectInputStream(inputStream$iv).readObject();
                            if (!(object2 instanceof HeapAnalysis)) {
                                object2 = null;
                            }
                            heapAnalysis = (HeapAnalysis)object2;
                        }
                        catch (Throwable ignored$iv) {
                            SharkLog this_$iv$iv = SharkLog.INSTANCE;
                            boolean $i$f$d = false;
                            if (this_$iv$iv.getLogger() != null) {
                                SharkLog.Logger logger$iv$iv;
                                Throwable throwable = ignored$iv;
                                SharkLog.Logger logger = logger$iv$iv;
                                boolean bl10 = false;
                                String string2 = "Could not deserialize bytes, ignoring";
                                logger.d(throwable, string2);
                            }
                            heapAnalysis = null;
                        }
                        if ((analysis = heapAnalysis) == null) continue;
                        Collection this_$iv = all;
                        byteArray$iv = TuplesKt.to((Object)id, (Object)analysis);
                        $i$f$fromByteArray = false;
                        this_$iv.add(byteArray$iv);
                    }
                    Iterable $this$forEach$iv = all;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Pair $dstr$id$_u24__u24 = (Pair)element$iv;
                        boolean bl11 = false;
                        long id = ((Number)$dstr$id$_u24__u24.component1()).longValue();
                        db.delete("heap_analysis", "id=" + id, null);
                        LeakTable.INSTANCE.deleteByHeapAnalysisId(db, id);
                    }
                    AsyncTask.SERIAL_EXECUTOR.execute(new Runnable(all){
                        final /* synthetic */ List $all;

                        public final void run() {
                            Iterable $this$forEach$iv = this.$all;
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                Pair $dstr$_u24__u24$analysis = (Pair)element$iv;
                                boolean bl = false;
                                HeapAnalysis analysis = (HeapAnalysis)$dstr$_u24__u24$analysis.component2();
                                analysis.getHeapDumpFile().delete();
                            }
                        }
                        {
                            this.$all = list;
                        }
                    });
                    cursor2 = Unit.INSTANCE;
                    Throwable $i$a$-use-HeapAnalysisTable$deleteAll$1$22 = exception$iv;
                }
                catch (Throwable e$iv2) {
                    try {
                        exception$iv = e$iv2;
                        throw e$iv2;
                    }
                    catch (Throwable e$iv2) {
                        Throwable $i$a$-use-HeapAnalysisTable$deleteAll$1$22 = exception$iv;
                        if ($i$a$-use-HeapAnalysisTable$deleteAll$1$22 == null) {
                            $this$use$iv.close();
                        } else {
                            try {
                                $this$use$iv.close();
                            }
                            catch (Throwable $this$forEach$iv) {
                                // empty catch block
                            }
                        }
                        throw e$iv2;
                    }
                }
                $this$use$iv.close();
                break block32;
            }
            try {
                CursorsKt.access$getInTransaction$p().set(true);
                $this$inTransaction$iv.beginTransaction();
                SQLiteDatabase $this$inTransaction = $this$inTransaction$iv;
                boolean bl = false;
                Cursor cursor = $this$inTransaction.rawQuery("\n              SELECT\n              id,\n              object\n              FROM heap_analysis\n              ", null);
                Intrinsics.checkExpressionValueIsNotNull((Object)cursor, (String)"rawQuery(\n        \"\"\"\n  \u2026        \"\"\", null\n      )");
                Cursor $this$use$iv = cursor;
                boolean $i$f$use = false;
                Throwable exception$iv = null;
                try {
                    Cursor cursor3 = $this$use$iv;
                    boolean bl12 = false;
                    boolean $this$forEach$iv = false;
                    List all = new ArrayList();
                    while (cursor3.moveToNext()) {
                        HeapAnalysis analysis;
                        HeapAnalysis heapAnalysis;
                        Object byteArray$iv;
                        long id = cursor3.getLong(0);
                        Serializables element$iv = Serializables.INSTANCE;
                        Intrinsics.checkExpressionValueIsNotNull((Object)cursor3.getBlob(1), (String)"cursor.getBlob(1)");
                        boolean $i$f$fromByteArray = false;
                        ByteArrayInputStream inputStream$iv = new ByteArrayInputStream((byte[])byteArray$iv);
                        try {
                            Object object = new ObjectInputStream(inputStream$iv).readObject();
                            if (!(object instanceof HeapAnalysis)) {
                                object = null;
                            }
                            heapAnalysis = (HeapAnalysis)object;
                        }
                        catch (Throwable ignored$iv) {
                            SharkLog this_$iv$iv = SharkLog.INSTANCE;
                            boolean $i$f$d = false;
                            if (this_$iv$iv.getLogger() != null) {
                                SharkLog.Logger logger$iv$iv;
                                Throwable throwable = ignored$iv;
                                SharkLog.Logger logger = logger$iv$iv;
                                boolean bl13 = false;
                                String string3 = "Could not deserialize bytes, ignoring";
                                logger.d(throwable, string3);
                            }
                            heapAnalysis = null;
                        }
                        if ((analysis = heapAnalysis) == null) continue;
                        Collection this_$iv = all;
                        byteArray$iv = TuplesKt.to((Object)id, (Object)analysis);
                        $i$f$fromByteArray = false;
                        this_$iv.add(byteArray$iv);
                    }
                    Iterable $this$forEach$iv2 = all;
                    boolean $i$f$forEach = false;
                    for (Serializables element$iv : $this$forEach$iv2) {
                        Pair $dstr$id$_u24__u24 = (Pair)element$iv;
                        boolean bl14 = false;
                        long id = ((Number)$dstr$id$_u24__u24.component1()).longValue();
                        db.delete("heap_analysis", "id=" + id, null);
                        LeakTable.INSTANCE.deleteByHeapAnalysisId(db, id);
                    }
                    AsyncTask.SERIAL_EXECUTOR.execute(new /* invalid duplicate definition of identical inner class */);
                    cursor3 = Unit.INSTANCE;
                    Throwable throwable = exception$iv;
                }
                catch (Throwable e$iv) {
                    try {
                        exception$iv = e$iv;
                        throw e$iv;
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = exception$iv;
                        if (throwable2 == null) {
                            $this$use$iv.close();
                        } else {
                            try {
                                $this$use$iv.close();
                            }
                            catch (Throwable throwable3) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                }
                $this$use$iv.close();
                Unit result$iv = Unit.INSTANCE;
                $this$inTransaction$iv.setTransactionSuccessful();
                Unit unit = result$iv;
            }
            finally {
                $this$inTransaction$iv.endTransaction();
                CursorsKt.access$getInTransaction$p().set(false);
            }
        }
        this.notifyUpdateOnMainThread();
    }

    private HeapAnalysisTable() {
    }

    static {
        HeapAnalysisTable heapAnalysisTable;
        INSTANCE = heapAnalysisTable = new HeapAnalysisTable();
        updateListeners = new CopyOnWriteArrayList();
    }

    public static final /* synthetic */ CopyOnWriteArrayList access$getUpdateListeners$p(HeapAnalysisTable $this) {
        HeapAnalysisTable heapAnalysisTable = $this;
        return updateListeners;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lleakcanary/internal/activity/db/HeapAnalysisTable$Projection;", "", "id", "", "createdAtTimeMillis", "leakCount", "", "exceptionSummary", "", "(JJILjava/lang/String;)V", "getCreatedAtTimeMillis", "()J", "getExceptionSummary", "()Ljava/lang/String;", "getId", "getLeakCount", "()I", "leakcanary-android-core_release"})
    public static final class Projection {
        private final long id;
        private final long createdAtTimeMillis;
        private final int leakCount;
        @Nullable
        private final String exceptionSummary;

        public final long getId() {
            return this.id;
        }

        public final long getCreatedAtTimeMillis() {
            return this.createdAtTimeMillis;
        }

        public final int getLeakCount() {
            return this.leakCount;
        }

        @Nullable
        public final String getExceptionSummary() {
            return this.exceptionSummary;
        }

        public Projection(long id, long createdAtTimeMillis, int leakCount, @Nullable String exceptionSummary) {
            this.id = id;
            this.createdAtTimeMillis = createdAtTimeMillis;
            this.leakCount = leakCount;
            this.exceptionSummary = exceptionSummary;
        }
    }
}

