/*
 * Decompiled with CFR 0.152.
 */
package leakcanary.internal;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.text.SpannableStringBuilder;
import android.text.style.ReplacementSpan;
import android.text.style.UnderlineSpan;
import com.squareup.leakcanary.core.R;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import leakcanary.internal.navigation.ViewsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 !2\u00020\u0001:\u0001!B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JP\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u000fH\u0016J2\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\r2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lleakcanary/internal/SquigglySpan;", "Landroid/text/style/ReplacementSpan;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "amplitude", "", "halfStrokeWidth", "halfWaveHeight", "path", "Landroid/graphics/Path;", "periodDegrees", "referenceColor", "", "squigglyPaint", "Landroid/graphics/Paint;", "width", "draw", "", "canvas", "Landroid/graphics/Canvas;", "text", "", "start", "end", "x", "top", "y", "bottom", "paint", "getSize", "fm", "Landroid/graphics/Paint$FontMetricsInt;", "Companion", "leakcanary-android-core_release"})
public final class SquigglySpan
extends ReplacementSpan {
    private final Paint squigglyPaint;
    private final Path path;
    private final int referenceColor;
    private final float halfStrokeWidth;
    private final float amplitude;
    private final float halfWaveHeight;
    private final float periodDegrees;
    private int width;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public int getSize(@NotNull Paint paint, @NotNull CharSequence text, int start, int end, @Nullable Paint.FontMetricsInt fm) {
        Intrinsics.checkParameterIsNotNull((Object)paint, (String)"paint");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        this.width = (int)paint.measureText(text, start, end);
        return this.width;
    }

    public void draw(@NotNull Canvas canvas, @NotNull CharSequence text, int start, int end, float x, int top, int y, int bottom, @NotNull Paint paint) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)paint, (String)"paint");
        SquigglySpan.Companion.squigglyHorizontalPath(this.path, x + this.halfStrokeWidth, x + (float)this.width - this.halfStrokeWidth, (float)bottom - this.halfWaveHeight, this.amplitude, this.periodDegrees);
        canvas.drawPath(this.path, this.squigglyPaint);
        paint.setColor(this.referenceColor);
        canvas.drawText(text, start, end, x, (float)y, paint);
    }

    public SquigglySpan(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.squigglyPaint = new Paint(1);
        Resources resources = context.getResources();
        this.squigglyPaint.setStyle(Paint.Style.STROKE);
        this.squigglyPaint.setColor(ViewsKt.getColorCompat(context, R.color.leak_canary_leak));
        float strokeWidth = resources.getDimensionPixelSize(R.dimen.leak_canary_squiggly_span_stroke_width);
        this.squigglyPaint.setStrokeWidth(strokeWidth);
        this.halfStrokeWidth = strokeWidth / (float)2;
        this.amplitude = resources.getDimensionPixelSize(R.dimen.leak_canary_squiggly_span_amplitude);
        this.periodDegrees = resources.getDimensionPixelSize(R.dimen.leak_canary_squiggly_span_period_degrees);
        this.path = new Path();
        float waveHeight = (float)2 * this.amplitude + strokeWidth;
        this.halfWaveHeight = waveHeight / (float)2;
        this.referenceColor = ViewsKt.getColorCompat(context, R.color.leak_canary_reference);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ8\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\rH\u0002\u00a8\u0006\u0012"}, d2={"Lleakcanary/internal/SquigglySpan$Companion;", "", "()V", "replaceUnderlineSpans", "", "builder", "Landroid/text/SpannableStringBuilder;", "context", "Landroid/content/Context;", "squigglyHorizontalPath", "path", "Landroid/graphics/Path;", "left", "", "right", "centerY", "amplitude", "periodDegrees", "leakcanary-android-core_release"})
    public static final class Companion {
        public final void replaceUnderlineSpans(@NotNull SpannableStringBuilder builder, @NotNull Context context) {
            UnderlineSpan[] underlineSpans;
            Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            for (UnderlineSpan span : underlineSpans = (UnderlineSpan[])builder.getSpans(0, builder.length(), UnderlineSpan.class)) {
                int start = builder.getSpanStart((Object)span);
                int end = builder.getSpanEnd((Object)span);
                builder.removeSpan((Object)span);
                builder.setSpan((Object)new SquigglySpan(context), start, end, 0);
            }
        }

        private final void squigglyHorizontalPath(Path path, float left, float right, float centerY, float amplitude, float periodDegrees) {
            path.reset();
            float y = 0.0f;
            path.moveTo(left, centerY);
            float period = (float)(Math.PI * 2 / (double)periodDegrees);
            for (float x = 0.0f; x <= right - left; x += 1.0f) {
                y = (float)((double)amplitude * Math.sin((float)40 + period * x) + (double)centerY);
                path.lineTo(left + x, y);
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

