/*
 * Decompiled with CFR 0.152.
 */
package leakcanary.internal;

import android.app.Activity;
import android.app.Application;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ActivityInfo;
import android.content.pm.ResolveInfo;
import android.content.pm.ShortcutInfo;
import android.content.pm.ShortcutManager;
import android.graphics.drawable.Icon;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import com.squareup.leakcanary.core.R;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import leakcanary.AppWatcher;
import leakcanary.GcTrigger;
import leakcanary.LeakCanary;
import leakcanary.OnObjectRetainedListener;
import leakcanary.internal.AndroidHeapDumper;
import leakcanary.internal.HandlersKt;
import leakcanary.internal.HeapDumpControl;
import leakcanary.internal.HeapDumpTrigger;
import leakcanary.internal.InternalLeakCanary;
import leakcanary.internal.LeakDirectoryProvider;
import leakcanary.internal.ObjectsKt;
import leakcanary.internal.OnRetainInstanceListener;
import leakcanary.internal.VisibilityTrackerKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import shark.SharkLog;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c0\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004:\u0001FB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0005J\u0010\u00107\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0002H\u0002J\b\u00108\u001a\u00020\u0003H\u0002J\u000e\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<J\u0011\u0010=\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0002H\u0096\u0002J\u000e\u0010>\u001a\u00020\u00032\u0006\u0010?\u001a\u00020\u000fJ\b\u0010@\u001a\u00020\u0003H\u0016J\u0010\u0010A\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0002H\u0002J\u0006\u0010B\u001a\u00020\u0003J\u0016\u0010C\u001a\u00020\u00032\u0006\u0010D\u001a\u00020\u00072\u0006\u0010E\u001a\u00020\u000fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\u0004\u0018\u00010\u0002X\u0082\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\n\u0010\u0005R\u0011\u0010\u000b\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R$\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000f8@@@X\u0080\u000e\u00a2\u0006\f\u001a\u0004\b\u0015\u0010\u0012\"\u0004\b\u0016\u0010\u0017R\u001b\u0010\u0018\u001a\u00020\u00198FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001a\u0010\u001bR#\u0010\u001e\u001a\n  *\u0004\u0018\u00010\u001f0\u001f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010\u001d\u001a\u0004\b!\u0010\"R\u000e\u0010$\u001a\u00020%X\u0082.\u00a2\u0006\u0002\n\u0000R\u001b\u0010&\u001a\u00020\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010\u001d\u001a\u0004\b&\u0010\u0012R\u001b\u0010(\u001a\u00020\u000f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b)\u0010\u001d\u001a\u0004\b(\u0010\u0012R\u001b\u0010*\u001a\u00020+8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b.\u0010\u001d\u001a\u0004\b,\u0010-R\u001c\u0010/\u001a\u0004\u0018\u000100X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104R\u0018\u00105\u001a\u00020\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b6\u0010\u0005\u00a8\u0006G"}, d2={"Lleakcanary/internal/InternalLeakCanary;", "Lkotlin/Function1;", "Landroid/app/Application;", "", "Lleakcanary/OnObjectRetainedListener;", "()V", "DYNAMIC_SHORTCUT_ID", "", "LEAK_CANARY_THREAD_NAME", "_application", "get_application$annotations", "application", "getApplication", "()Landroid/app/Application;", "<set-?>", "", "applicationVisible", "getApplicationVisible", "()Z", "value", "dumpEnabledInAboutScreen", "getDumpEnabledInAboutScreen$leakcanary_android_core_release", "setDumpEnabledInAboutScreen$leakcanary_android_core_release", "(Z)V", "formFactor", "Lleakcanary/internal/InternalLeakCanary$FormFactor;", "getFormFactor", "()Lleakcanary/internal/InternalLeakCanary$FormFactor;", "formFactor$delegate", "Lkotlin/Lazy;", "heapDumpPrefs", "Landroid/content/SharedPreferences;", "kotlin.jvm.PlatformType", "getHeapDumpPrefs", "()Landroid/content/SharedPreferences;", "heapDumpPrefs$delegate", "heapDumpTrigger", "Lleakcanary/internal/HeapDumpTrigger;", "isDebuggableBuild", "isDebuggableBuild$delegate", "isInstantApp", "isInstantApp$delegate", "onRetainInstanceListener", "Lleakcanary/internal/OnRetainInstanceListener;", "getOnRetainInstanceListener", "()Lleakcanary/internal/OnRetainInstanceListener;", "onRetainInstanceListener$delegate", "resumedActivity", "Landroid/app/Activity;", "getResumedActivity", "()Landroid/app/Activity;", "setResumedActivity", "(Landroid/app/Activity;)V", "version", "getVersion$annotations", "addDynamicShortcut", "checkRunningInDebuggableBuild", "createLeakDirectoryProvider", "Lleakcanary/internal/LeakDirectoryProvider;", "context", "Landroid/content/Context;", "invoke", "onDumpHeapReceived", "forceDump", "onObjectRetained", "registerResumedActivityListener", "scheduleRetainedObjectCheck", "setEnabledBlocking", "componentClassName", "enabled", "FormFactor", "leakcanary-android-core_release"})
public final class InternalLeakCanary
implements Function1<Application, Unit>,
OnObjectRetainedListener {
    private static final String DYNAMIC_SHORTCUT_ID = "com.squareup.leakcanary.dynamic_shortcut";
    private static HeapDumpTrigger heapDumpTrigger;
    private static Application _application;
    private static String version;
    private static volatile boolean applicationVisible;
    private static final Lazy isDebuggableBuild$delegate;
    @NotNull
    private static final Lazy formFactor$delegate;
    @NotNull
    private static final Lazy isInstantApp$delegate;
    @NotNull
    private static final Lazy onRetainInstanceListener$delegate;
    @Nullable
    private static Activity resumedActivity;
    private static final Lazy heapDumpPrefs$delegate;
    private static final String LEAK_CANARY_THREAD_NAME = "LeakCanary-Heap-Dump";
    @NotNull
    public static final InternalLeakCanary INSTANCE;

    private static /* synthetic */ void get_application$annotations() {
    }

    @NotNull
    public final Application getApplication() {
        boolean bl = _application != null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "LeakCanary not installed, see AppWatcher.manualInstall()";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Application application2 = _application;
        if (application2 == null) {
            Intrinsics.throwNpe();
        }
        return application2;
    }

    @JvmStatic
    private static /* synthetic */ void getVersion$annotations() {
    }

    public final boolean getApplicationVisible() {
        return applicationVisible;
    }

    private final boolean isDebuggableBuild() {
        Lazy lazy = isDebuggableBuild$delegate;
        InternalLeakCanary internalLeakCanary = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Boolean)lazy.getValue();
    }

    @NotNull
    public final LeakDirectoryProvider createLeakDirectoryProvider(@NotNull Context context) {
        Context appContext;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Context context2 = appContext = context.getApplicationContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"appContext");
        return new LeakDirectoryProvider(context2, (Function0<Integer>)((Function0)createLeakDirectoryProvider.1.INSTANCE), (Function0<Boolean>)((Function0)createLeakDirectoryProvider.2.INSTANCE));
    }

    @NotNull
    public final FormFactor getFormFactor() {
        Lazy lazy = formFactor$delegate;
        InternalLeakCanary internalLeakCanary = this;
        Object var3_3 = null;
        boolean bl = false;
        return (FormFactor)((Object)lazy.getValue());
    }

    public final boolean isInstantApp() {
        Lazy lazy = isInstantApp$delegate;
        InternalLeakCanary internalLeakCanary = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Boolean)lazy.getValue();
    }

    @NotNull
    public final OnRetainInstanceListener getOnRetainInstanceListener() {
        Lazy lazy = onRetainInstanceListener$delegate;
        InternalLeakCanary internalLeakCanary = this;
        Object var3_3 = null;
        boolean bl = false;
        return (OnRetainInstanceListener)lazy.getValue();
    }

    @Nullable
    public final Activity getResumedActivity() {
        return resumedActivity;
    }

    public final void setResumedActivity(@Nullable Activity activity) {
        resumedActivity = activity;
    }

    private final SharedPreferences getHeapDumpPrefs() {
        Lazy lazy = heapDumpPrefs$delegate;
        InternalLeakCanary internalLeakCanary = this;
        Object var3_3 = null;
        boolean bl = false;
        return (SharedPreferences)lazy.getValue();
    }

    public final boolean getDumpEnabledInAboutScreen$leakcanary_android_core_release() {
        return this.getHeapDumpPrefs().getBoolean("AboutScreenDumpEnabled", true);
    }

    public final void setDumpEnabledInAboutScreen$leakcanary_android_core_release(boolean value) {
        this.getHeapDumpPrefs().edit().putBoolean("AboutScreenDumpEnabled", value).apply();
    }

    public void invoke(@NotNull Application application2) {
        Intrinsics.checkParameterIsNotNull((Object)application2, (String)"application");
        _application = application2;
        this.checkRunningInDebuggableBuild();
        AppWatcher.INSTANCE.getObjectWatcher().addOnObjectRetainedListener((OnObjectRetainedListener)this);
        AndroidHeapDumper heapDumper = new AndroidHeapDumper((Context)application2, this.createLeakDirectoryProvider((Context)application2));
        GcTrigger.Default gcTrigger = GcTrigger.Default.INSTANCE;
        Function0 configProvider2 = invoke.configProvider.1.INSTANCE;
        HandlerThread handlerThread = new HandlerThread(LEAK_CANARY_THREAD_NAME);
        handlerThread.start();
        Handler backgroundHandler = new Handler(handlerThread.getLooper());
        heapDumpTrigger = new HeapDumpTrigger(application2, backgroundHandler, AppWatcher.INSTANCE.getObjectWatcher(), (GcTrigger)gcTrigger, heapDumper, (Function0<LeakCanary.Config>)configProvider2);
        VisibilityTrackerKt.registerVisibilityListener(application2, (Function1<? super Boolean, Unit>)((Function1)invoke.1.INSTANCE));
        this.registerResumedActivityListener(application2);
        this.addDynamicShortcut(application2);
        boolean $i$f$getMainHandler = false;
        HandlersKt.getMainHandler().post(new Runnable(backgroundHandler, application2){
            final /* synthetic */ Handler $backgroundHandler;
            final /* synthetic */ Application $application;

            public final void run() {
                this.$backgroundHandler.post(new Runnable(this){
                    final /* synthetic */ invoke.2 this$0;

                    public final void run() {
                        SharkLog this_$iv = SharkLog.INSTANCE;
                        boolean $i$f$d = false;
                        SharkLog.Logger logger = this_$iv.getLogger();
                        if (logger == null) {
                        } else {
                            String string2;
                            SharkLog.Logger logger$iv;
                            SharkLog.Logger logger2 = logger$iv = logger;
                            boolean bl = false;
                            HeapDumpControl.ICanHazHeap iCanHasHeap2 = HeapDumpControl.INSTANCE.iCanHasHeap();
                            if (iCanHasHeap2 instanceof HeapDumpControl.ICanHazHeap.Yup) {
                                String string3 = this.this$0.$application.getString(R.string.leak_canary_heap_dump_enabled_text);
                                string2 = string3;
                                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"application.getString(R.\u2026y_heap_dump_enabled_text)");
                            } else if (iCanHasHeap2 instanceof HeapDumpControl.ICanHazHeap.Nope) {
                                String string4 = this.this$0.$application.getString(R.string.leak_canary_heap_dump_disabled_text, new Object[]{((HeapDumpControl.ICanHazHeap.Nope)iCanHasHeap2).getReason().invoke()});
                                string2 = string4;
                                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"application.getString(\n \u2026ap.reason()\n            )");
                            } else {
                                throw new NoWhenBranchMatchedException();
                            }
                            String string5 = string2;
                            logger2.d(string5);
                        }
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.$backgroundHandler = handler;
                this.$application = application2;
            }
        });
    }

    private final void checkRunningInDebuggableBuild() {
        if (this.isDebuggableBuild()) {
            return;
        }
        if (!this.getApplication().getResources().getBoolean(R.bool.leak_canary_allow_in_non_debuggable_build)) {
            throw (Throwable)new Error("LeakCanary in non-debuggable build\n\nLeakCanary should only be used in debug builds, but this APK is not debuggable.\nPlease follow the instructions on the \"Getting started\" page to only include LeakCanary in\ndebug builds: https://square.github.io/leakcanary/getting_started/\n\nIf you're sure you want to include LeakCanary in a non-debuggable build, follow the \ninstructions here: https://square.github.io/leakcanary/recipes/#leakcanary-in-release-builds");
        }
    }

    private final void registerResumedActivityListener(Application application2) {
        application2.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){
            private final /* synthetic */ Application.ActivityLifecycleCallbacks $$delegate_0;

            public void onActivityResumed(@NotNull Activity activity) {
                Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
                InternalLeakCanary.INSTANCE.setResumedActivity(activity);
            }

            public void onActivityPaused(@NotNull Activity activity) {
                Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
                if (InternalLeakCanary.INSTANCE.getResumedActivity() == activity) {
                    InternalLeakCanary.INSTANCE.setResumedActivity(null);
                }
            }
            {
                boolean $i$f$noOpDelegate = false;
                boolean $i$f$noOpDelegate2 = false;
                Class<Application.ActivityLifecycleCallbacks> javaClass$iv$iv = Application.ActivityLifecycleCallbacks.class;
                Object object = Proxy.newProxyInstance(javaClass$iv$iv.getClassLoader(), new Class[]{javaClass$iv$iv}, ObjectsKt.access$getNO_OP_HANDLER$p());
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type android.app.Application.ActivityLifecycleCallbacks");
                }
                this.$$delegate_0 = (Application.ActivityLifecycleCallbacks)object;
            }

            public void onActivityCreated(@RecentlyNonNull Activity p0, @RecentlyNullable Bundle p1) {
                this.$$delegate_0.onActivityCreated(p0, p1);
            }

            public void onActivityDestroyed(@RecentlyNonNull Activity p0) {
                this.$$delegate_0.onActivityDestroyed(p0);
            }

            public void onActivitySaveInstanceState(@RecentlyNonNull Activity p0, @RecentlyNonNull Bundle p1) {
                this.$$delegate_0.onActivitySaveInstanceState(p0, p1);
            }

            public void onActivityStarted(@RecentlyNonNull Activity p0) {
                this.$$delegate_0.onActivityStarted(p0);
            }

            public void onActivityStopped(@RecentlyNonNull Activity p0) {
                this.$$delegate_0.onActivityStopped(p0);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void addDynamicShortcut(Application application2) {
        int n;
        int count$iv;
        int n2;
        void $this$filterTo$iv$iv;
        boolean shortcutInstalled;
        Object shortcut;
        List dynamicShortcuts;
        ShortcutManager shortcutManager;
        block26: {
            boolean bl;
            if (Build.VERSION.SDK_INT < 25) {
                return;
            }
            if (!application2.getResources().getBoolean(R.bool.leak_canary_add_dynamic_shortcut)) {
                return;
            }
            if (this.isInstantApp()) {
                return;
            }
            Object object = application2.getSystemService(ShortcutManager.class);
            if (object == null) {
                Intrinsics.throwNpe();
            }
            shortcutManager = (ShortcutManager)object;
            List list = shortcutManager.getDynamicShortcuts();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"shortcutManager.dynamicShortcuts");
            dynamicShortcuts = list;
            Iterable $this$any$iv = dynamicShortcuts;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    shortcut = (ShortcutInfo)element$iv;
                    boolean bl2 = false;
                    ShortcutInfo shortcutInfo = shortcut;
                    Intrinsics.checkExpressionValueIsNotNull((Object)shortcutInfo, (String)"shortcut");
                    if (!Intrinsics.areEqual((Object)shortcutInfo.getId(), (Object)DYNAMIC_SHORTCUT_ID)) continue;
                    bl = true;
                    break block26;
                }
                bl = shortcutInstalled = false;
            }
        }
        if (shortcutInstalled) {
            return;
        }
        Intent mainIntent = new Intent("android.intent.action.MAIN", null);
        mainIntent.addCategory("android.intent.category.LAUNCHER");
        mainIntent.setPackage(application2.getPackageName());
        List list = application2.getPackageManager().queryIntentActivities(mainIntent, 0);
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"application.packageManag\u2026Activities(mainIntent, 0)");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        shortcut = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ResolveInfo it = (ResolveInfo)element$iv$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)it.activityInfo.name, (Object)"leakcanary.internal.activity.LeakLauncherActivity") ^ true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List activities = (List)destination$iv$iv;
        if (activities.isEmpty()) {
            return;
        }
        ActivityInfo firstMainActivity = ((ResolveInfo)CollectionsKt.first((List)activities)).activityInfo;
        String longLabel = null;
        String shortLabel = null;
        String string2 = application2.getString(R.string.leak_canary_shortcut_label);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"application.getString(R.\u2026ak_canary_shortcut_label)");
        String leakActivityLabel = string2;
        if (activities.isEmpty()) {
            longLabel = leakActivityLabel;
            shortLabel = leakActivityLabel;
        } else {
            CharSequence firstLauncherActivityLabel = firstMainActivity.labelRes != 0 ? (CharSequence)application2.getString(firstMainActivity.labelRes) : application2.getPackageManager().getApplicationLabel(application2.getApplicationInfo());
            String fullLengthLabel = firstLauncherActivityLabel + ' ' + leakActivityLabel;
            if (fullLengthLabel.length() > 10) {
                if (fullLengthLabel.length() <= 25) {
                    longLabel = fullLengthLabel;
                    shortLabel = leakActivityLabel;
                } else {
                    longLabel = leakActivityLabel;
                    shortLabel = leakActivityLabel;
                }
            } else {
                longLabel = fullLengthLabel;
                shortLabel = fullLengthLabel;
            }
        }
        ComponentName componentName = new ComponentName(firstMainActivity.packageName, firstMainActivity.name);
        Iterable $this$count$iv = dynamicShortcuts;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n2 = 0;
        } else {
            count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                ShortcutInfo shortcutInfo22 = (ShortcutInfo)element$iv;
                boolean bl = false;
                ShortcutInfo shortcutInfo = shortcutInfo22;
                Intrinsics.checkExpressionValueIsNotNull((Object)shortcutInfo, (String)"shortcutInfo");
                if (!Intrinsics.areEqual((Object)shortcutInfo.getActivity(), (Object)componentName)) continue;
                int shortcutInfo22 = ++count$iv;
                bl = false;
                if (shortcutInfo22 >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n2 = count$iv;
        }
        List list2 = shortcutManager.getManifestShortcuts();
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"shortcutManager.manifestShortcuts");
        $this$count$iv = list2;
        int n3 = n2;
        $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                ShortcutInfo shortcutInfo32 = (ShortcutInfo)element$iv;
                boolean bl = false;
                ShortcutInfo shortcutInfo = shortcutInfo32;
                Intrinsics.checkExpressionValueIsNotNull((Object)shortcutInfo, (String)"shortcutInfo");
                if (!Intrinsics.areEqual((Object)shortcutInfo.getActivity(), (Object)componentName)) continue;
                int shortcutInfo32 = ++count$iv;
                bl = false;
                if (shortcutInfo32 >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int n4 = n;
        int shortcutCount = n3 + n4;
        if (shortcutCount >= shortcutManager.getMaxShortcutCountPerActivity()) {
            return;
        }
        Intent intent = LeakCanary.INSTANCE.newLeakDisplayActivityIntent();
        intent.setAction("Dummy Action because Android is stupid");
        ShortcutInfo shortcutInfo = new ShortcutInfo.Builder((Context)application2, DYNAMIC_SHORTCUT_ID).setLongLabel((CharSequence)longLabel).setShortLabel((CharSequence)shortLabel).setActivity(componentName).setIcon(Icon.createWithResource((Context)((Context)application2), (int)R.mipmap.leak_canary_icon)).setIntent(intent).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)shortcutInfo, (String)"Builder(application, DYN\u2026nt(intent)\n      .build()");
        ShortcutInfo shortcut2 = shortcutInfo;
        try {
            shortcutManager.addDynamicShortcuts(CollectionsKt.listOf((Object)shortcut2));
        }
        catch (Throwable ignored) {
            SharkLog this_$iv = SharkLog.INSTANCE;
            boolean $i$f$d = false;
            SharkLog.Logger logger = this_$iv.getLogger();
            if (logger == null) {
            }
            SharkLog.Logger logger$iv = logger;
            Throwable throwable = ignored;
            SharkLog.Logger logger2 = logger$iv;
            boolean bl = false;
            String string3 = "Could not add dynamic shortcut. " + "shortcutCount=" + shortcutCount + ", " + "maxShortcutCountPerActivity=" + shortcutManager.getMaxShortcutCountPerActivity();
            logger2.d(throwable, string3);
        }
    }

    public void onObjectRetained() {
        this.scheduleRetainedObjectCheck();
    }

    public final void scheduleRetainedObjectCheck() {
        if (heapDumpTrigger != null) {
            HeapDumpTrigger heapDumpTrigger = InternalLeakCanary.heapDumpTrigger;
            if (heapDumpTrigger == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"heapDumpTrigger");
            }
            HeapDumpTrigger.scheduleRetainedObjectCheck$default(heapDumpTrigger, 0L, 1, null);
        }
    }

    public final void onDumpHeapReceived(boolean forceDump) {
        if (heapDumpTrigger != null) {
            HeapDumpTrigger heapDumpTrigger = InternalLeakCanary.heapDumpTrigger;
            if (heapDumpTrigger == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"heapDumpTrigger");
            }
            heapDumpTrigger.onDumpHeapReceived(forceDump);
        }
    }

    public final void setEnabledBlocking(@NotNull String componentClassName, boolean enabled) {
        Intrinsics.checkParameterIsNotNull((Object)componentClassName, (String)"componentClassName");
        ComponentName component = new ComponentName((Context)this.getApplication(), componentClassName);
        int newState = enabled ? 1 : 2;
        this.getApplication().getPackageManager().setComponentEnabledSetting(component, newState, 1);
    }

    private InternalLeakCanary() {
    }

    static {
        InternalLeakCanary internalLeakCanary;
        INSTANCE = internalLeakCanary = new InternalLeakCanary();
        version = "2.7";
        isDebuggableBuild$delegate = LazyKt.lazy((Function0)isDebuggableBuild.2.INSTANCE);
        formFactor$delegate = LazyKt.lazy((Function0)formFactor.2.INSTANCE);
        isInstantApp$delegate = LazyKt.lazy((Function0)isInstantApp.2.INSTANCE);
        onRetainInstanceListener$delegate = LazyKt.lazy((Function0)onRetainInstanceListener.2.INSTANCE);
        heapDumpPrefs$delegate = LazyKt.lazy((Function0)heapDumpPrefs.2.INSTANCE);
    }

    public static final /* synthetic */ boolean access$getApplicationVisible$p(InternalLeakCanary $this) {
        InternalLeakCanary internalLeakCanary = $this;
        return applicationVisible;
    }

    public static final /* synthetic */ void access$setApplicationVisible$p(InternalLeakCanary $this, boolean bl) {
        InternalLeakCanary internalLeakCanary = $this;
        applicationVisible = bl;
    }

    public static final /* synthetic */ HeapDumpTrigger access$getHeapDumpTrigger$p(InternalLeakCanary $this) {
        InternalLeakCanary internalLeakCanary = $this;
        HeapDumpTrigger heapDumpTrigger = InternalLeakCanary.heapDumpTrigger;
        if (heapDumpTrigger == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"heapDumpTrigger");
        }
        return heapDumpTrigger;
    }

    public static final /* synthetic */ void access$setHeapDumpTrigger$p(InternalLeakCanary $this, HeapDumpTrigger heapDumpTrigger) {
        InternalLeakCanary internalLeakCanary = $this;
        InternalLeakCanary.heapDumpTrigger = heapDumpTrigger;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lleakcanary/internal/InternalLeakCanary$FormFactor;", "", "(Ljava/lang/String;I)V", "MOBILE", "TV", "WATCH", "leakcanary-android-core_release"})
    public static final class FormFactor
    extends Enum<FormFactor> {
        public static final /* enum */ FormFactor MOBILE;
        public static final /* enum */ FormFactor TV;
        public static final /* enum */ FormFactor WATCH;
        private static final /* synthetic */ FormFactor[] $VALUES;

        static {
            FormFactor[] formFactorArray = new FormFactor[3];
            FormFactor[] formFactorArray2 = formFactorArray;
            formFactorArray[0] = MOBILE = new FormFactor();
            formFactorArray[1] = TV = new FormFactor();
            formFactorArray[2] = WATCH = new FormFactor();
            $VALUES = formFactorArray;
        }

        public static FormFactor[] values() {
            return (FormFactor[])$VALUES.clone();
        }

        public static FormFactor valueOf(String string) {
            return Enum.valueOf(FormFactor.class, string);
        }
    }
}

