/*
 * Decompiled with CFR 0.152.
 */
package leakcanary.internal;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Process;
import com.squareup.leakcanary.core.R;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import leakcanary.LeakCanary;
import leakcanary.internal.ForegroundService;
import leakcanary.internal.LeakDirectoryProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import shark.HeapAnalysis;
import shark.HeapAnalysisException;
import shark.HeapAnalysisFailure;
import shark.HeapAnalysisSuccess;
import shark.HeapAnalyzer;
import shark.OnAnalysisProgressListener;
import shark.ProguardMapping;
import shark.ProguardMappingReader;
import shark.SharkLog;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00132\u00020\u00012\u00020\u0002:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\u00020\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0014\u00a8\u0006\u0014"}, d2={"Lleakcanary/internal/HeapAnalyzerService;", "Lleakcanary/internal/ForegroundService;", "Lshark/OnAnalysisProgressListener;", "()V", "analyzeHeap", "Lshark/HeapAnalysis;", "heapDumpFile", "Ljava/io/File;", "config", "Lleakcanary/LeakCanary$Config;", "missingFileFailure", "Lshark/HeapAnalysisFailure;", "onAnalysisProgress", "", "step", "Lshark/OnAnalysisProgressListener$Step;", "onHandleIntentInForeground", "intent", "Landroid/content/Intent;", "Companion", "leakcanary-android-core_release"})
public final class HeapAnalyzerService
extends ForegroundService
implements OnAnalysisProgressListener {
    private static final String HEAPDUMP_FILE_EXTRA = "HEAPDUMP_FILE_EXTRA";
    private static final String HEAPDUMP_DURATION_MILLIS_EXTRA = "HEAPDUMP_DURATION_MILLIS_EXTRA";
    private static final String HEAPDUMP_REASON_EXTRA = "HEAPDUMP_REASON_EXTRA";
    private static final String PROGUARD_MAPPING_FILE_NAME = "leakCanaryObfuscationMapping.txt";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    protected void onHandleIntentInForeground(@Nullable Intent intent) {
        HeapAnalysis heapAnalysis;
        if (intent == null || !intent.hasExtra(HEAPDUMP_FILE_EXTRA)) {
            SharkLog this_$iv = SharkLog.INSTANCE;
            boolean $i$f$d = false;
            SharkLog.Logger logger = this_$iv.getLogger();
            if (logger == null) {
            } else {
                SharkLog.Logger logger$iv;
                SharkLog.Logger logger2 = logger$iv = logger;
                boolean bl = false;
                String string2 = "HeapAnalyzerService received a null or empty intent, ignoring.";
                logger2.d(string2);
            }
            return;
        }
        Process.setThreadPriority((int)10);
        Serializable serializable = intent.getSerializableExtra(HEAPDUMP_FILE_EXTRA);
        if (serializable == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.io.File");
        }
        File heapDumpFile = (File)serializable;
        String heapDumpReason = intent.getStringExtra(HEAPDUMP_REASON_EXTRA);
        long heapDumpDurationMillis = intent.getLongExtra(HEAPDUMP_DURATION_MILLIS_EXTRA, -1L);
        LeakCanary.Config config = LeakCanary.getConfig();
        HeapAnalysis heapAnalysis2 = heapDumpFile.exists() ? this.analyzeHeap(heapDumpFile, config) : (HeapAnalysis)this.missingFileFailure(heapDumpFile);
        HeapAnalysis heapAnalysis3 = heapAnalysis2;
        if (heapAnalysis3 instanceof HeapAnalysisSuccess) {
            heapAnalysis = (HeapAnalysis)HeapAnalysisSuccess.copy$default((HeapAnalysisSuccess)((HeapAnalysisSuccess)heapAnalysis2), null, (long)0L, (long)heapDumpDurationMillis, (long)0L, (Map)MapsKt.plus((Map)((HeapAnalysisSuccess)heapAnalysis2).getMetadata(), (Pair)TuplesKt.to((Object)"Heap dump reason", (Object)heapDumpReason)), null, null, null, (int)235, null);
        } else if (heapAnalysis3 instanceof HeapAnalysisFailure) {
            heapAnalysis = (HeapAnalysis)HeapAnalysisFailure.copy$default((HeapAnalysisFailure)((HeapAnalysisFailure)heapAnalysis2), null, (long)0L, (long)heapDumpDurationMillis, (long)0L, null, (int)27, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        HeapAnalysis fullHeapAnalysis = heapAnalysis;
        this.onAnalysisProgress(OnAnalysisProgressListener.Step.REPORTING_HEAP_ANALYSIS);
        config.getOnHeapAnalyzedListener().onHeapAnalyzed(fullHeapAnalysis);
    }

    private final HeapAnalysis analyzeHeap(File heapDumpFile, LeakCanary.Config config) {
        ProguardMappingReader proguardMappingReader;
        HeapAnalyzer heapAnalyzer = new HeapAnalyzer((OnAnalysisProgressListener)this);
        try {
            InputStream inputStream = this.getAssets().open(PROGUARD_MAPPING_FILE_NAME);
            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"assets.open(PROGUARD_MAPPING_FILE_NAME)");
            proguardMappingReader = new ProguardMappingReader(inputStream);
        }
        catch (IOException e) {
            proguardMappingReader = null;
        }
        ProguardMappingReader proguardMappingReader2 = proguardMappingReader;
        ProguardMappingReader proguardMappingReader3 = proguardMappingReader2;
        return heapAnalyzer.analyze(heapDumpFile, config.getLeakingObjectFinder(), config.getReferenceMatchers(), config.getComputeRetainedHeapSize(), config.getObjectInspectors(), config.getMetadataExtractor(), (ProguardMapping)(proguardMappingReader3 != null ? proguardMappingReader3.readProguardMapping() : null));
    }

    private final HeapAnalysisFailure missingFileFailure(File heapDumpFile) {
        String deletedReason = LeakDirectoryProvider.Companion.hprofDeleteReason(heapDumpFile);
        IllegalStateException exception = new IllegalStateException("Hprof file " + heapDumpFile + " missing, deleted because: " + deletedReason);
        return new HeapAnalysisFailure(heapDumpFile, System.currentTimeMillis(), 0L, 0L, new HeapAnalysisException((Throwable)exception), 4, null);
    }

    public void onAnalysisProgress(@NotNull OnAnalysisProgressListener.Step step) {
        Intrinsics.checkParameterIsNotNull((Object)step, (String)"step");
        int percent = (int)(100.0f * (float)step.ordinal() / (float)OnAnalysisProgressListener.Step.values().length);
        SharkLog this_$iv = SharkLog.INSTANCE;
        boolean $i$f$d22 = false;
        SharkLog.Logger logger = this_$iv.getLogger();
        if (logger == null) {
        } else {
            SharkLog.Logger logger$iv;
            SharkLog.Logger logger2 = logger$iv = logger;
            boolean bl = false;
            String string2 = "Analysis in progress, working on: " + step.name();
            logger2.d(string2);
        }
        String $i$f$d22 = StringsKt.replace$default((String)step.name(), (String)"_", (String)" ", (boolean)false, (int)4, null);
        Locale locale = Locale.US;
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.US");
        Object object = locale;
        int n = 0;
        String string3 = $i$f$d22;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toLowerCase((Locale)object);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toLowerCase(locale)");
        String lowercase = string4;
        StringBuilder stringBuilder = new StringBuilder();
        object = lowercase;
        n = 0;
        int n2 = 1;
        boolean bl = false;
        Object object2 = object;
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = ((String)object2).substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        object = string5;
        Locale locale2 = Locale.US;
        Intrinsics.checkExpressionValueIsNotNull((Object)locale2, (String)"Locale.US");
        Locale locale3 = locale2;
        n2 = 0;
        Object object3 = object;
        if (object3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string6 = ((String)object3).toUpperCase(locale3);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.String).toUpperCase(locale)");
        StringBuilder stringBuilder2 = stringBuilder.append(string6);
        object = lowercase;
        int n3 = 1;
        n2 = 0;
        Object object4 = object;
        if (object4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string7 = ((String)object4).substring(n3);
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.String).substring(startIndex)");
        String message = stringBuilder2.append(string7).toString();
        this.showForegroundNotification(100, percent, false, message);
    }

    public HeapAnalyzerService() {
        String string2 = HeapAnalyzerService.class.getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"HeapAnalyzerService::class.java.simpleName");
        super(string2, R.string.leak_canary_notification_analysing, R.id.leak_canary_notification_analyzing_heap);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J1\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0011J\u0018\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lleakcanary/internal/HeapAnalyzerService$Companion;", "", "()V", "HEAPDUMP_DURATION_MILLIS_EXTRA", "", "HEAPDUMP_FILE_EXTRA", "HEAPDUMP_REASON_EXTRA", "PROGUARD_MAPPING_FILE_NAME", "runAnalysis", "", "context", "Landroid/content/Context;", "heapDumpFile", "Ljava/io/File;", "heapDumpDurationMillis", "", "heapDumpReason", "(Landroid/content/Context;Ljava/io/File;Ljava/lang/Long;Ljava/lang/String;)V", "startForegroundService", "intent", "Landroid/content/Intent;", "leakcanary-android-core_release"})
    public static final class Companion {
        public final void runAnalysis(@NotNull Context context, @NotNull File heapDumpFile, @Nullable Long heapDumpDurationMillis, @NotNull String heapDumpReason) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)heapDumpFile, (String)"heapDumpFile");
            Intrinsics.checkParameterIsNotNull((Object)heapDumpReason, (String)"heapDumpReason");
            Intent intent = new Intent(context, HeapAnalyzerService.class);
            intent.putExtra(HeapAnalyzerService.HEAPDUMP_FILE_EXTRA, (Serializable)heapDumpFile);
            intent.putExtra(HeapAnalyzerService.HEAPDUMP_REASON_EXTRA, heapDumpReason);
            Long l = heapDumpDurationMillis;
            if (l != null) {
                Long l2 = l;
                boolean bl = false;
                boolean bl2 = false;
                long it = ((Number)l2).longValue();
                boolean bl3 = false;
                intent.putExtra(HeapAnalyzerService.HEAPDUMP_DURATION_MILLIS_EXTRA, heapDumpDurationMillis.longValue());
            }
            this.startForegroundService(context, intent);
        }

        public static /* synthetic */ void runAnalysis$default(Companion companion, Context context, File file, Long l, String string2, int n, Object object) {
            if ((n & 4) != 0) {
                l = null;
            }
            if ((n & 8) != 0) {
                string2 = "Unknown";
            }
            companion.runAnalysis(context, file, l, string2);
        }

        private final void startForegroundService(Context context, Intent intent) {
            if (Build.VERSION.SDK_INT >= 26) {
                context.startForegroundService(intent);
            } else {
                context.startService(intent);
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

