/*
 * Decompiled with CFR 0.152.
 */
package leakcanary.internal;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000b\u0010\b\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\rJ\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lleakcanary/internal/FutureResult;", "T", "", "()V", "latch", "Ljava/util/concurrent/CountDownLatch;", "resultHolder", "Ljava/util/concurrent/atomic/AtomicReference;", "get", "()Ljava/lang/Object;", "set", "", "result", "(Ljava/lang/Object;)V", "wait", "", "timeout", "", "unit", "Ljava/util/concurrent/TimeUnit;", "leakcanary-android-core_release"})
public final class FutureResult<T> {
    private final AtomicReference<T> resultHolder = new AtomicReference();
    private final CountDownLatch latch = new CountDownLatch(1);

    public final boolean wait(long timeout, @NotNull TimeUnit unit) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)unit), (String)"unit");
        try {
            return this.latch.await(timeout, unit);
        }
        catch (InterruptedException e) {
            throw (Throwable)new RuntimeException("Did not expect thread to be interrupted", e);
        }
    }

    public final T get() {
        if (this.latch.getCount() > 0L) {
            throw (Throwable)new IllegalStateException("Call wait() and check its result");
        }
        return this.resultHolder.get();
    }

    public final void set(T result) {
        this.resultHolder.set(result);
        this.latch.countDown();
    }
}

