/*
 * Decompiled with CFR 0.152.
 */
package leakcanary.internal;

import android.content.Context;
import android.text.Html;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.method.LinkMovementMethod;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;
import com.squareup.leakcanary.core.R;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import leakcanary.internal.DisplayLeakAdapter$WhenMappings;
import leakcanary.internal.DisplayLeakConnectorView;
import leakcanary.internal.SquigglySpan;
import leakcanary.internal.navigation.ViewsKt;
import leakcanary.internal.utils.SizeKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import shark.LeakTrace;
import shark.LeakTraceObject;
import shark.LeakTraceReference;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 ,2\u00020\u0001:\u0001,B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0019\u001a\u00020\u0014H\u0016J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\"\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010 \u001a\u0004\u0018\u00010\u00122\u0006\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\u0014H\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0014\u0010&\u001a\u00020\n*\u00020'2\u0006\u0010(\u001a\u00020\nH\u0002J\f\u0010)\u001a\u00020\n*\u00020'H\u0002J\f\u0010*\u001a\u00020\n*\u00020+H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lleakcanary/internal/DisplayLeakAdapter;", "Landroid/widget/BaseAdapter;", "context", "Landroid/content/Context;", "leakTrace", "Lshark/LeakTrace;", "header", "", "(Landroid/content/Context;Lshark/LeakTrace;Ljava/lang/CharSequence;)V", "extraColorHexString", "", "helpColorHexString", "highlightColorHexString", "leakColorHexString", "referenceColorHexString", "bindConnectorRow", "", "view", "Landroid/view/View;", "position", "", "bindHeaderRow", "elementIndex", "getConnectorType", "Lleakcanary/internal/DisplayLeakConnectorView$Type;", "getCount", "getItem", "Ljava/io/Serializable;", "getItemId", "", "getItemViewType", "getView", "convertView", "parent", "Landroid/view/ViewGroup;", "getViewTypeCount", "isEnabled", "", "asHtmlString", "Lshark/LeakTraceObject;", "typeName", "styledClassSimpleName", "styledOwningClassSimpleName", "Lshark/LeakTraceReference;", "Companion", "leakcanary-android-core_release"})
public final class DisplayLeakAdapter
extends BaseAdapter {
    private final String highlightColorHexString;
    private final String leakColorHexString;
    private final String referenceColorHexString;
    private final String extraColorHexString;
    private final String helpColorHexString;
    private final LeakTrace leakTrace;
    private final CharSequence header;
    public static final int HEADER_ROW = 0;
    public static final int CONNECTOR_ROW = 1;
    @NotNull
    private static final String INDENTATION;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public View getView(int position, @Nullable View convertView, @NotNull ViewGroup parent) {
        View view;
        Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
        switch (this.getItemViewType(position)) {
            case 0: {
                View view2 = convertView;
                if (view2 == null) {
                    view2 = ViewsKt.inflate(parent, R.layout.leak_canary_leak_header);
                }
                View view3 = view2;
                this.bindHeaderRow(view3);
                view = view3;
                break;
            }
            case 1: {
                View view4 = convertView;
                if (view4 == null) {
                    view4 = ViewsKt.inflate(parent, R.layout.leak_canary_ref_row);
                }
                View view5 = view4;
                this.bindConnectorRow(view5, position);
                view = view5;
                break;
            }
            default: {
                throw (Throwable)new IllegalStateException("Unexpected type " + this.getItemViewType(position));
            }
        }
        return view;
    }

    private final void bindHeaderRow(View view) {
        View view2 = view.findViewById(R.id.leak_canary_header_text);
        boolean bl = false;
        boolean bl2 = false;
        TextView $this$apply = (TextView)view2;
        boolean bl3 = false;
        $this$apply.setMovementMethod(LinkMovementMethod.getInstance());
        $this$apply.setText(this.header);
    }

    private final void bindConnectorRow(View view, int position) {
        CharSequence charSequence;
        TextView titleView = (TextView)view.findViewById(R.id.leak_canary_row_title);
        DisplayLeakConnectorView connector = (DisplayLeakConnectorView)view.findViewById(R.id.leak_canary_row_connector);
        connector.setType(this.getConnectorType(position));
        TextView textView = titleView;
        Intrinsics.checkExpressionValueIsNotNull((Object)textView, (String)"titleView");
        if (position == 1) {
            charSequence = "GC Root: " + this.leakTrace.getGcRootType().getDescription();
        } else if (position < this.getCount() - 1) {
            int referencePathIndex = this.elementIndex(position);
            LeakTraceReference referencePath = (LeakTraceReference)this.leakTrace.getReferencePath().get(referencePathIndex);
            boolean isSuspect = this.leakTrace.referencePathElementIsSuspect(referencePathIndex);
            LeakTraceObject leakTraceObject = referencePath.getOriginObject();
            String typeName = position == 2 && this.leakTrace.getGcRootType() == LeakTrace.GcRootType.JAVA_FRAME ? "thread" : leakTraceObject.getTypeName();
            String referenceName = referencePath.getReferenceDisplayName();
            CharSequence charSequence2 = referenceName;
            String string2 = "<";
            boolean bl = false;
            string2 = new Regex(string2);
            String string3 = "&lt;";
            boolean bl2 = false;
            charSequence2 = string2.replace(charSequence2, string3);
            string2 = ">";
            boolean bl3 = false;
            string2 = new Regex(string2);
            String string4 = "&gt;";
            bl2 = false;
            referenceName = string2.replace(charSequence2, string4);
            String string5 = referenceName = isSuspect ? "<u><font color='" + this.leakColorHexString + "'>" + referenceName + "</font></u>" : "<font color='" + this.referenceColorHexString + "'>" + referenceName + "</font>";
            if (referencePath.getReferenceType() == LeakTraceReference.ReferenceType.STATIC_FIELD) {
                referenceName = "<i>" + referenceName + "</i>";
            }
            if (isSuspect) {
                referenceName = "<b>" + referenceName + "</b>";
            }
            String staticPrefix = referencePath.getReferenceType() == LeakTraceReference.ReferenceType.STATIC_FIELD ? "static " : "";
            String htmlString = this.asHtmlString(leakTraceObject, typeName) + INDENTATION + staticPrefix + this.styledOwningClassSimpleName(referencePath) + '.' + referenceName;
            Spanned spanned = Html.fromHtml((String)htmlString);
            if (spanned == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.text.SpannableStringBuilder");
            }
            SpannableStringBuilder builder = (SpannableStringBuilder)spanned;
            if (isSuspect) {
                Context context = view.getContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"view.context");
                SquigglySpan.Companion.replaceUnderlineSpans(builder, context);
            }
            charSequence = (CharSequence)builder;
        } else {
            charSequence = (CharSequence)Html.fromHtml((String)this.asHtmlString(this.leakTrace.getLeakingObject(), this.leakTrace.getLeakingObject().getTypeName()));
        }
        textView.setText(charSequence);
    }

    private final String asHtmlString(LeakTraceObject $this$asHtmlString, String typeName) {
        String string2;
        String string3;
        boolean bl;
        int packageEnd = StringsKt.lastIndexOf$default((CharSequence)$this$asHtmlString.getClassName(), (char)'.', (int)0, (boolean)false, (int)6, null);
        Function1 extra2 = (Function1)new Function1<String, String>(this){
            final /* synthetic */ DisplayLeakAdapter this$0;

            @NotNull
            public final String invoke(@NotNull String it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return "<font color='" + DisplayLeakAdapter.access$getExtraColorHexString$p(this.this$0) + "'>" + it + "</font>";
            }
            {
                this.this$0 = displayLeakAdapter;
                super(1);
            }
        };
        String styledClassName = this.styledClassSimpleName($this$asHtmlString);
        if (packageEnd != -1) {
            StringBuilder stringBuilder = new StringBuilder();
            String string4 = $this$asHtmlString.getClassName();
            int n = 0;
            bl = false;
            String string5 = string4;
            if (string5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string6 = string5.substring(n, packageEnd);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            string3 = stringBuilder.append((String)extra2.invoke((Object)string6)).append('.').append(styledClassName).toString();
        } else {
            string3 = styledClassName;
        }
        String htmlString = string3;
        htmlString = htmlString + ' ' + (String)extra2.invoke((Object)typeName) + "<br>";
        switch (DisplayLeakAdapter$WhenMappings.$EnumSwitchMapping$0[$this$asHtmlString.getLeakingStatus().ordinal()]) {
            case 1: {
                string2 = (String)extra2.invoke((Object)"UNKNOWN");
                break;
            }
            case 2: {
                string2 = "NO" + (String)extra2.invoke((Object)(" (" + $this$asHtmlString.getLeakingStatusReason() + ')'));
                break;
            }
            case 3: {
                string2 = "YES" + (String)extra2.invoke((Object)(" (" + $this$asHtmlString.getLeakingStatusReason() + ')'));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String reachabilityString = string2;
        htmlString = htmlString + INDENTATION + (String)extra2.invoke((Object)"Leaking: ") + reachabilityString + "<br>";
        Integer n = $this$asHtmlString.getRetainedHeapByteSize();
        if (n != null) {
            Integer n2 = n;
            bl = false;
            boolean bl2 = false;
            int it = ((Number)n2).intValue();
            boolean bl3 = false;
            String humanReadableRetainedHeapSize = SizeKt.humanReadableByteCount(it, true);
            htmlString = htmlString + INDENTATION + (String)extra2.invoke((Object)"Retaining ") + humanReadableRetainedHeapSize + (String)extra2.invoke((Object)" in ") + $this$asHtmlString.getRetainedObjectCount() + (String)extra2.invoke((Object)" objects") + "<br>";
        }
        Iterable $this$forEach$iv = $this$asHtmlString.getLabels();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String label = (String)element$iv;
            boolean bl4 = false;
            htmlString = htmlString + INDENTATION + (String)extra2.invoke((Object)label) + "<br>";
        }
        return htmlString;
    }

    private final String styledClassSimpleName(LeakTraceObject $this$styledClassSimpleName) {
        String simpleName = StringsKt.replace$default((String)$this$styledClassSimpleName.getClassSimpleName(), (String)"[]", (String)"[ ]", (boolean)false, (int)4, null);
        return "<font color='" + this.highlightColorHexString + "'>" + simpleName + "</font>";
    }

    private final String styledOwningClassSimpleName(LeakTraceReference $this$styledOwningClassSimpleName) {
        String simpleName = StringsKt.replace$default((String)$this$styledOwningClassSimpleName.getOwningClassSimpleName(), (String)"[]", (String)"[ ]", (boolean)false, (int)4, null);
        return "<font color='" + this.highlightColorHexString + "'>" + simpleName + "</font>";
    }

    private final DisplayLeakConnectorView.Type getConnectorType(int position) {
        boolean isLeakingInstance;
        if (position == 1) {
            return DisplayLeakConnectorView.Type.GC_ROOT;
        }
        if (position == 2) {
            DisplayLeakConnectorView.Type type;
            switch (this.leakTrace.getReferencePath().size()) {
                case 0: {
                    type = DisplayLeakConnectorView.Type.END_FIRST_UNREACHABLE;
                    break;
                }
                case 1: {
                    type = DisplayLeakConnectorView.Type.START_LAST_REACHABLE;
                    break;
                }
                default: {
                    LeakTraceObject nextReachability = ((LeakTraceReference)this.leakTrace.getReferencePath().get(1)).getOriginObject();
                    type = nextReachability.getLeakingStatus() != LeakTraceObject.LeakingStatus.NOT_LEAKING ? DisplayLeakConnectorView.Type.START_LAST_REACHABLE : DisplayLeakConnectorView.Type.START;
                }
            }
            return type;
        }
        boolean bl = isLeakingInstance = position == this.getCount() - 1;
        if (isLeakingInstance) {
            LeakTraceObject previousReachability = ((LeakTraceReference)CollectionsKt.last((List)this.leakTrace.getReferencePath())).getOriginObject();
            return previousReachability.getLeakingStatus() != LeakTraceObject.LeakingStatus.LEAKING ? DisplayLeakConnectorView.Type.END_FIRST_UNREACHABLE : DisplayLeakConnectorView.Type.END;
        }
        LeakTraceObject reachability = ((LeakTraceReference)this.leakTrace.getReferencePath().get(this.elementIndex(position))).getOriginObject();
        switch (DisplayLeakAdapter$WhenMappings.$EnumSwitchMapping$1[reachability.getLeakingStatus().ordinal()]) {
            case 1: {
                return DisplayLeakConnectorView.Type.NODE_UNKNOWN;
            }
            case 2: {
                LeakTraceObject nextReachability = position + 1 == this.getCount() - 1 ? this.leakTrace.getLeakingObject() : ((LeakTraceReference)this.leakTrace.getReferencePath().get(this.elementIndex(position + 1))).getOriginObject();
                return nextReachability.getLeakingStatus() != LeakTraceObject.LeakingStatus.NOT_LEAKING ? DisplayLeakConnectorView.Type.NODE_LAST_REACHABLE : DisplayLeakConnectorView.Type.NODE_REACHABLE;
            }
            case 3: {
                LeakTraceObject previousReachability = ((LeakTraceReference)this.leakTrace.getReferencePath().get(this.elementIndex(position - 1))).getOriginObject();
                return previousReachability.getLeakingStatus() != LeakTraceObject.LeakingStatus.LEAKING ? DisplayLeakConnectorView.Type.NODE_FIRST_UNREACHABLE : DisplayLeakConnectorView.Type.NODE_UNREACHABLE;
            }
        }
        throw (Throwable)new IllegalStateException("Unknown value: " + reachability.getLeakingStatus());
    }

    public boolean isEnabled(int position) {
        return false;
    }

    public int getCount() {
        return this.leakTrace.getReferencePath().size() + 3;
    }

    @Nullable
    public Serializable getItem(int position) {
        return position == 0 || position == 1 ? null : (position == this.getCount() - 1 ? (Serializable)this.leakTrace.getLeakingObject() : (Serializable)this.leakTrace.getReferencePath().get(this.elementIndex(position)));
    }

    private final int elementIndex(int position) {
        return position - 2;
    }

    public int getViewTypeCount() {
        return 2;
    }

    public int getItemViewType(int position) {
        return position == 0 ? 0 : 1;
    }

    public long getItemId(int position) {
        return position;
    }

    public DisplayLeakAdapter(@NotNull Context context, @NotNull LeakTrace leakTrace, @NotNull CharSequence header) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)leakTrace, (String)"leakTrace");
        Intrinsics.checkParameterIsNotNull((Object)header, (String)"header");
        this.leakTrace = leakTrace;
        this.header = header;
        this.highlightColorHexString = DisplayLeakAdapter.Companion.hexStringColor(context, R.color.leak_canary_class_name);
        this.leakColorHexString = DisplayLeakAdapter.Companion.hexStringColor(context, R.color.leak_canary_leak);
        this.referenceColorHexString = DisplayLeakAdapter.Companion.hexStringColor(context, R.color.leak_canary_reference);
        this.extraColorHexString = DisplayLeakAdapter.Companion.hexStringColor(context, R.color.leak_canary_extra);
        this.helpColorHexString = DisplayLeakAdapter.Companion.hexStringColor(context, R.color.leak_canary_help);
    }

    static {
        Companion = new Companion(null);
        INDENTATION = StringsKt.repeat((CharSequence)"&nbsp;", (int)4);
    }

    public static final /* synthetic */ String access$getExtraColorHexString$p(DisplayLeakAdapter $this) {
        return $this.extraColorHexString;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lleakcanary/internal/DisplayLeakAdapter$Companion;", "", "()V", "CONNECTOR_ROW", "", "HEADER_ROW", "INDENTATION", "", "getINDENTATION", "()Ljava/lang/String;", "hexStringColor", "context", "Landroid/content/Context;", "colorResId", "leakcanary-android-core_release"})
    public static final class Companion {
        @NotNull
        public final String getINDENTATION() {
            return INDENTATION;
        }

        private final String hexStringColor(Context context, int colorResId) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string2 = "#%06X";
            Object[] objectArray = new Object[]{0xFFFFFF & ViewsKt.getColorCompat(context, colorResId)};
            boolean bl = false;
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
            return string3;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

