/*
 * Decompiled with CFR 0.152.
 */
package leakcanary.internal;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.app.Activity;
import android.app.Notification;
import android.app.NotificationManager;
import android.content.Context;
import android.os.Debug;
import android.os.SystemClock;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Toast;
import com.squareup.leakcanary.core.R;
import java.io.File;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import leakcanary.internal.AndroidHeapDumper;
import leakcanary.internal.DumpHeapResult;
import leakcanary.internal.FutureResult;
import leakcanary.internal.HandlersKt;
import leakcanary.internal.HeapDump;
import leakcanary.internal.HeapDumper;
import leakcanary.internal.InternalLeakCanary;
import leakcanary.internal.LeakDirectoryProvider;
import leakcanary.internal.NoHeapDump;
import leakcanary.internal.NotificationType;
import leakcanary.internal.Notifications;
import org.jetbrains.annotations.NotNull;
import shark.SharkLog;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\b2\u000e\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lleakcanary/internal/AndroidHeapDumper;", "Lleakcanary/internal/HeapDumper;", "context", "Landroid/content/Context;", "leakDirectoryProvider", "Lleakcanary/internal/LeakDirectoryProvider;", "(Landroid/content/Context;Lleakcanary/internal/LeakDirectoryProvider;)V", "cancelToast", "", "toast", "Landroid/widget/Toast;", "dumpHeap", "Lleakcanary/internal/DumpHeapResult;", "showToast", "waitingForToast", "Lleakcanary/internal/FutureResult;", "leakcanary-android-core_release"})
public final class AndroidHeapDumper
implements HeapDumper {
    private final Context context;
    private final LeakDirectoryProvider leakDirectoryProvider;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public DumpHeapResult dumpHeap() {
        DumpHeapResult dumpHeapResult;
        File file = this.leakDirectoryProvider.newHeapDumpFile();
        if (file == null) {
            return NoHeapDump.INSTANCE;
        }
        File heapDumpFile = file;
        FutureResult<Toast> waitingForToast = new FutureResult<Toast>();
        this.showToast(waitingForToast);
        if (!waitingForToast.wait(5L, TimeUnit.SECONDS)) {
            SharkLog this_$iv = SharkLog.INSTANCE;
            boolean $i$f$d = false;
            SharkLog.Logger logger = this_$iv.getLogger();
            if (logger == null) {
            } else {
                SharkLog.Logger logger$iv;
                SharkLog.Logger logger2 = logger$iv = logger;
                boolean bl = false;
                String string2 = "Did not dump heap, too much time waiting for Toast.";
                logger2.d(string2);
            }
            return NoHeapDump.INSTANCE;
        }
        Object object = this.context.getSystemService("notification");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.app.NotificationManager");
        }
        NotificationManager notificationManager = (NotificationManager)object;
        if (Notifications.INSTANCE.getCanShowNotification()) {
            Notification.Builder builder;
            String string3 = this.context.getString(R.string.leak_canary_notification_dumping);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"context.getString(R.stri\u2026ary_notification_dumping)");
            String dumpingHeap = string3;
            Notification.Builder builder2 = builder = new Notification.Builder(this.context).setContentTitle((CharSequence)dumpingHeap);
            Intrinsics.checkExpressionValueIsNotNull((Object)builder2, (String)"builder");
            Notification notification = Notifications.INSTANCE.buildNotification(this.context, builder2, NotificationType.LEAKCANARY_LOW);
            notificationManager.notify(R.id.leak_canary_notification_dumping_heap, notification);
        }
        Toast toast = waitingForToast.get();
        try {
            DumpHeapResult dumpHeapResult2;
            boolean $i$f$measureDurationMillis = false;
            boolean $i$f$measureDurationMillis2 = false;
            long start$iv$iv = SystemClock.uptimeMillis();
            boolean bl = false;
            Debug.dumpHprofData((String)heapDumpFile.getAbsolutePath());
            long durationMillis = SystemClock.uptimeMillis() - start$iv$iv;
            if (heapDumpFile.length() == 0L) {
                SharkLog this_$iv = SharkLog.INSTANCE;
                boolean $i$f$d = false;
                SharkLog.Logger logger = this_$iv.getLogger();
                if (logger == null) {
                } else {
                    SharkLog.Logger logger$iv;
                    SharkLog.Logger logger3 = logger$iv = logger;
                    boolean bl2 = false;
                    String string4 = "Dumped heap file is 0 byte length";
                    logger3.d(string4);
                }
                dumpHeapResult2 = NoHeapDump.INSTANCE;
            } else {
                dumpHeapResult2 = new HeapDump(heapDumpFile, durationMillis);
            }
            dumpHeapResult = dumpHeapResult2;
        }
        catch (Exception e) {
            SharkLog this_$iv = SharkLog.INSTANCE;
            boolean $i$f$d = false;
            SharkLog.Logger logger = this_$iv.getLogger();
            if (logger == null) {
            } else {
                SharkLog.Logger logger$iv = logger;
                Throwable throwable = e;
                SharkLog.Logger logger4 = logger$iv;
                boolean bl = false;
                String string5 = "Could not dump heap";
                logger4.d(throwable, string5);
            }
            dumpHeapResult = NoHeapDump.INSTANCE;
        }
        finally {
            this.cancelToast(toast);
            notificationManager.cancel(R.id.leak_canary_notification_dumping_heap);
        }
        return dumpHeapResult;
    }

    private final void showToast(FutureResult<Toast> waitingForToast) {
        boolean $i$f$getMainHandler = false;
        HandlersKt.getMainHandler().post(new Runnable(this, waitingForToast){
            final /* synthetic */ AndroidHeapDumper this$0;
            final /* synthetic */ FutureResult $waitingForToast;

            public final void run() {
                View toastIcon;
                Activity resumedActivity = InternalLeakCanary.INSTANCE.getResumedActivity();
                if (resumedActivity == null) {
                    this.$waitingForToast.set(null);
                    return;
                }
                Toast toast = new Toast((Context)resumedActivity);
                int iconSize = AndroidHeapDumper.access$getContext$p(this.this$0).getResources().getDimensionPixelSize(R.dimen.leak_canary_toast_icon_size);
                toast.setGravity(16, 0, -iconSize);
                toast.setDuration(1);
                LayoutInflater inflater = LayoutInflater.from((Context)AndroidHeapDumper.access$getContext$p(this.this$0));
                toast.setView(inflater.inflate(R.layout.leak_canary_heap_dump_toast, null));
                toast.show();
                View view = toastIcon = toast.getView().findViewById(R.id.leak_canary_toast_icon);
                Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"toastIcon");
                view.setTranslationY(-((float)iconSize));
                toastIcon.animate().translationY(0.0f).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(this, toast){
                    final /* synthetic */ showToast.1 this$0;
                    final /* synthetic */ Toast $toast;

                    public void onAnimationEnd(@NotNull Animator animation) {
                        Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
                        this.this$0.$waitingForToast.set(this.$toast);
                    }
                    {
                        this.this$0 = this$0;
                        this.$toast = $captured_local_variable$1;
                    }
                });
            }
            {
                this.this$0 = androidHeapDumper;
                this.$waitingForToast = futureResult;
            }
        });
    }

    private final void cancelToast(Toast toast) {
        if (toast == null) {
            return;
        }
        boolean $i$f$getMainHandler = false;
        HandlersKt.getMainHandler().post(new Runnable(toast){
            final /* synthetic */ Toast $toast;

            public final void run() {
                this.$toast.cancel();
            }
            {
                this.$toast = toast;
            }
        });
    }

    public AndroidHeapDumper(@NotNull Context context, @NotNull LeakDirectoryProvider leakDirectoryProvider) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)leakDirectoryProvider, (String)"leakDirectoryProvider");
        this.leakDirectoryProvider = leakDirectoryProvider;
        Context context2 = context.getApplicationContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context.applicationContext");
        this.context = context2;
    }

    public static final /* synthetic */ Context access$getContext$p(AndroidHeapDumper $this) {
        return $this.context;
    }
}

