/*
 * Decompiled with CFR 0.152.
 */
package leakcanary;

import android.app.Activity;
import android.app.Application;
import android.app.PendingIntent;
import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import com.squareup.leakcanary.core.R;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import leakcanary.DefaultOnHeapAnalyzedListener;
import leakcanary.OnHeapAnalyzedListener;
import leakcanary.internal.HandlersKt;
import leakcanary.internal.InternalLeakCanary;
import leakcanary.internal.NotificationType;
import leakcanary.internal.Notifications;
import leakcanary.internal.activity.LeakActivity;
import leakcanary.internal.activity.db.HeapAnalysisTable;
import leakcanary.internal.activity.db.LeaksDbHelper;
import leakcanary.internal.activity.screen.HeapAnalysisFailureScreen;
import leakcanary.internal.activity.screen.HeapDumpScreen;
import leakcanary.internal.activity.screen.HeapDumpsScreen;
import leakcanary.internal.activity.screen.LeakTraceWrapper;
import leakcanary.internal.navigation.Screen;
import leakcanary.internal.tv.TvToast;
import org.jetbrains.annotations.NotNull;
import shark.HeapAnalysis;
import shark.HeapAnalysisFailure;
import shark.HeapAnalysisSuccess;
import shark.Leak;
import shark.SharkLog;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u000f\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\b\u0002\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\rH\u0002J\u0018\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u001b\u0010\u0002\u001a\u00020\u00038BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lleakcanary/DefaultOnHeapAnalyzedListener;", "Lleakcanary/OnHeapAnalyzedListener;", "application", "Landroid/app/Application;", "(Landroid/app/Application;)V", "applicationProvider", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)V", "getApplication", "()Landroid/app/Application;", "application$delegate", "Lkotlin/Lazy;", "onHeapAnalyzed", "", "heapAnalysis", "Lshark/HeapAnalysis;", "printIntentInfo", "showNotification", "screenToShow", "Lleakcanary/internal/navigation/Screen;", "contentTitle", "", "showToast", "Companion", "leakcanary-android-core_release"})
public final class DefaultOnHeapAnalyzedListener
implements OnHeapAnalyzedListener {
    private final Lazy application$delegate;
    private final Function0<Application> applicationProvider;
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final Application getApplication() {
        Lazy lazy = this.application$delegate;
        DefaultOnHeapAnalyzedListener defaultOnHeapAnalyzedListener = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Application)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onHeapAnalyzed(@NotNull HeapAnalysis heapAnalysis) {
        Pair pair;
        SQLiteDatabase db;
        Intrinsics.checkParameterIsNotNull((Object)heapAnalysis, (String)"heapAnalysis");
        SharkLog this_$iv = SharkLog.INSTANCE;
        boolean $i$f$d = false;
        SharkLog.Logger logger = this_$iv.getLogger();
        if (logger == null) {
        } else {
            SharkLog.Logger logger$iv;
            SharkLog.Logger logger2 = logger$iv = logger;
            boolean bl = false;
            String string2 = "\u200b\n" + LeakTraceWrapper.INSTANCE.wrap(heapAnalysis.toString(), 120);
            logger2.d(string2);
        }
        SQLiteDatabase sQLiteDatabase = db = new LeaksDbHelper((Context)this.getApplication()).getWritableDatabase();
        Intrinsics.checkExpressionValueIsNotNull((Object)sQLiteDatabase, (String)"db");
        long id = HeapAnalysisTable.INSTANCE.insert(sQLiteDatabase, heapAnalysis);
        db.releaseReference();
        HeapAnalysis heapAnalysis2 = heapAnalysis;
        if (heapAnalysis2 instanceof HeapAnalysisFailure) {
            pair = TuplesKt.to((Object)this.getApplication().getString(R.string.leak_canary_analysis_failed), (Object)new HeapAnalysisFailureScreen(id));
        } else if (heapAnalysis2 instanceof HeapAnalysisSuccess) {
            Sequence $this$sumBy$iv = ((HeapAnalysisSuccess)heapAnalysis).getAllLeaks();
            boolean $i$f$sumBy = false;
            int sum$iv = 0;
            for (Object element$iv : $this$sumBy$iv) {
                void it;
                Leak leak = (Leak)element$iv;
                int n = sum$iv;
                boolean bl = false;
                int n2 = it.getLeakTraces().size();
                sum$iv = n + n2;
            }
            int retainedObjectCount = sum$iv;
            int leakTypeCount = ((HeapAnalysisSuccess)heapAnalysis).getApplicationLeaks().size() + ((HeapAnalysisSuccess)heapAnalysis).getLibraryLeaks().size();
            pair = TuplesKt.to((Object)this.getApplication().getString(R.string.leak_canary_analysis_success_notification, new Object[]{retainedObjectCount, leakTypeCount}), (Object)new HeapDumpScreen(id));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Pair pair2 = pair;
        String bl = (String)pair2.component1();
        Screen screenToShow = (Screen)pair2.component2();
        if (InternalLeakCanary.INSTANCE.getFormFactor() == InternalLeakCanary.FormFactor.TV) {
            this.showToast(heapAnalysis);
            this.printIntentInfo();
        } else {
            void contentTitle;
            void v3 = contentTitle;
            Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"contentTitle");
            this.showNotification(screenToShow, (String)v3);
        }
    }

    private final void showNotification(Screen screenToShow, String contentTitle) {
        PendingIntent pendingIntent = LeakActivity.Companion.createPendingIntent((Context)this.getApplication(), CollectionsKt.arrayListOf((Object[])new Screen[]{new HeapDumpsScreen(), screenToShow}));
        String string2 = this.getApplication().getString(R.string.leak_canary_notification_message);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"application.getString(R.\u2026ary_notification_message)");
        String contentText = string2;
        Notifications.INSTANCE.showNotification((Context)this.getApplication(), contentTitle, contentText, pendingIntent, R.id.leak_canary_notification_analysis_result, NotificationType.LEAKCANARY_MAX);
    }

    private final void showToast(HeapAnalysis heapAnalysis) {
        boolean $i$f$getMainHandler = false;
        HandlersKt.getMainHandler().post(new Runnable(this, heapAnalysis){
            final /* synthetic */ DefaultOnHeapAnalyzedListener this$0;
            final /* synthetic */ HeapAnalysis $heapAnalysis;

            public final void run() {
                String string2;
                Activity activity = InternalLeakCanary.INSTANCE.getResumedActivity();
                if (activity == null) {
                    return;
                }
                Activity resumedActivity = activity;
                HeapAnalysis heapAnalysis = this.$heapAnalysis;
                if (heapAnalysis instanceof HeapAnalysisSuccess) {
                    String string3 = DefaultOnHeapAnalyzedListener.access$getApplication$p(this.this$0).getString(R.string.leak_canary_tv_analysis_success, new Object[]{((HeapAnalysisSuccess)this.$heapAnalysis).getApplicationLeaks().size(), ((HeapAnalysisSuccess)this.$heapAnalysis).getLibraryLeaks().size()});
                    string2 = string3;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"application.getString(\n \u2026aryLeaks.size\n          )");
                } else if (heapAnalysis instanceof HeapAnalysisFailure) {
                    String string4 = DefaultOnHeapAnalyzedListener.access$getApplication$p(this.this$0).getString(R.string.leak_canary_tv_analysis_failure);
                    string2 = string4;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"application.getString(R.\u2026nary_tv_analysis_failure)");
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                String message = string2;
                TvToast.INSTANCE.makeText(resumedActivity, message).show();
            }
            {
                this.this$0 = defaultOnHeapAnalyzedListener;
                this.$heapAnalysis = heapAnalysis;
            }
        });
    }

    private final void printIntentInfo() {
        Class<LeakActivity> leakClass = LeakActivity.class;
        SharkLog this_$iv = SharkLog.INSTANCE;
        boolean $i$f$d = false;
        SharkLog.Logger logger = this_$iv.getLogger();
        if (logger == null) {
        } else {
            SharkLog.Logger logger$iv;
            SharkLog.Logger logger2 = logger$iv = logger;
            boolean bl = false;
            Package package_ = leakClass.getPackage();
            String string2 = "====================================\n  ANDROID TV LAUNCH INTENT\n  ====================================\n  Run the following adb command to display the list of leaks:\n  \n  adb shell am start -n \"" + this.getApplication().getPackageName() + '/' + (package_ != null ? package_.getName() : null) + ".LeakLauncherActivity\"\n  ====================================";
            logger2.d(string2);
        }
    }

    private DefaultOnHeapAnalyzedListener(Function0<? extends Application> applicationProvider) {
        this.applicationProvider = applicationProvider;
        this.application$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Application>(this){
            final /* synthetic */ DefaultOnHeapAnalyzedListener this$0;

            @NotNull
            public final Application invoke() {
                return (Application)DefaultOnHeapAnalyzedListener.access$getApplicationProvider$p(this.this$0).invoke();
            }
            {
                this.this$0 = defaultOnHeapAnalyzedListener;
                super(0);
            }
        }));
    }

    @Deprecated(message="Use DefaultOnHeapAnalyzedListener.create() instead", replaceWith=@ReplaceWith(imports={}, expression="DefaultOnHeapAnalyzedListener.create()"))
    public DefaultOnHeapAnalyzedListener(final @NotNull Application application2) {
        Intrinsics.checkParameterIsNotNull((Object)application2, (String)"application");
        this((Function0<? extends Application>)((Function0)new Function0<Application>(){

            @NotNull
            public final Application invoke() {
                return application2;
            }
        }));
    }

    public static final /* synthetic */ Application access$getApplication$p(DefaultOnHeapAnalyzedListener $this) {
        return $this.getApplication();
    }

    public static final /* synthetic */ Function0 access$getApplicationProvider$p(DefaultOnHeapAnalyzedListener $this) {
        return $this.applicationProvider;
    }

    public /* synthetic */ DefaultOnHeapAnalyzedListener(Function0 applicationProvider, DefaultConstructorMarker $constructor_marker) {
        this((Function0<? extends Application>)applicationProvider);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lleakcanary/DefaultOnHeapAnalyzedListener$Companion;", "", "()V", "create", "Lleakcanary/OnHeapAnalyzedListener;", "leakcanary-android-core_release"})
    public static final class Companion {
        @NotNull
        public final OnHeapAnalyzedListener create() {
            return new DefaultOnHeapAnalyzedListener(create.1.INSTANCE, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

