/*
 * Decompiled with CFR 0.152.
 */
package leakcanary.internal.navigation;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.View;
import android.view.ViewGroup;
import com.squareup.leakcanary.core.R;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import leakcanary.internal.navigation.NavigatingActivity;
import leakcanary.internal.navigation.Screen;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001b\u0010\u0000\u001a\u0002H\u0005\"\b\b\u0000\u0010\u0005*\u00020\u0001*\u00020\u0002H\u0000\u00a2\u0006\u0002\u0010\u0004\u001a\u0014\u0010\u0006\u001a\u00020\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\u0007H\u0000\u001a\f\u0010\n\u001a\u00020\u000b*\u00020\u0002H\u0000\u001a\u0014\u0010\f\u001a\u00020\u000b*\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0000\u001a\u0014\u0010\u000f\u001a\u00020\u0002*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0007H\u0000\u001a\f\u0010\u0012\u001a\u00020\u000b*\u00020\u0002H\u0000\u001a \u0010\u0013\u001a\u00020\u000b*\u00020\u00022\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u000b0\u0014H\u0000\u001a\u001a\u0010\u0016\u001a\u00020\u000b*\u00020\u00022\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0018H\u0000\u001a\f\u0010\u0019\u001a\u00020\u000b*\u00020\u0002H\u0000\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u001a"}, d2={"activity", "Landroid/app/Activity;", "Landroid/view/View;", "getActivity", "(Landroid/view/View;)Landroid/app/Activity;", "T", "getColorCompat", "", "Landroid/content/Context;", "id", "goBack", "", "goTo", "screen", "Lleakcanary/internal/navigation/Screen;", "inflate", "Landroid/view/ViewGroup;", "layoutResId", "notifyScreenExiting", "onCreateOptionsMenu", "Lkotlin/Function1;", "Landroid/view/Menu;", "onScreenExiting", "block", "Lkotlin/Function0;", "restoreViewStateFromTag", "leakcanary-android-core_release"})
public final class ViewsKt {
    @NotNull
    public static final View inflate(@NotNull ViewGroup $this$inflate, int layoutResId) {
        Intrinsics.checkParameterIsNotNull((Object)$this$inflate, (String)"$this$inflate");
        View view = LayoutInflater.from((Context)$this$inflate.getContext()).inflate(layoutResId, $this$inflate, false);
        if (view == null) {
            Intrinsics.throwNpe();
        }
        return view;
    }

    public static final void restoreViewStateFromTag(@NotNull View $this$restoreViewStateFromTag) {
        Intrinsics.checkParameterIsNotNull((Object)$this$restoreViewStateFromTag, (String)"$this$restoreViewStateFromTag");
        SparseArray viewState = (SparseArray)$this$restoreViewStateFromTag.getTag(R.id.leak_canary_restored_view_state);
        if (viewState != null) {
            $this$restoreViewStateFromTag.restoreHierarchyState(viewState);
        }
    }

    @NotNull
    public static final Activity getActivity(@NotNull View $this$activity) {
        Intrinsics.checkParameterIsNotNull((Object)$this$activity, (String)"$this$activity");
        Context context = $this$activity.getContext();
        if (context == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.app.Activity");
        }
        return (Activity)context;
    }

    @NotNull
    public static final <T extends Activity> T activity(@NotNull View $this$activity) {
        Intrinsics.checkParameterIsNotNull((Object)$this$activity, (String)"$this$activity");
        Context context = $this$activity.getContext();
        if (context == null) {
            throw new TypeCastException("null cannot be cast to non-null type T");
        }
        return (T)((Activity)context);
    }

    public static final void onCreateOptionsMenu(@NotNull View $this$onCreateOptionsMenu, @NotNull Function1<? super Menu, Unit> onCreateOptionsMenu) {
        Intrinsics.checkParameterIsNotNull((Object)$this$onCreateOptionsMenu, (String)"$this$onCreateOptionsMenu");
        Intrinsics.checkParameterIsNotNull(onCreateOptionsMenu, (String)"onCreateOptionsMenu");
        ((NavigatingActivity)((Object)ViewsKt.activity($this$onCreateOptionsMenu))).setOnCreateOptionsMenu(onCreateOptionsMenu);
        ViewsKt.getActivity($this$onCreateOptionsMenu).invalidateOptionsMenu();
    }

    public static final void goTo(@NotNull View $this$goTo, @NotNull Screen screen) {
        Intrinsics.checkParameterIsNotNull((Object)$this$goTo, (String)"$this$goTo");
        Intrinsics.checkParameterIsNotNull((Object)screen, (String)"screen");
        ((NavigatingActivity)((Object)ViewsKt.activity($this$goTo))).goTo(screen);
    }

    public static final void goBack(@NotNull View $this$goBack) {
        Intrinsics.checkParameterIsNotNull((Object)$this$goBack, (String)"$this$goBack");
        ((NavigatingActivity)((Object)ViewsKt.activity($this$goBack))).goBack();
    }

    public static final int getColorCompat(@NotNull Context $this$getColorCompat, int id2) {
        Intrinsics.checkParameterIsNotNull((Object)$this$getColorCompat, (String)"$this$getColorCompat");
        return Build.VERSION.SDK_INT >= 23 ? $this$getColorCompat.getColor(id2) : $this$getColorCompat.getResources().getColor(id2);
    }

    public static final void onScreenExiting(@NotNull View $this$onScreenExiting, @NotNull Function0<Unit> block) {
        Intrinsics.checkParameterIsNotNull((Object)$this$onScreenExiting, (String)"$this$onScreenExiting");
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        List callbacks = TypeIntrinsics.asMutableList((Object)$this$onScreenExiting.getTag(R.id.leak_canary_notification_on_screen_exit));
        if (callbacks == null) {
            boolean bl = false;
            callbacks = new ArrayList();
            $this$onScreenExiting.setTag(R.id.leak_canary_notification_on_screen_exit, (Object)callbacks);
        }
        callbacks.add(block);
    }

    public static final void notifyScreenExiting(@NotNull View $this$notifyScreenExiting) {
        List callbacks;
        Intrinsics.checkParameterIsNotNull((Object)$this$notifyScreenExiting, (String)"$this$notifyScreenExiting");
        List list = callbacks = TypeIntrinsics.asMutableList((Object)$this$notifyScreenExiting.getTag(R.id.leak_canary_notification_on_screen_exit));
        if (list != null) {
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Function0 it = (Function0)element$iv;
                boolean bl = false;
                it.invoke();
            }
        }
    }
}

