/*
 * Decompiled with CFR 0.152.
 */
package leakcanary.internal.activity.screen;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.squareup.leakcanary.core.R;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import leakcanary.internal.activity.db.Db;
import leakcanary.internal.activity.db.DbKt;
import leakcanary.internal.activity.db.HeapAnalysisTable;
import leakcanary.internal.activity.db.LeakTable;
import leakcanary.internal.activity.screen.LeakScreen;
import leakcanary.internal.activity.screen.LeaksScreen$createView$;
import leakcanary.internal.activity.ui.SimpleListAdapter;
import leakcanary.internal.activity.ui.TimeFormatter;
import leakcanary.internal.navigation.NavigatingActivity;
import leakcanary.internal.navigation.Screen;
import leakcanary.internal.navigation.ViewsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001a\u0010\u0007\u001a\u00020\b*\u00020\u00042\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002\u00a8\u0006\f"}, d2={"Lleakcanary/internal/activity/screen/LeaksScreen;", "Lleakcanary/internal/navigation/Screen;", "()V", "createView", "Landroid/view/View;", "container", "Landroid/view/ViewGroup;", "onGroupsRetrieved", "", "projections", "", "Lleakcanary/internal/activity/db/LeakTable$AllLeaksProjection;", "leakcanary-android-core_release"})
public final class LeaksScreen
extends Screen {
    @Override
    @NotNull
    public View createView(@NotNull ViewGroup container) {
        Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
        View view = ViewsKt.inflate(container, R.layout.leak_canary_list);
        boolean bl = false;
        boolean bl2 = false;
        View $this$apply = view;
        boolean bl3 = false;
        Function0<Unit> unsubscribeRefresh2 = HeapAnalysisTable.INSTANCE.onUpdate((Function0<Unit>)((Function0)new Function0<Unit>($this$apply){
            final /* synthetic */ View $this_apply;

            public final void invoke() {
                ((NavigatingActivity)((Object)ViewsKt.activity(this.$this_apply))).refreshCurrentScreen();
            }
            {
                this.$this_apply = view;
                super(0);
            }
        }));
        ViewsKt.onScreenExiting($this$apply, (Function0<Unit>)((Function0)new Function0<Unit>(unsubscribeRefresh2){
            final /* synthetic */ Function0 $unsubscribeRefresh;

            public final void invoke() {
                this.$unsubscribeRefresh.invoke();
            }
            {
                this.$unsubscribeRefresh = function0;
                super(0);
            }
        }));
        DbKt.executeOnDb($this$apply, (Function1<? super Db.OnDb, Unit>)((Function1)new Function1<Db.OnDb, Unit>(this){
            final /* synthetic */ LeaksScreen this$0;
            {
                this.this$0 = leaksScreen;
                super(1);
            }

            public final void invoke(@NotNull Db.OnDb $this$executeOnDb) {
                Intrinsics.checkParameterIsNotNull((Object)$this$executeOnDb, (String)"$receiver");
                List<LeakTable.AllLeaksProjection> projections = LeakTable.INSTANCE.retrieveAllLeaks($this$executeOnDb.getDb());
                $this$executeOnDb.updateUi((Function1<? super View, Unit>)((Function1)new Function1<View, Unit>(this, projections){
                    final /* synthetic */ createView$$inlined$apply$lambda$1 this$0;
                    final /* synthetic */ List $projections;
                    {
                        this.this$0 = var1_1;
                        this.$projections = list;
                        super(1);
                    }

                    public final void invoke(@NotNull View $this$updateUi) {
                        Intrinsics.checkParameterIsNotNull((Object)$this$updateUi, (String)"$receiver");
                        LeaksScreen.access$onGroupsRetrieved(this.this$0.this$0, $this$updateUi, this.$projections);
                    }
                }));
            }
        }));
        return view;
    }

    private final void onGroupsRetrieved(View $this$onGroupsRetrieved, List<LeakTable.AllLeaksProjection> projections) {
        ListView listView;
        ViewsKt.getActivity($this$onGroupsRetrieved).setTitle((CharSequence)$this$onGroupsRetrieved.getResources().getQuantityString(R.plurals.leak_canary_distinct_leaks, projections.size(), new Object[]{projections.size()}));
        ListView listView2 = listView = (ListView)$this$onGroupsRetrieved.findViewById(R.id.leak_canary_list);
        Intrinsics.checkExpressionValueIsNotNull((Object)listView2, (String)"listView");
        listView2.setAdapter((ListAdapter)new SimpleListAdapter<LeakTable.AllLeaksProjection>(R.layout.leak_canary_leak_row, projections, (Function3)new Function3<SimpleListAdapter<LeakTable.AllLeaksProjection>, View, Integer, Unit>($this$onGroupsRetrieved, projections){
            final /* synthetic */ View $this_onGroupsRetrieved;
            final /* synthetic */ List $projections;

            public final void invoke(@NotNull SimpleListAdapter<LeakTable.AllLeaksProjection> $receiver, @NotNull View view, int position) {
                Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
                TextView countView = (TextView)view.findViewById(R.id.leak_canary_count_text);
                TextView descriptionView = (TextView)view.findViewById(R.id.leak_canary_leak_text);
                TextView timeView = (TextView)view.findViewById(R.id.leak_canary_time_text);
                TextView newChipView = (TextView)view.findViewById(R.id.leak_canary_chip_new);
                TextView libraryLeakChipView = (TextView)view.findViewById(R.id.leak_canary_chip_library_leak);
                LeakTable.AllLeaksProjection projection = (LeakTable.AllLeaksProjection)this.$projections.get(position);
                TextView textView = countView;
                Intrinsics.checkExpressionValueIsNotNull((Object)textView, (String)"countView");
                textView.setEnabled(projection.isNew());
                TextView textView2 = newChipView;
                Intrinsics.checkExpressionValueIsNotNull((Object)textView2, (String)"newChipView");
                textView2.setVisibility(projection.isNew() ? 0 : 8);
                TextView textView3 = libraryLeakChipView;
                Intrinsics.checkExpressionValueIsNotNull((Object)textView3, (String)"libraryLeakChipView");
                textView3.setVisibility(projection.isLibraryLeak() ? 0 : 8);
                countView.setText((CharSequence)String.valueOf(projection.getLeakTraceCount()));
                TextView textView4 = descriptionView;
                Intrinsics.checkExpressionValueIsNotNull((Object)textView4, (String)"descriptionView");
                textView4.setText((CharSequence)projection.getShortDescription());
                Context context = view.getContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"view.context");
                String formattedDate = TimeFormatter.INSTANCE.formatTimestamp(context, projection.getCreatedAtTimeMillis());
                TextView textView5 = timeView;
                Intrinsics.checkExpressionValueIsNotNull((Object)textView5, (String)"timeView");
                textView5.setText((CharSequence)this.$this_onGroupsRetrieved.getResources().getString(R.string.leak_canary_group_list_time_label, new Object[]{formattedDate}));
            }
            {
                this.$this_onGroupsRetrieved = view;
                this.$projections = list;
                super(3);
            }
        }));
        listView.setOnItemClickListener(new AdapterView.OnItemClickListener($this$onGroupsRetrieved, projections){
            final /* synthetic */ View $this_onGroupsRetrieved;
            final /* synthetic */ List $projections;

            public final void onItemClick(AdapterView<?> $noName_0, View $noName_1, int position, long $noName_3) {
                ViewsKt.goTo(this.$this_onGroupsRetrieved, new LeakScreen(((LeakTable.AllLeaksProjection)this.$projections.get(position)).getSignature(), null, 2, null));
            }
            {
                this.$this_onGroupsRetrieved = view;
                this.$projections = list;
            }
        });
        ViewsKt.restoreViewStateFromTag($this$onGroupsRetrieved);
    }

    public static final /* synthetic */ void access$onGroupsRetrieved(LeaksScreen $this, View $this$access_u24onGroupsRetrieved, List projections) {
        $this.onGroupsRetrieved($this$access_u24onGroupsRetrieved, projections);
    }
}

