/*
 * Decompiled with CFR 0.152.
 */
package leakcanary.internal.activity.screen;

import android.app.ActivityManager;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.text.Html;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.method.LinkMovementMethod;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.squareup.leakcanary.core.R;
import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import leakcanary.EventListener;
import leakcanary.internal.InternalLeakCanary;
import leakcanary.internal.Serializables;
import leakcanary.internal.activity.LeakViewsKt;
import leakcanary.internal.activity.db.Db;
import leakcanary.internal.activity.db.DbKt;
import leakcanary.internal.activity.db.HeapAnalysisTable;
import leakcanary.internal.activity.screen.HeapAnalysisFailureScreen;
import leakcanary.internal.activity.screen.HeapAnalysisFailureScreen$createView$;
import leakcanary.internal.activity.ui.UiUtils;
import leakcanary.internal.navigation.Screen;
import leakcanary.internal.navigation.ViewsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import shark.HeapAnalysis;
import shark.HeapAnalysisFailure;
import shark.SharkLog;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001c\u0010\t\u001a\u00020\n*\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lleakcanary/internal/activity/screen/HeapAnalysisFailureScreen;", "Lleakcanary/internal/navigation/Screen;", "analysisId", "", "(J)V", "createView", "Landroid/view/View;", "container", "Landroid/view/ViewGroup;", "onFailureRetrieved", "", "heapAnalysis", "Lshark/HeapAnalysisFailure;", "heapDumpFileExist", "", "leakcanary-android-core_release"})
public final class HeapAnalysisFailureScreen
extends Screen {
    private final long analysisId;

    @Override
    @NotNull
    public View createView(@NotNull ViewGroup container) {
        Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
        View view = ViewsKt.inflate(container, R.layout.leak_canary_heap_analysis_failure_screen);
        boolean bl = false;
        boolean bl2 = false;
        View $this$apply = view;
        boolean bl3 = false;
        ViewsKt.getActivity($this$apply).setTitle((CharSequence)$this$apply.getResources().getString(R.string.leak_canary_loading_title));
        DbKt.executeOnDb($this$apply, (Function1<? super Db.OnDb, Unit>)((Function1)new Function1<Db.OnDb, Unit>(this){
            final /* synthetic */ HeapAnalysisFailureScreen this$0;
            {
                this.this$0 = heapAnalysisFailureScreen;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final void invoke(@NotNull Db.OnDb $this$executeOnDb) {
                HeapAnalysis heapAnalysis;
                void db$iv;
                Intrinsics.checkParameterIsNotNull((Object)$this$executeOnDb, (String)"$receiver");
                HeapAnalysisTable heapAnalysisTable = HeapAnalysisTable.INSTANCE;
                SQLiteDatabase sQLiteDatabase = $this$executeOnDb.getDb();
                long id$iv = HeapAnalysisFailureScreen.access$getAnalysisId$p(this.this$0);
                boolean $i$f$retrieve = false;
                Cursor cursor = db$iv.rawQuery("\n              SELECT\n              object\n              FROM heap_analysis\n              WHERE id=" + id$iv + "\n              ", null);
                Intrinsics.checkExpressionValueIsNotNull((Object)cursor, (String)"db.rawQuery(\n      \"\"\"\n \u2026          \"\"\", null\n    )");
                Cursor $this$use$iv$iv = cursor;
                boolean $i$f$use = false;
                Throwable exception$iv$iv = null;
                try {
                    HeapAnalysis heapAnalysis2;
                    Cursor cursor$iv = $this$use$iv$iv;
                    boolean bl = false;
                    if (cursor$iv.moveToNext()) {
                        HeapAnalysisFailure heapAnalysisFailure;
                        Serializables serializables = Serializables.INSTANCE;
                        byte[] byArray = cursor$iv.getBlob(0);
                        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"cursor.getBlob(0)");
                        byte[] byteArray$iv$iv = byArray;
                        boolean $i$f$fromByteArray = false;
                        ByteArrayInputStream inputStream$iv$iv = new ByteArrayInputStream(byteArray$iv$iv);
                        try {
                            Object object = new ObjectInputStream(inputStream$iv$iv).readObject();
                            if (!(object instanceof HeapAnalysisFailure)) {
                                object = null;
                            }
                            heapAnalysisFailure = (HeapAnalysisFailure)object;
                        }
                        catch (Throwable ignored$iv$iv) {
                            SharkLog this_$iv$iv$iv = SharkLog.INSTANCE;
                            boolean $i$f$d = false;
                            SharkLog.Logger logger = this_$iv$iv$iv.getLogger();
                            if (logger != null) {
                                SharkLog.Logger logger$iv$iv$iv = logger;
                                Throwable throwable = ignored$iv$iv;
                                SharkLog.Logger logger2 = logger$iv$iv$iv;
                                boolean bl2 = false;
                                String string2 = "Could not deserialize bytes, ignoring";
                                logger2.d(throwable, string2);
                            }
                            heapAnalysisFailure = null;
                        }
                        HeapAnalysis analysis$iv = (HeapAnalysis)heapAnalysisFailure;
                        if (analysis$iv == null) {
                            HeapAnalysisTable.INSTANCE.delete((SQLiteDatabase)db$iv, id$iv, null);
                        }
                        heapAnalysis2 = analysis$iv;
                    } else {
                        heapAnalysis2 = null;
                    }
                    heapAnalysis = heapAnalysis2;
                    Throwable throwable = exception$iv$iv;
                }
                catch (Throwable e$iv$iv) {
                    try {
                        exception$iv$iv = e$iv$iv;
                        throw e$iv$iv;
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = exception$iv$iv;
                        if (throwable2 == null) {
                            $this$use$iv$iv.close();
                        } else {
                            try {
                                $this$use$iv$iv.close();
                            }
                            catch (Throwable throwable3) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                }
                $this$use$iv$iv.close();
                HeapAnalysisFailure heapAnalysis3 = (HeapAnalysisFailure)heapAnalysis;
                if (heapAnalysis3 == null) {
                    $this$executeOnDb.updateUi((Function1<? super View, Unit>)((Function1)createView.1.1.INSTANCE));
                } else {
                    boolean heapDumpFileExist = heapAnalysis3.getHeapDumpFile().exists();
                    $this$executeOnDb.updateUi((Function1<? super View, Unit>)((Function1)new Function1<View, Unit>(this, heapAnalysis3, heapDumpFileExist){
                        final /* synthetic */ createView$$inlined$apply$lambda$1 this$0;
                        final /* synthetic */ HeapAnalysisFailure $heapAnalysis;
                        final /* synthetic */ boolean $heapDumpFileExist;
                        {
                            this.this$0 = var1_1;
                            this.$heapAnalysis = heapAnalysisFailure;
                            this.$heapDumpFileExist = bl;
                            super(1);
                        }

                        public final void invoke(@NotNull View $this$updateUi) {
                            Intrinsics.checkParameterIsNotNull((Object)$this$updateUi, (String)"$receiver");
                            HeapAnalysisFailureScreen.access$onFailureRetrieved(this.this$0.this$0, $this$updateUi, this.$heapAnalysis, this.$heapDumpFileExist);
                        }
                    }));
                }
            }
        }));
        return view;
    }

    private final void onFailureRetrieved(View $this$onFailureRetrieved, HeapAnalysisFailure heapAnalysis, boolean heapDumpFileExist) {
        ViewsKt.getActivity($this$onFailureRetrieved).setTitle((CharSequence)$this$onFailureRetrieved.getResources().getString(R.string.leak_canary_analysis_failed));
        String failureText = (heapDumpFileExist ? "You can <a href=\"try_again\">run the analysis again</a>.<br><br>" : "") + "\n      Please <a href=\"file_issue\">click here</a> to file a bug report.\n      The stacktrace details will be copied into the clipboard and you just need to paste into the\n      GitHub issue description." + (heapDumpFileExist ? "\n        <br><br>To help reproduce the issue, please share the\n        <a href=\"share_hprof\">Heap Dump file</a> and upload it to the GitHub issue.\n      " : "");
        Spanned spanned = Html.fromHtml((String)failureText);
        if (spanned == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.text.SpannableStringBuilder");
        }
        SpannableStringBuilder failure = (SpannableStringBuilder)spanned;
        UiUtils.INSTANCE.replaceUrlSpanWithAction$leakcanary_android_core_release(failure, (Function1<? super String, ? extends Function0<Unit>>)((Function1)new Function1<String, Function0<? extends Unit>>($this$onFailureRetrieved, heapAnalysis){
            final /* synthetic */ View $this_onFailureRetrieved;
            final /* synthetic */ HeapAnalysisFailure $heapAnalysis;

            @Nullable
            public final Function0<Unit> invoke(@NotNull String urlSpan) {
                Function0 function0;
                Intrinsics.checkParameterIsNotNull((Object)urlSpan, (String)"urlSpan");
                switch (urlSpan) {
                    case "file_issue": {
                        function0 = (Function0)new Function0<Unit>(this){
                            final /* synthetic */ onFailureRetrieved.1 this$0;

                            public final void invoke() {
                                LeakViewsKt.shareToGitHubIssue(this.this$0.$this_onFailureRetrieved, this.this$0.$heapAnalysis);
                            }
                            {
                                this.this$0 = var1_1;
                                super(0);
                            }
                        };
                        break;
                    }
                    case "share_hprof": {
                        function0 = (Function0)new Function0<Unit>(this){
                            final /* synthetic */ onFailureRetrieved.1 this$0;

                            public final void invoke() {
                                LeakViewsKt.shareHeapDump(this.this$0.$this_onFailureRetrieved, this.this$0.$heapAnalysis.getHeapDumpFile());
                            }
                            {
                                this.this$0 = var1_1;
                                super(0);
                            }
                        };
                        break;
                    }
                    case "try_again": {
                        function0 = (Function0)new Function0<Unit>(this){
                            final /* synthetic */ onFailureRetrieved.1 this$0;

                            public final void invoke() {
                                String string2 = UUID.randomUUID().toString();
                                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"UUID.randomUUID().toString()");
                                InternalLeakCanary.INSTANCE.sendEvent(new EventListener.Event.HeapDump(string2, this.this$0.$heapAnalysis.getHeapDumpFile(), this.this$0.$heapAnalysis.getDumpDurationMillis(), "Retrying heap analysis after failure."));
                            }
                            {
                                this.this$0 = var1_1;
                                super(0);
                            }
                        };
                        break;
                    }
                    default: {
                        function0 = null;
                    }
                }
                return function0;
            }
            {
                this.$this_onFailureRetrieved = view;
                this.$heapAnalysis = heapAnalysisFailure;
                super(1);
            }
        }));
        View view = $this$onFailureRetrieved.findViewById(R.id.leak_canary_header_text);
        boolean bl = false;
        boolean bl2 = false;
        TextView $this$apply = (TextView)view;
        boolean bl3 = false;
        $this$apply.setMovementMethod(LinkMovementMethod.getInstance());
        $this$apply.setText((CharSequence)failure);
        View view2 = $this$onFailureRetrieved.findViewById(R.id.leak_canary_stacktrace);
        Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"findViewById<TextView>(R\u2026d.leak_canary_stacktrace)");
        ((TextView)view2).setText((CharSequence)heapAnalysis.getException().toString());
        ViewsKt.onCreateOptionsMenu($this$onFailureRetrieved, (Function1<? super Menu, Unit>)((Function1)new Function1<Menu, Unit>(this, $this$onFailureRetrieved, heapAnalysis){
            final /* synthetic */ HeapAnalysisFailureScreen this$0;
            final /* synthetic */ View $this_onFailureRetrieved;
            final /* synthetic */ HeapAnalysisFailure $heapAnalysis;

            public final void invoke(@NotNull Menu menu) {
                Intrinsics.checkParameterIsNotNull((Object)menu, (String)"menu");
                if (!ActivityManager.isUserAMonkey()) {
                    menu.add(R.string.leak_canary_delete).setOnMenuItemClickListener(new MenuItem.OnMenuItemClickListener(this){
                        final /* synthetic */ onFailureRetrieved.3 this$0;

                        public final boolean onMenuItemClick(@NotNull MenuItem it) {
                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                            DbKt.executeOnDb(this.this$0.$this_onFailureRetrieved, (Function1<? super Db.OnDb, Unit>)((Function1)new Function1<Db.OnDb, Unit>(this){
                                final /* synthetic */ onFailureRetrieved.1 this$0;

                                public final void invoke(@NotNull Db.OnDb $this$executeOnDb) {
                                    Intrinsics.checkParameterIsNotNull((Object)$this$executeOnDb, (String)"$receiver");
                                    HeapAnalysisTable.INSTANCE.delete($this$executeOnDb.getDb(), HeapAnalysisFailureScreen.access$getAnalysisId$p(this.this$0.this$0.this$0), this.this$0.this$0.$heapAnalysis.getHeapDumpFile());
                                    $this$executeOnDb.updateUi((Function1<? super View, Unit>)((Function1)onFailureRetrieved.1.INSTANCE));
                                }
                                {
                                    this.this$0 = var1_1;
                                    super(1);
                                }
                            }));
                            return true;
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                }
            }
            {
                this.this$0 = heapAnalysisFailureScreen;
                this.$this_onFailureRetrieved = view;
                this.$heapAnalysis = heapAnalysisFailure;
                super(1);
            }
        }));
    }

    public HeapAnalysisFailureScreen(long analysisId) {
        this.analysisId = analysisId;
    }

    public static final /* synthetic */ long access$getAnalysisId$p(HeapAnalysisFailureScreen $this) {
        return $this.analysisId;
    }

    public static final /* synthetic */ void access$onFailureRetrieved(HeapAnalysisFailureScreen $this, View $this$access_u24onFailureRetrieved, HeapAnalysisFailure heapAnalysis, boolean heapDumpFileExist) {
        $this.onFailureRetrieved($this$access_u24onFailureRetrieved, heapAnalysis, heapDumpFileExist);
    }
}

