/*
 * Decompiled with CFR 0.152.
 */
package leakcanary.internal;

import android.app.Application;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.os.Build;
import com.squareup.leakcanary.core.R;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import leakcanary.LeakCanary;
import leakcanary.internal.InternalLeakCanary;
import leakcanary.internal.NotificationType;
import leakcanary.internal.RequestPermissionActivity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import shark.SharkLog;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ8\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\u000fR\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lleakcanary/internal/Notifications;", "", "()V", "canShowNotification", "", "getCanShowNotification", "()Z", "notificationPermissionRequested", "buildNotification", "Landroid/app/Notification;", "context", "Landroid/content/Context;", "builder", "Landroid/app/Notification$Builder;", "type", "Lleakcanary/internal/NotificationType;", "showNotification", "", "contentTitle", "", "contentText", "pendingIntent", "Landroid/app/PendingIntent;", "notificationId", "", "leakcanary-android-core_release"})
public final class Notifications {
    private static boolean notificationPermissionRequested;
    @NotNull
    public static final Notifications INSTANCE;

    public final boolean getCanShowNotification() {
        if (InternalLeakCanary.INSTANCE.getFormFactor() != InternalLeakCanary.FormFactor.MOBILE) {
            return false;
        }
        if (InternalLeakCanary.INSTANCE.isInstantApp() || !InternalLeakCanary.INSTANCE.getApplicationVisible()) {
            return false;
        }
        if (!LeakCanary.getConfig().getShowNotifications()) {
            return false;
        }
        if (Build.VERSION.SDK_INT >= 33) {
            Application application = InternalLeakCanary.INSTANCE.getApplication();
            if (application.getApplicationInfo().targetSdkVersion >= 33) {
                Object object = application.getSystemService("notification");
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type android.app.NotificationManager");
                }
                NotificationManager notificationManager = (NotificationManager)object;
                if (!notificationManager.areNotificationsEnabled()) {
                    if (notificationPermissionRequested) {
                        SharkLog this_$iv = SharkLog.INSTANCE;
                        boolean $i$f$d = false;
                        SharkLog.Logger logger = this_$iv.getLogger();
                        if (logger == null) {
                        } else {
                            SharkLog.Logger logger$iv;
                            SharkLog.Logger logger2 = logger$iv = logger;
                            boolean bl = false;
                            String string2 = "Not showing notification: already requested missing POST_NOTIFICATIONS permission.";
                            logger2.d(string2);
                        }
                    } else {
                        SharkLog this_$iv = SharkLog.INSTANCE;
                        boolean $i$f$d = false;
                        SharkLog.Logger logger = this_$iv.getLogger();
                        if (logger == null) {
                        } else {
                            SharkLog.Logger logger$iv;
                            SharkLog.Logger logger3 = logger$iv = logger;
                            boolean bl = false;
                            String string3 = "Not showing notification: requesting missing POST_NOTIFICATIONS permission.";
                            logger3.d(string3);
                        }
                        application.startActivity(RequestPermissionActivity.Companion.createIntent((Context)application, "android.permission.POST_NOTIFICATIONS"));
                        notificationPermissionRequested = true;
                    }
                    return false;
                }
                if (notificationManager.areNotificationsPaused()) {
                    SharkLog this_$iv = SharkLog.INSTANCE;
                    boolean $i$f$d = false;
                    SharkLog.Logger logger = this_$iv.getLogger();
                    if (logger == null) {
                    } else {
                        SharkLog.Logger logger$iv;
                        SharkLog.Logger logger4 = logger$iv = logger;
                        boolean bl = false;
                        String string4 = "Not showing notification, notifications are paused.";
                        logger4.d(string4);
                    }
                    return false;
                }
            }
        }
        return true;
    }

    public final void showNotification(@NotNull Context context, @NotNull CharSequence contentTitle, @NotNull CharSequence contentText, @Nullable PendingIntent pendingIntent, int notificationId, @NotNull NotificationType type) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)contentTitle, (String)"contentTitle");
        Intrinsics.checkParameterIsNotNull((Object)contentText, (String)"contentText");
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        if (!this.getCanShowNotification()) {
            return;
        }
        Notification.Builder builder = Build.VERSION.SDK_INT >= 26 ? new Notification.Builder(context, type.name()) : new Notification.Builder(context);
        builder.setContentText(contentText).setContentTitle(contentTitle).setAutoCancel(true).setContentIntent(pendingIntent);
        Notification notification = this.buildNotification(context, builder, type);
        Object object = context.getSystemService("notification");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.app.NotificationManager");
        }
        NotificationManager notificationManager = (NotificationManager)object;
        notificationManager.notify(notificationId, notification);
    }

    @NotNull
    public final Notification buildNotification(@NotNull Context context, @NotNull Notification.Builder builder, @NotNull NotificationType type) {
        Notification notification;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        builder.setSmallIcon(R.drawable.leak_canary_leak).setWhen(System.currentTimeMillis());
        if (Build.VERSION.SDK_INT >= 26) {
            Object object = context.getSystemService("notification");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.app.NotificationManager");
            }
            NotificationManager notificationManager = (NotificationManager)object;
            NotificationChannel notificationChannel = notificationManager.getNotificationChannel(type.name());
            if (notificationChannel == null) {
                String string2 = context.getString(type.getNameResId());
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"context.getString(type.nameResId)");
                String channelName = string2;
                notificationChannel = new NotificationChannel(type.name(), (CharSequence)channelName, type.getImportance());
                notificationManager.createNotificationChannel(notificationChannel);
            }
            builder.setChannelId(type.name());
            builder.setGroup(type.name());
        }
        if (Build.VERSION.SDK_INT < 16) {
            Notification notification2 = builder.getNotification();
            notification = notification2;
            Intrinsics.checkExpressionValueIsNotNull((Object)notification2, (String)"builder.notification");
        } else {
            Notification notification3 = builder.build();
            notification = notification3;
            Intrinsics.checkExpressionValueIsNotNull((Object)notification3, (String)"builder.build()");
        }
        return notification;
    }

    private Notifications() {
    }

    static {
        Notifications notifications;
        INSTANCE = notifications = new Notifications();
    }
}

