/*
 * Decompiled with CFR 0.152.
 */
package leakcanary.internal.activity;

import android.annotation.SuppressLint;
import android.content.ActivityNotFoundException;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Parcelable;
import android.view.View;
import android.widget.Toast;
import com.squareup.leakcanary.core.R;
import java.io.File;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import leakcanary.internal.LeakCanaryFileProvider;
import leakcanary.internal.activity.LeakViewsKt;
import leakcanary.internal.navigation.ViewsKt;
import org.jetbrains.annotations.NotNull;
import shark.HeapAnalysisFailure;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0001H\u0000\u001a\u0014\u0010\u0007\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0001\u001a\u0014\u0010\n\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a\u0014\u0010\r\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0001H\u0000\u001a\u0014\u0010\u000e\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"NEW_ISSUE_URL", "", "STACKOVERFLOW_QUESTION_URL", "share", "", "Landroid/view/View;", "content", "shareHeapDump", "heapDumpFile", "Ljava/io/File;", "shareToGitHubIssue", "failure", "Lshark/HeapAnalysisFailure;", "shareToStackOverflow", "startShareIntentChooser", "uri", "Landroid/net/Uri;", "leakcanary-android-core_release"})
public final class LeakViewsKt {
    private static final String STACKOVERFLOW_QUESTION_URL = "http://stackoverflow.com/questions/ask?guided=false&tags=leakcanary";
    private static final String NEW_ISSUE_URL = "https://github.com/square/leakcanary/issues/new?labels=type%3A+bug&template=2-bug.md";

    public static final void share(@NotNull View $this$share, @NotNull String content) {
        Intrinsics.checkParameterIsNotNull((Object)$this$share, (String)"$this$share");
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        Intent intent = new Intent("android.intent.action.SEND");
        intent.setType("text/plain");
        intent.putExtra("android.intent.extra.TEXT", content);
        ViewsKt.getActivity($this$share).startActivity(Intent.createChooser((Intent)intent, (CharSequence)$this$share.getResources().getString(R.string.leak_canary_share_with)));
    }

    @SuppressLint(value={"SetWorldReadable"})
    public static final void shareHeapDump(@NotNull View $this$shareHeapDump, @NotNull File heapDumpFile) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shareHeapDump, (String)"$this$shareHeapDump");
        Intrinsics.checkParameterIsNotNull((Object)heapDumpFile, (String)"heapDumpFile");
        AsyncTask.SERIAL_EXECUTOR.execute(new Runnable($this$shareHeapDump, heapDumpFile){
            final /* synthetic */ View $this_shareHeapDump;
            final /* synthetic */ File $heapDumpFile;

            public final void run() {
                this.$heapDumpFile.setReadable(true, false);
                Uri heapDumpUri = LeakCanaryFileProvider.Companion.getUriForFile((Context)ViewsKt.getActivity(this.$this_shareHeapDump), "com.squareup.leakcanary.fileprovider." + ViewsKt.getActivity(this.$this_shareHeapDump).getPackageName(), this.$heapDumpFile);
                ViewsKt.getActivity(this.$this_shareHeapDump).runOnUiThread(new Runnable(this, heapDumpUri){
                    final /* synthetic */ shareHeapDump.1 this$0;
                    final /* synthetic */ Uri $heapDumpUri;

                    public final void run() {
                        LeakViewsKt.access$startShareIntentChooser(this.this$0.$this_shareHeapDump, this.$heapDumpUri);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$heapDumpUri = uri;
                    }
                });
            }
            {
                this.$this_shareHeapDump = view;
                this.$heapDumpFile = file;
            }
        });
    }

    private static final void startShareIntentChooser(View $this$startShareIntentChooser, Uri uri) {
        Intent intent = new Intent("android.intent.action.SEND");
        intent.setType("application/octet-stream");
        intent.putExtra("android.intent.extra.STREAM", (Parcelable)uri);
        ViewsKt.getActivity($this$startShareIntentChooser).startActivity(Intent.createChooser((Intent)intent, (CharSequence)$this$startShareIntentChooser.getResources().getString(R.string.leak_canary_share_with)));
    }

    public static final void shareToStackOverflow(@NotNull View $this$shareToStackOverflow, @NotNull String content) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shareToStackOverflow, (String)"$this$shareToStackOverflow");
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        Object object = $this$shareToStackOverflow.getContext().getSystemService("clipboard");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.content.ClipboardManager");
        }
        ClipboardManager clipboard = (ClipboardManager)object;
        AsyncTask.execute((Runnable)new Runnable($this$shareToStackOverflow, clipboard, content){
            final /* synthetic */ View $this_shareToStackOverflow;
            final /* synthetic */ ClipboardManager $clipboard;
            final /* synthetic */ String $content;

            public final void run() {
                this.$clipboard.setPrimaryClip(ClipData.newPlainText((CharSequence)this.$this_shareToStackOverflow.getContext().getString(R.string.leak_canary_leak_clipdata_label), (CharSequence)("```\n" + this.$content + "```")));
            }
            {
                this.$this_shareToStackOverflow = view;
                this.$clipboard = clipboardManager;
                this.$content = string2;
            }
        });
        Toast.makeText((Context)$this$shareToStackOverflow.getContext(), (int)R.string.leak_canary_leak_copied, (int)1).show();
        Intent browserIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)STACKOVERFLOW_QUESTION_URL));
        try {
            ViewsKt.getActivity($this$shareToStackOverflow).startActivity(browserIntent);
        }
        catch (ActivityNotFoundException e) {
            Toast.makeText((Context)$this$shareToStackOverflow.getContext(), (int)R.string.leak_canary_leak_missing_browser_error, (int)1).show();
        }
    }

    public static final void shareToGitHubIssue(@NotNull View $this$shareToGitHubIssue, @NotNull HeapAnalysisFailure failure) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shareToGitHubIssue, (String)"$this$shareToGitHubIssue");
        Intrinsics.checkParameterIsNotNull((Object)failure, (String)"failure");
        Object object = $this$shareToGitHubIssue.getContext().getSystemService("clipboard");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.content.ClipboardManager");
        }
        ClipboardManager clipboard = (ClipboardManager)object;
        AsyncTask.execute((Runnable)new Runnable($this$shareToGitHubIssue, clipboard, failure){
            final /* synthetic */ View $this_shareToGitHubIssue;
            final /* synthetic */ ClipboardManager $clipboard;
            final /* synthetic */ HeapAnalysisFailure $failure;

            public final void run() {
                this.$clipboard.setPrimaryClip(ClipData.newPlainText((CharSequence)this.$this_shareToGitHubIssue.getContext().getString(R.string.leak_canary_failure_clipdata_label), (CharSequence)StringsKt.trimMargin$default((String)("```\n          |" + this.$failure.getException() + "\n          |Build.VERSION.SDK_INT: " + Build.VERSION.SDK_INT + "\n          |Build.MANUFACTURER: " + Build.MANUFACTURER + "\n          |LeakCanary version: 2.12\n          |Analysis duration: " + this.$failure.getAnalysisDurationMillis() + " ms\n          |Heap dump file path: " + this.$failure.getHeapDumpFile().getAbsolutePath() + "\n          |Heap dump timestamp: " + this.$failure.getCreatedAtTimeMillis() + "\n          |```\n        "), null, (int)1, null)));
            }
            {
                this.$this_shareToGitHubIssue = view;
                this.$clipboard = clipboardManager;
                this.$failure = heapAnalysisFailure;
            }
        });
        Toast.makeText((Context)$this$shareToGitHubIssue.getContext(), (int)R.string.leak_canary_failure_copied, (int)1).show();
        Intent browserIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)NEW_ISSUE_URL));
        try {
            ViewsKt.getActivity($this$shareToGitHubIssue).startActivity(browserIntent);
        }
        catch (ActivityNotFoundException e) {
            Toast.makeText((Context)$this$shareToGitHubIssue.getContext(), (int)R.string.leak_canary_leak_missing_browser_error, (int)1).show();
        }
    }

    public static final /* synthetic */ void access$startShareIntentChooser(View $this$access_u24startShareIntentChooser, Uri uri) {
        LeakViewsKt.startShareIntentChooser($this$access_u24startShareIntentChooser, uri);
    }
}

