/*
 * Decompiled with CFR 0.152.
 */
package leakcanary.internal.activity.screen;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.Parcelable;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.ImageView;
import android.widget.Toast;
import com.squareup.leakcanary.core.R;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import leakcanary.internal.InternalLeakCanary;
import leakcanary.internal.LeakCanaryFileProvider;
import leakcanary.internal.LeakDirectoryProvider;
import leakcanary.internal.activity.db.Io;
import leakcanary.internal.activity.db.IoKt;
import leakcanary.internal.activity.screen.HeapDumpRenderer;
import leakcanary.internal.activity.screen.RenderHeapDumpScreen;
import leakcanary.internal.activity.screen.RenderHeapDumpScreen$createView$;
import leakcanary.internal.navigation.Screen;
import leakcanary.internal.navigation.ViewsKt;
import leakcanary.internal.utils.SizeKt;
import org.jetbrains.annotations.NotNull;
import shark.SharkLog;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lleakcanary/internal/activity/screen/RenderHeapDumpScreen;", "Lleakcanary/internal/navigation/Screen;", "heapDumpFile", "Ljava/io/File;", "(Ljava/io/File;)V", "createView", "Landroid/view/View;", "container", "Landroid/view/ViewGroup;", "savePng", "", "imageFile", "source", "Landroid/graphics/Bitmap;", "leakcanary-android-core_release"})
public final class RenderHeapDumpScreen
extends Screen {
    private final File heapDumpFile;

    @Override
    @NotNull
    public View createView(@NotNull ViewGroup container) {
        Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
        View view = ViewsKt.inflate(container, R.layout.leak_canary_heap_render);
        boolean bl = false;
        boolean bl2 = false;
        View $this$apply = view;
        boolean bl3 = false;
        ViewsKt.getActivity((View)container).setTitle((CharSequence)$this$apply.getResources().getString(R.string.leak_canary_loading_title));
        IoKt.executeOnIo($this$apply, (Function1<? super Io.OnIo, Unit>)((Function1)new Function1<Io.OnIo, Unit>(this, container){
            final /* synthetic */ RenderHeapDumpScreen this$0;
            final /* synthetic */ ViewGroup $container$inlined;
            {
                this.this$0 = renderHeapDumpScreen;
                this.$container$inlined = viewGroup;
                super(1);
            }

            public final void invoke(@NotNull Io.OnIo $this$executeOnIo) {
                Intrinsics.checkParameterIsNotNull((Object)$this$executeOnIo, (String)"$receiver");
                String byteCount = SizeKt.humanReadableByteCount(RenderHeapDumpScreen.access$getHeapDumpFile$p(this.this$0).length(), true);
                $this$executeOnIo.updateUi((Function1<? super View, Unit>)((Function1)new Function1<View, Unit>(this, byteCount){
                    final /* synthetic */ createView$$inlined$apply$lambda$1 this$0;
                    final /* synthetic */ String $byteCount;
                    {
                        this.this$0 = var1_1;
                        this.$byteCount = string2;
                        super(1);
                    }

                    public final void invoke(@NotNull View $this$updateUi) {
                        Intrinsics.checkParameterIsNotNull((Object)$this$updateUi, (String)"$receiver");
                        ViewsKt.getActivity((View)this.this$0.$container$inlined).setTitle((CharSequence)$this$updateUi.getResources().getString(R.string.leak_canary_heap_dump_screen_title, new Object[]{this.$byteCount}));
                    }
                }));
            }
        }));
        View loadingView = $this$apply.findViewById(R.id.leak_canary_loading);
        ImageView imageView = (ImageView)$this$apply.findViewById(R.id.leak_canary_heap_rendering);
        $this$apply.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener($this$apply, imageView, loadingView, this, container){
            final /* synthetic */ View $this_apply;
            final /* synthetic */ ImageView $imageView;
            final /* synthetic */ View $loadingView;
            final /* synthetic */ RenderHeapDumpScreen this$0;
            final /* synthetic */ ViewGroup $container$inlined;
            {
                this.$this_apply = $receiver;
                this.$imageView = $captured_local_variable$2;
                this.$loadingView = $captured_local_variable$3;
                this.this$0 = renderHeapDumpScreen;
                this.$container$inlined = viewGroup;
            }

            public void onGlobalLayout() {
                IoKt.executeOnIo(this.$this_apply, (Function1<? super Io.OnIo, Unit>)((Function1)new Function1<Io.OnIo, Unit>(this){
                    final /* synthetic */ createView$$inlined$apply$lambda$2 this$0;
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }

                    public final void invoke(@NotNull Io.OnIo $this$executeOnIo) {
                        Intrinsics.checkParameterIsNotNull((Object)$this$executeOnIo, (String)"$receiver");
                        Context context = this.this$0.$this_apply.getContext();
                        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
                        Bitmap bitmap = HeapDumpRenderer.INSTANCE.render(context, RenderHeapDumpScreen.access$getHeapDumpFile$p(this.this$0.this$0), this.this$0.$this_apply.getMeasuredWidth(), this.this$0.$this_apply.getMeasuredHeight(), 0);
                        $this$executeOnIo.updateUi((Function1<? super View, Unit>)((Function1)new Function1<View, Unit>(this, bitmap){
                            final /* synthetic */ createView$$inlined$apply$lambda$2$1 this$0;
                            final /* synthetic */ Bitmap $bitmap;
                            {
                                this.this$0 = var1_1;
                                this.$bitmap = bitmap;
                                super(1);
                            }

                            public final void invoke(@NotNull View $this$updateUi) {
                                Intrinsics.checkParameterIsNotNull((Object)$this$updateUi, (String)"$receiver");
                                this.this$0.this$0.$imageView.setImageBitmap(this.$bitmap);
                                View view = this.this$0.this$0.$loadingView;
                                Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"loadingView");
                                view.setVisibility(8);
                                ImageView imageView = this.this$0.this$0.$imageView;
                                Intrinsics.checkExpressionValueIsNotNull((Object)imageView, (String)"imageView");
                                imageView.setVisibility(0);
                            }
                        }));
                    }
                }));
                if (Build.VERSION.SDK_INT >= 16) {
                    this.$this_apply.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                } else {
                    this.$this_apply.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
            }
        });
        ViewsKt.onCreateOptionsMenu($this$apply, (Function1<? super Menu, Unit>)((Function1)new Function1<Menu, Unit>($this$apply, this, container){
            final /* synthetic */ View $this_apply;
            final /* synthetic */ RenderHeapDumpScreen this$0;
            final /* synthetic */ ViewGroup $container$inlined;
            {
                this.$this_apply = view;
                this.this$0 = renderHeapDumpScreen;
                this.$container$inlined = viewGroup;
                super(1);
            }

            public final void invoke(@NotNull Menu menu) {
                Intrinsics.checkParameterIsNotNull((Object)menu, (String)"menu");
                menu.add(R.string.leak_canary_options_menu_generate_hq_bitmap).setOnMenuItemClickListener(new MenuItem.OnMenuItemClickListener(this){
                    final /* synthetic */ createView$$inlined$apply$lambda$3 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final boolean onMenuItemClick(@NotNull MenuItem it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        Context context = this.this$0.$this_apply.getContext();
                        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
                        LeakDirectoryProvider leakDirectoryProvider = InternalLeakCanary.INSTANCE.createLeakDirectoryProvider(context);
                        if (!leakDirectoryProvider.hasStoragePermission()) {
                            Toast.makeText((Context)this.this$0.$this_apply.getContext(), (int)R.string.leak_canary_options_menu_permission_toast, (int)1).show();
                            leakDirectoryProvider.requestWritePermissionNotification();
                        } else {
                            Toast.makeText((Context)this.this$0.$this_apply.getContext(), (int)R.string.leak_canary_generating_hq_bitmap_toast_notice, (int)1).show();
                            IoKt.executeOnIo(this.this$0.$this_apply, (Function1<? super Io.OnIo, Unit>)((Function1)new Function1<Io.OnIo, Unit>(this){
                                final /* synthetic */ createView$$inlined$apply$lambda$3$1 this$0;
                                {
                                    this.this$0 = var1_1;
                                    super(1);
                                }

                                public final void invoke(@NotNull Io.OnIo $this$executeOnIo) {
                                    Intrinsics.checkParameterIsNotNull((Object)$this$executeOnIo, (String)"$receiver");
                                    Context context = this.this$0.this$0.$this_apply.getContext();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
                                    Bitmap bitmap = HeapDumpRenderer.INSTANCE.render(context, RenderHeapDumpScreen.access$getHeapDumpFile$p(this.this$0.this$0.this$0), 2048, 0, 4);
                                    File storageDir = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS);
                                    File imageFile = new File(storageDir, RenderHeapDumpScreen.access$getHeapDumpFile$p(this.this$0.this$0.this$0).getName() + ".png");
                                    boolean saved = this.this$0.this$0.this$0.savePng(imageFile, bitmap);
                                    if (saved) {
                                        SharkLog this_$iv = SharkLog.INSTANCE;
                                        boolean $i$f$d = false;
                                        SharkLog.Logger logger = this_$iv.getLogger();
                                        if (logger == null) {
                                        } else {
                                            SharkLog.Logger logger$iv;
                                            SharkLog.Logger logger2 = logger$iv = logger;
                                            boolean bl = false;
                                            String string2 = "Png saved at " + imageFile;
                                            logger2.d(string2);
                                        }
                                        imageFile.setReadable(true, false);
                                        Uri imageUri = LeakCanaryFileProvider.Companion.getUriForFile((Context)ViewsKt.getActivity(this.this$0.this$0.$this_apply), "com.squareup.leakcanary.fileprovider." + ViewsKt.getActivity(this.this$0.this$0.$this_apply).getPackageName(), imageFile);
                                        $this$executeOnIo.updateUi((Function1<? super View, Unit>)((Function1)new Function1<View, Unit>(imageUri){
                                            final /* synthetic */ Uri $imageUri;
                                            {
                                                this.$imageUri = uri;
                                                super(1);
                                            }

                                            public final void invoke(@NotNull View $this$updateUi) {
                                                Intrinsics.checkParameterIsNotNull((Object)$this$updateUi, (String)"$receiver");
                                                Intent intent = new Intent("android.intent.action.SEND");
                                                intent.setType("image/png");
                                                intent.putExtra("android.intent.extra.STREAM", (Parcelable)this.$imageUri);
                                                ViewsKt.getActivity($this$updateUi).startActivity(Intent.createChooser((Intent)intent, (CharSequence)$this$updateUi.getResources().getString(R.string.leak_canary_share_heap_dump_bitmap_screen_title)));
                                            }
                                        }));
                                    } else {
                                        $this$executeOnIo.updateUi((Function1<? super View, Unit>)((Function1)createView.1.3.INSTANCE));
                                    }
                                }
                            }));
                        }
                        return true;
                    }
                });
            }
        }));
        return view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean savePng(@NotNull File imageFile, @NotNull Bitmap source) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)imageFile, (String)"imageFile");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        FileOutputStream outStream = null;
        try {
            File file = imageFile;
            boolean bl2 = false;
            outStream = new FileOutputStream(file);
            source.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)outStream);
            bl = true;
            outStream.close();
        }
        catch (IOException e) {
            bl = false;
        }
        finally {
            FileOutputStream fileOutputStream = outStream;
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
        return bl;
    }

    public RenderHeapDumpScreen(@NotNull File heapDumpFile) {
        Intrinsics.checkParameterIsNotNull((Object)heapDumpFile, (String)"heapDumpFile");
        this.heapDumpFile = heapDumpFile;
    }

    public static final /* synthetic */ File access$getHeapDumpFile$p(RenderHeapDumpScreen $this) {
        return $this.heapDumpFile;
    }
}

