/*
 * Decompiled with CFR 0.152.
 */
package leakcanary.internal.activity.db;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import leakcanary.internal.Serializables;
import leakcanary.internal.SerializablesKt;
import leakcanary.internal.activity.db.CursorsKt;
import leakcanary.internal.activity.db.LeaksDbHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import shark.ApplicationLeak;
import shark.HeapAnalysis;
import shark.HeapAnalysisSuccess;
import shark.LeakTrace;
import shark.LeakTraceReference;
import shark.LibraryLeak;
import shark.SharkLog;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016J \u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010*\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002\u00a8\u0006\u0013"}, d2={"Lleakcanary/internal/activity/db/LeaksDbHelper;", "Landroid/database/sqlite/SQLiteOpenHelper;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "onCreate", "", "db", "Landroid/database/sqlite/SQLiteDatabase;", "onDowngrade", "oldVersion", "", "newVersion", "onUpgrade", "recreateDb", "fixNullReferenceOwningClassName", "", "Lshark/LeakTrace;", "Companion", "leakcanary-android-core_release"})
public final class LeaksDbHelper
extends SQLiteOpenHelper {
    public static final int VERSION = 25;
    @NotNull
    public static final String DATABASE_NAME = "leaks.db";
    @NotNull
    public static final Companion Companion = new Companion(null);

    public void onCreate(@NotNull SQLiteDatabase db) {
        Intrinsics.checkParameterIsNotNull((Object)db, (String)"db");
        db.execSQL("CREATE TABLE heap_analysis\n        (\n        id INTEGER PRIMARY KEY AUTOINCREMENT,\n        created_at_time_millis INTEGER,\n        dump_duration_millis INTEGER DEFAULT -1,\n        leak_count INTEGER DEFAULT 0,\n        exception_summary TEXT DEFAULT NULL,\n        object BLOB\n        )");
        db.execSQL("\n        CREATE TABLE leak\n        (\n        id INTEGER PRIMARY KEY,\n        signature TEXT UNIQUE,\n        short_description TEXT,\n        is_library_leak INTEGER,\n        is_read INTEGER\n        )");
        db.execSQL("\n        CREATE INDEX leak_signature\n        on leak (signature)\n    ");
        db.execSQL("\n        CREATE TABLE leak_trace\n        (\n        id INTEGER PRIMARY KEY,\n        heap_analysis_id REFERENCES heap_analysis(id),\n        leak_id REFERENCES leak(id),\n        class_simple_name TEXT,\n        leak_trace_index INTEGER\n        )");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void onUpgrade(@NotNull SQLiteDatabase db, int oldVersion, int newVersion) {
        block18: {
            Object cursor;
            Intrinsics.checkParameterIsNotNull((Object)db, (String)"db");
            if (oldVersion < 23) {
                this.recreateDb(db);
                return;
            }
            if (oldVersion < 24) {
                db.execSQL("ALTER TABLE heap_analysis ADD COLUMN dump_duration_millis INTEGER DEFAULT -1");
            }
            if (oldVersion >= 25) break block18;
            Cursor cursor2 = db.rawQuery("SELECT id, object FROM heap_analysis", null);
            Intrinsics.checkExpressionValueIsNotNull((Object)cursor2, (String)"db.rawQuery(\"SELECT id, \u2026ROM heap_analysis\", null)");
            Cursor $this$use$iv = cursor2;
            boolean $i$f$use = false;
            Object exception$iv = null;
            try {
                cursor = $this$use$iv;
                boolean $i$a$-use-LeaksDbHelper$onUpgrade$idToAnalysis$22 = false;
                cursor = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.generateSequence((Function0)((Function0)new Function0<Pair<? extends Long, ? extends HeapAnalysis>>(cursor){
                    final /* synthetic */ Cursor $cursor;

                    @Nullable
                    public final Pair<Long, HeapAnalysis> invoke() {
                        Pair pair;
                        if (this.$cursor.moveToNext()) {
                            HeapAnalysis heapAnalysis;
                            long id2 = this.$cursor.getLong(0);
                            Serializables serializables = Serializables.INSTANCE;
                            byte[] byArray = this.$cursor.getBlob(1);
                            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"cursor.getBlob(1)");
                            byte[] byteArray$iv = byArray;
                            boolean $i$f$fromByteArray = false;
                            ByteArrayInputStream inputStream$iv = new ByteArrayInputStream(byteArray$iv);
                            try {
                                Object object = new ObjectInputStream(inputStream$iv).readObject();
                                if (!(object instanceof HeapAnalysis)) {
                                    object = null;
                                }
                                heapAnalysis = (HeapAnalysis)object;
                            }
                            catch (Throwable ignored$iv) {
                                SharkLog this_$iv$iv = SharkLog.INSTANCE;
                                boolean $i$f$d = false;
                                SharkLog.Logger logger = this_$iv$iv.getLogger();
                                if (logger == null) {
                                } else {
                                    SharkLog.Logger logger$iv$iv = logger;
                                    Throwable throwable = ignored$iv;
                                    SharkLog.Logger logger2 = logger$iv$iv;
                                    boolean bl = false;
                                    String string2 = "Could not deserialize bytes, ignoring";
                                    logger2.d(throwable, string2);
                                }
                                heapAnalysis = null;
                            }
                            HeapAnalysis analysis = heapAnalysis;
                            pair = TuplesKt.to((Object)id2, (Object)analysis);
                        } else {
                            pair = null;
                        }
                        return pair;
                    }
                    {
                        this.$cursor = cursor;
                        super(0);
                    }
                })), (Function1)onUpgrade.idToAnalysis.1.2.INSTANCE), (Function1)((Function1)new Function1<Pair<? extends Long, ? extends HeapAnalysis>, Pair<? extends Long, ? extends HeapAnalysisSuccess>>(this){
                    final /* synthetic */ LeaksDbHelper this$0;
                    {
                        this.this$0 = leaksDbHelper;
                        super(1);
                    }

                    @NotNull
                    public final Pair<Long, HeapAnalysisSuccess> invoke(@NotNull Pair<Long, ? extends HeapAnalysis> pair) {
                        Object object;
                        LibraryLeak leak;
                        Collection<ApplicationLeak> collection;
                        Iterable $this$mapTo$iv$iv;
                        Iterable $this$map$iv;
                        List list;
                        Iterable<E> iterable;
                        Intrinsics.checkParameterIsNotNull(pair, (String)"pair");
                        Object object2 = pair.getSecond();
                        if (object2 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type shark.HeapAnalysisSuccess");
                        }
                        HeapAnalysisSuccess analysis = (HeapAnalysisSuccess)object2;
                        try {
                            iterable = analysis.getUnreachableObjects();
                        }
                        catch (NullPointerException ignored) {
                            iterable = CollectionsKt.emptyList();
                        }
                        if ((list = iterable) == null) {
                            list = CollectionsKt.emptyList();
                        }
                        List unreachableObjects = list;
                        iterable = analysis.getApplicationLeaks();
                        List list2 = unreachableObjects;
                        Map map = null;
                        long l = 0L;
                        long l2 = 0L;
                        long l3 = 0L;
                        File file = null;
                        HeapAnalysisSuccess heapAnalysisSuccess = analysis;
                        Object object3 = pair.getFirst();
                        boolean $i$f$map = false;
                        List list3 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            ApplicationLeak applicationLeak = (ApplicationLeak)item$iv$iv;
                            collection = destination$iv$iv;
                            boolean bl = false;
                            object = leak.copy(LeaksDbHelper.access$fixNullReferenceOwningClassName(this.this$0, leak.getLeakTraces()));
                            collection.add((ApplicationLeak)object);
                        }
                        collection = (List)destination$iv$iv;
                        $this$map$iv = analysis.getLibraryLeaks();
                        $i$f$map = false;
                        $this$mapTo$iv$iv = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            leak = (LibraryLeak)item$iv$iv;
                            object = destination$iv$iv;
                            boolean bl = false;
                            LibraryLeak libraryLeak = LibraryLeak.copy$default((LibraryLeak)leak, (List)LeaksDbHelper.access$fixNullReferenceOwningClassName(this.this$0, leak.getLeakTraces()), null, null, (int)6, null);
                            object.add(libraryLeak);
                        }
                        object = (List)destination$iv$iv;
                        iterable = object;
                        Collection<ApplicationLeak> collection2 = collection;
                        list3 = list2;
                        return TuplesKt.to((Object)object3, (Object)HeapAnalysisSuccess.copy$default((HeapAnalysisSuccess)heapAnalysisSuccess, file, (long)l3, (long)l2, (long)l, map, collection2, (List)iterable, (List)list3, (int)31, null));
                    }
                })));
                Throwable $i$a$-use-LeaksDbHelper$onUpgrade$idToAnalysis$22 = exception$iv;
            }
            catch (Throwable e$iv) {
                try {
                    exception$iv = e$iv;
                    throw e$iv;
                }
                catch (Throwable throwable) {
                    Throwable $i$a$-use-LeaksDbHelper$onUpgrade$idToAnalysis$22 = exception$iv;
                    if ($i$a$-use-LeaksDbHelper$onUpgrade$idToAnalysis$22 == null) {
                        $this$use$iv.close();
                    } else {
                        try {
                            $this$use$iv.close();
                        }
                        catch (Throwable throwable2) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
            $this$use$iv.close();
            Object idToAnalysis2 = cursor;
            SQLiteDatabase $this$inTransaction$iv = db;
            boolean $i$f$inTransaction = false;
            exception$iv = CursorsKt.access$getInTransaction$p();
            boolean bl = false;
            Object object = ((ThreadLocal)exception$iv).get();
            if (object == null) {
                boolean bl2 = false;
                Boolean bl3 = false;
                boolean bl4 = false;
                boolean bl5 = false;
                Boolean bl6 = bl3;
                boolean bl7 = false;
                ((ThreadLocal)exception$iv).set(bl6);
                object = bl3;
            }
            if (((Boolean)object).booleanValue()) {
                SQLiteDatabase $this$inTransaction = $this$inTransaction$iv;
                boolean bl8 = false;
                Iterable $this$forEach$iv = (Iterable)idToAnalysis2;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    void id2;
                    Pair $dstr$id$heapAnalysis = (Pair)element$iv;
                    boolean bl9 = false;
                    long l = ((Number)$dstr$id$heapAnalysis.component1()).longValue();
                    HeapAnalysisSuccess heapAnalysis = (HeapAnalysisSuccess)$dstr$id$heapAnalysis.component2();
                    ContentValues values = new ContentValues();
                    values.put("object", SerializablesKt.toByteArray((Serializable)heapAnalysis));
                    db.update("heap_analysis", values, "id=" + (long)id2, null);
                }
            } else {
                try {
                    CursorsKt.access$getInTransaction$p().set(true);
                    $this$inTransaction$iv.beginTransaction();
                    SQLiteDatabase $this$inTransaction = $this$inTransaction$iv;
                    boolean bl10 = false;
                    Iterable $this$forEach$iv = (Iterable)idToAnalysis2;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Pair $dstr$id$heapAnalysis = (Pair)element$iv;
                        boolean bl11 = false;
                        long id2 = ((Number)$dstr$id$heapAnalysis.component1()).longValue();
                        HeapAnalysisSuccess heapAnalysis = (HeapAnalysisSuccess)$dstr$id$heapAnalysis.component2();
                        ContentValues values = new ContentValues();
                        values.put("object", SerializablesKt.toByteArray((Serializable)heapAnalysis));
                        db.update("heap_analysis", values, "id=" + id2, null);
                    }
                    Unit result$iv = Unit.INSTANCE;
                    $this$inTransaction$iv.setTransactionSuccessful();
                    Unit unit = result$iv;
                }
                finally {
                    $this$inTransaction$iv.endTransaction();
                    CursorsKt.access$getInTransaction$p().set(false);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<LeakTrace> fixNullReferenceOwningClassName(List<LeakTrace> $this$fixNullReferenceOwningClassName) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$fixNullReferenceOwningClassName;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Collection<void> collection;
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            void leakTrace;
            LeakTrace leakTrace2 = (LeakTrace)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            Iterable iterable2 = leakTrace.getReferencePath();
            LeakTrace.GcRootType gcRootType = null;
            void var13_13 = leakTrace;
            boolean $i$f$map2 = false;
            void var15_15 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                String string2;
                void reference;
                LeakTraceReference leakTraceReference = (LeakTraceReference)item$iv$iv2;
                collection = destination$iv$iv2;
                boolean bl2 = false;
                try {
                    string2 = reference.getOwningClassName();
                }
                catch (NullPointerException ignored) {
                    string2 = null;
                }
                String owningClassName = string2;
                void var26_26 = owningClassName == null ? LeakTraceReference.copy$default((LeakTraceReference)reference, null, null, (String)reference.getOriginObject().getClassSimpleName(), null, (int)11, null) : reference;
                collection.add(var26_26);
            }
            collection = (List)destination$iv$iv2;
            LeakTrace leakTrace3 = LeakTrace.copy$default((LeakTrace)var13_13, gcRootType, (List)collection, null, (int)5, null);
            collection2.add(leakTrace3);
        }
        return (List)destination$iv$iv;
    }

    public void onDowngrade(@NotNull SQLiteDatabase db, int oldVersion, int newVersion) {
        Intrinsics.checkParameterIsNotNull((Object)db, (String)"db");
        this.recreateDb(db);
    }

    private final void recreateDb(SQLiteDatabase db) {
        db.execSQL("DROP TABLE IF EXISTS heap_analysis");
        db.execSQL("DROP TABLE IF EXISTS leak");
        db.execSQL("DROP TABLE IF EXISTS leak_trace");
        this.onCreate(db);
    }

    public LeaksDbHelper(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, DATABASE_NAME, null, 25);
    }

    public static final /* synthetic */ List access$fixNullReferenceOwningClassName(LeaksDbHelper $this, List $this$access_u24fixNullReferenceOwningClassName) {
        return $this.fixNullReferenceOwningClassName($this$access_u24fixNullReferenceOwningClassName);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lleakcanary/internal/activity/db/LeaksDbHelper$Companion;", "", "()V", "DATABASE_NAME", "", "VERSION", "", "leakcanary-android-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

