/*
 * Decompiled with CFR 0.152.
 */
package leakcanary.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.widget.Toast;
import com.squareup.leakcanary.core.R;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\b\u0001\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\u000b\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0014J+\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lleakcanary/internal/RequestPermissionActivity;", "Landroid/app/Activity;", "()V", "targetPermission", "", "getTargetPermission", "()Ljava/lang/String;", "finish", "", "hasTargetPermission", "", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onRequestPermissionsResult", "requestCode", "", "permissions", "", "grantResults", "", "(I[Ljava/lang/String;[I)V", "Companion", "leakcanary-android-core_release"})
@TargetApi(value=23)
public final class RequestPermissionActivity
extends Activity {
    private static final String TARGET_PERMISSION_EXTRA = "targetPermission";
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final String getTargetPermission() {
        String string2 = this.getIntent().getStringExtra(TARGET_PERMISSION_EXTRA);
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        return string2;
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState == null) {
            if (this.hasTargetPermission()) {
                this.finish();
                return;
            }
            String[] permissions = new String[]{this.getTargetPermission()};
            this.requestPermissions(permissions, 42);
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NotNull String[] permissions, @NotNull int[] grantResults) {
        Intrinsics.checkParameterIsNotNull((Object)permissions, (String)"permissions");
        Intrinsics.checkParameterIsNotNull((Object)grantResults, (String)"grantResults");
        if (!this.hasTargetPermission()) {
            Toast.makeText((Context)((Context)this.getApplication()), (int)R.string.leak_canary_permission_not_granted, (int)1).show();
        }
        this.finish();
    }

    public void finish() {
        this.overridePendingTransition(0, 0);
        super.finish();
    }

    private final boolean hasTargetPermission() {
        return this.checkSelfPermission(this.getTargetPermission()) == 0;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lleakcanary/internal/RequestPermissionActivity$Companion;", "", "()V", "TARGET_PERMISSION_EXTRA", "", "createIntent", "Landroid/content/Intent;", "context", "Landroid/content/Context;", "permission", "createPendingIntent", "Landroid/app/PendingIntent;", "leakcanary-android-core_release"})
    public static final class Companion {
        @NotNull
        public final Intent createIntent(@NotNull Context context, @NotNull String permission) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)permission, (String)"permission");
            Intent intent = new Intent(context, RequestPermissionActivity.class);
            boolean bl = false;
            boolean bl2 = false;
            Intent $this$apply = intent;
            boolean bl3 = false;
            $this$apply.setFlags(0x14000000);
            $this$apply.putExtra(RequestPermissionActivity.TARGET_PERMISSION_EXTRA, permission);
            return intent;
        }

        @NotNull
        public final PendingIntent createPendingIntent(@NotNull Context context, @NotNull String permission) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)permission, (String)"permission");
            Intent intent = this.createIntent(context, permission);
            int flags = Build.VERSION.SDK_INT >= 23 ? 0xC000000 : 0x8000000;
            PendingIntent pendingIntent = PendingIntent.getActivity((Context)context, (int)1, (Intent)intent, (int)flags);
            Intrinsics.checkExpressionValueIsNotNull((Object)pendingIntent, (String)"PendingIntent.getActivit\u2026ontext, 1, intent, flags)");
            return pendingIntent;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

