/*
 * Decompiled with CFR 0.152.
 */
package leakcanary.internal;

import android.content.Context;
import androidx.work.Data;
import androidx.work.ForegroundInfo;
import androidx.work.ListenableWorker;
import androidx.work.WorkerParameters;
import androidx.work.impl.utils.futures.SettableFuture;
import androidx.work.multiprocess.RemoteListenableWorker;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import leakcanary.BackgroundThreadHeapAnalyzer;
import leakcanary.EventListener;
import leakcanary.internal.AndroidDebugHeapAnalyzer;
import leakcanary.internal.HeapAnalyzerWorker;
import leakcanary.internal.InternalLeakCanary;
import leakcanary.internal.RemoteHeapAnalyzerWorker;
import leakcanary.internal.Serializables;
import org.jetbrains.annotations.NotNull;
import shark.SharkLog;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\bH\u0016\u00a8\u0006\f"}, d2={"Lleakcanary/internal/RemoteHeapAnalyzerWorker;", "Landroidx/work/multiprocess/RemoteListenableWorker;", "appContext", "Landroid/content/Context;", "workerParams", "Landroidx/work/WorkerParameters;", "(Landroid/content/Context;Landroidx/work/WorkerParameters;)V", "getForegroundInfoAsync", "Lcom/google/common/util/concurrent/ListenableFuture;", "Landroidx/work/ForegroundInfo;", "startRemoteWork", "Landroidx/work/ListenableWorker$Result;", "leakcanary-android-core_release"})
public final class RemoteHeapAnalyzerWorker
extends RemoteListenableWorker {
    @NotNull
    public ListenableFuture<ListenableWorker.Result> startRemoteWork() {
        EventListener.Event.HeapDump heapDump;
        Data data = this.getInputData();
        Intrinsics.checkExpressionValueIsNotNull((Object)data, (String)"inputData");
        Data $this$asEvent$iv = data;
        HeapAnalyzerWorker.Companion companion = HeapAnalyzerWorker.Companion;
        boolean $i$f$asEvent = false;
        Serializables serializables = Serializables.INSTANCE;
        byte[] byArray = $this$asEvent$iv.getByteArray("EVENT_BYTES");
        if (byArray == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"getByteArray(EVENT_BYTES)!!");
        byte[] byteArray$iv$iv = byArray;
        boolean $i$f$fromByteArray = false;
        ByteArrayInputStream inputStream$iv$iv = new ByteArrayInputStream(byteArray$iv$iv);
        try {
            Object object = new ObjectInputStream(inputStream$iv$iv).readObject();
            if (!(object instanceof EventListener.Event.HeapDump)) {
                object = null;
            }
            heapDump = (EventListener.Event.HeapDump)object;
        }
        catch (Throwable ignored$iv$iv) {
            SharkLog this_$iv$iv$iv = SharkLog.INSTANCE;
            boolean $i$f$d = false;
            SharkLog.Logger logger = this_$iv$iv$iv.getLogger();
            if (logger == null) {
            } else {
                SharkLog.Logger logger$iv$iv$iv = logger;
                Throwable throwable = ignored$iv$iv;
                SharkLog.Logger logger2 = logger$iv$iv$iv;
                boolean bl = false;
                String string2 = "Could not deserialize bytes, ignoring";
                logger2.d(throwable, string2);
            }
            heapDump = null;
        }
        EventListener.Event.HeapDump heapDump2 = heapDump;
        if (heapDump2 == null) {
            Intrinsics.throwNpe();
        }
        EventListener.Event.HeapDump heapDump3 = heapDump2;
        SettableFuture result = SettableFuture.create();
        BackgroundThreadHeapAnalyzer.INSTANCE.getHeapAnalyzerThreadHandler$leakcanary_android_core_release().post(new Runnable(heapDump3, result){
            final /* synthetic */ EventListener.Event.HeapDump $heapDump;
            final /* synthetic */ SettableFuture $result;

            public final void run() {
                EventListener.Event.HeapAnalysisDone<?> doneEvent2 = AndroidDebugHeapAnalyzer.INSTANCE.runAnalysisBlocking(this.$heapDump, (Function0<Boolean>)((Function0)new Function0<Boolean>(this){
                    final /* synthetic */ startRemoteWork.1 this$0;

                    public final boolean invoke() {
                        SettableFuture settableFuture = this.this$0.$result;
                        Intrinsics.checkExpressionValueIsNotNull((Object)settableFuture, (String)"result");
                        return settableFuture.isCancelled();
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                }), (Function1<? super EventListener.Event.HeapAnalysisProgress, Unit>)((Function1)new Function1<EventListener.Event.HeapAnalysisProgress, Unit>(this){
                    final /* synthetic */ startRemoteWork.1 this$0;

                    public final void invoke(@NotNull EventListener.Event.HeapAnalysisProgress progressEvent) {
                        Intrinsics.checkParameterIsNotNull((Object)progressEvent, (String)"progressEvent");
                        SettableFuture settableFuture = this.this$0.$result;
                        Intrinsics.checkExpressionValueIsNotNull((Object)settableFuture, (String)"result");
                        if (!settableFuture.isCancelled()) {
                            InternalLeakCanary.INSTANCE.sendEvent(progressEvent);
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }));
                SettableFuture settableFuture = this.$result;
                Intrinsics.checkExpressionValueIsNotNull((Object)settableFuture, (String)"result");
                if (settableFuture.isCancelled()) {
                    SharkLog this_$iv = SharkLog.INSTANCE;
                    boolean $i$f$d = false;
                    SharkLog.Logger logger = this_$iv.getLogger();
                    if (logger == null) {
                    } else {
                        SharkLog.Logger logger$iv;
                        SharkLog.Logger logger2 = logger$iv = logger;
                        boolean bl = false;
                        String string2 = "Remote heap analysis for " + this.$heapDump.getFile() + " was canceled";
                        logger2.d(string2);
                    }
                } else {
                    InternalLeakCanary.INSTANCE.sendEvent(doneEvent2);
                    this.$result.set((Object)ListenableWorker.Result.success());
                }
            }
            {
                this.$heapDump = heapDump;
                this.$result = settableFuture;
            }
        });
        SettableFuture settableFuture = result;
        Intrinsics.checkExpressionValueIsNotNull((Object)settableFuture, (String)"result");
        return (ListenableFuture)settableFuture;
    }

    @NotNull
    public ListenableFuture<ForegroundInfo> getForegroundInfoAsync() {
        Context context = this.getApplicationContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"applicationContext");
        return HeapAnalyzerWorker.Companion.heapAnalysisForegroundInfoAsync(context);
    }

    public RemoteHeapAnalyzerWorker(@NotNull Context appContext, @NotNull WorkerParameters workerParams) {
        Intrinsics.checkParameterIsNotNull((Object)appContext, (String)"appContext");
        Intrinsics.checkParameterIsNotNull((Object)workerParams, (String)"workerParams");
        super(appContext, workerParams);
    }
}

