/*
 * Decompiled with CFR 0.152.
 */
package leakcanary.internal;

import android.app.Notification;
import android.content.Context;
import androidx.work.Data;
import androidx.work.ForegroundInfo;
import androidx.work.ListenableWorker;
import androidx.work.Worker;
import androidx.work.WorkerParameters;
import androidx.work.impl.utils.futures.SettableFuture;
import com.google.common.util.concurrent.ListenableFuture;
import com.squareup.leakcanary.core.R;
import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import leakcanary.EventListener;
import leakcanary.internal.AndroidDebugHeapAnalyzer;
import leakcanary.internal.HeapAnalyzerWorker;
import leakcanary.internal.InternalLeakCanary;
import leakcanary.internal.NotificationType;
import leakcanary.internal.Notifications;
import leakcanary.internal.Serializables;
import leakcanary.internal.SerializablesKt;
import org.jetbrains.annotations.NotNull;
import shark.SharkLog;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016\u00a8\u0006\r"}, d2={"Lleakcanary/internal/HeapAnalyzerWorker;", "Landroidx/work/Worker;", "appContext", "Landroid/content/Context;", "workerParams", "Landroidx/work/WorkerParameters;", "(Landroid/content/Context;Landroidx/work/WorkerParameters;)V", "doWork", "Landroidx/work/ListenableWorker$Result;", "getForegroundInfoAsync", "Lcom/google/common/util/concurrent/ListenableFuture;", "Landroidx/work/ForegroundInfo;", "Companion", "leakcanary-android-core_release"})
public final class HeapAnalyzerWorker
extends Worker {
    private static final String EVENT_BYTES = "EVENT_BYTES";
    @NotNull
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ListenableWorker.Result doWork() {
        EventListener.Event.HeapDump heapDump;
        void $this$asEvent$iv;
        Data data = this.getInputData();
        Intrinsics.checkExpressionValueIsNotNull((Object)data, (String)"inputData");
        Data data2 = data;
        Companion companion = Companion;
        AndroidDebugHeapAnalyzer androidDebugHeapAnalyzer = AndroidDebugHeapAnalyzer.INSTANCE;
        boolean $i$f$asEvent = false;
        Serializables serializables = Serializables.INSTANCE;
        byte[] byArray = $this$asEvent$iv.getByteArray(EVENT_BYTES);
        if (byArray == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"getByteArray(EVENT_BYTES)!!");
        byte[] byteArray$iv$iv = byArray;
        boolean $i$f$fromByteArray = false;
        ByteArrayInputStream inputStream$iv$iv = new ByteArrayInputStream(byteArray$iv$iv);
        try {
            Object object = new ObjectInputStream(inputStream$iv$iv).readObject();
            if (!(object instanceof EventListener.Event.HeapDump)) {
                object = null;
            }
            heapDump = (EventListener.Event.HeapDump)object;
        }
        catch (Throwable ignored$iv$iv) {
            SharkLog this_$iv$iv$iv = SharkLog.INSTANCE;
            boolean $i$f$d = false;
            SharkLog.Logger logger = this_$iv$iv$iv.getLogger();
            if (logger == null) {
            } else {
                SharkLog.Logger logger$iv$iv$iv = logger;
                Throwable throwable = ignored$iv$iv;
                SharkLog.Logger logger2 = logger$iv$iv$iv;
                boolean bl = false;
                String string2 = "Could not deserialize bytes, ignoring";
                logger2.d(throwable, string2);
            }
            heapDump = null;
        }
        EventListener.Event.HeapDump heapDump2 = heapDump;
        if (heapDump2 == null) {
            Intrinsics.throwNpe();
        }
        EventListener.Event.HeapDump heapDump3 = heapDump2;
        EventListener.Event.HeapAnalysisDone doneEvent2 = AndroidDebugHeapAnalyzer.runAnalysisBlocking$default(androidDebugHeapAnalyzer, heapDump3, null, doWork.doneEvent.1.INSTANCE, 2, null);
        InternalLeakCanary.INSTANCE.sendEvent(doneEvent2);
        ListenableWorker.Result result = ListenableWorker.Result.success();
        Intrinsics.checkExpressionValueIsNotNull((Object)result, (String)"Result.success()");
        return result;
    }

    @NotNull
    public ListenableFuture<ForegroundInfo> getForegroundInfoAsync() {
        Context context = this.getApplicationContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"applicationContext");
        return Companion.heapAnalysisForegroundInfoAsync(context);
    }

    public HeapAnalyzerWorker(@NotNull Context appContext, @NotNull WorkerParameters workerParams) {
        Intrinsics.checkParameterIsNotNull((Object)appContext, (String)"appContext");
        Intrinsics.checkParameterIsNotNull((Object)workerParams, (String)"workerParams");
        super(appContext, workerParams);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0005\u001a\u0002H\u0006\"\u0006\b\u0000\u0010\u0006\u0018\u0001*\u00020\u0007H\u0086\b\u00a2\u0006\u0002\u0010\bJ\u0014\u0010\t\u001a\u00020\u0007*\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e*\u00020\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lleakcanary/internal/HeapAnalyzerWorker$Companion;", "", "()V", "EVENT_BYTES", "", "asEvent", "T", "Landroidx/work/Data;", "(Landroidx/work/Data;)Ljava/lang/Object;", "asWorkerInputData", "Lleakcanary/EventListener$Event;", "dataBuilder", "Landroidx/work/Data$Builder;", "heapAnalysisForegroundInfoAsync", "Lcom/google/common/util/concurrent/ListenableFuture;", "Landroidx/work/ForegroundInfo;", "Landroid/content/Context;", "leakcanary-android-core_release"})
    public static final class Companion {
        @NotNull
        public final Data asWorkerInputData(@NotNull EventListener.Event $this$asWorkerInputData, @NotNull Data.Builder dataBuilder) {
            Intrinsics.checkParameterIsNotNull((Object)$this$asWorkerInputData, (String)"$this$asWorkerInputData");
            Intrinsics.checkParameterIsNotNull((Object)dataBuilder, (String)"dataBuilder");
            Data data = dataBuilder.putByteArray(HeapAnalyzerWorker.EVENT_BYTES, SerializablesKt.toByteArray($this$asWorkerInputData)).build();
            Intrinsics.checkExpressionValueIsNotNull((Object)data, (String)"dataBuilder\n      .putBy\u2026teArray())\n      .build()");
            return data;
        }

        public static /* synthetic */ Data asWorkerInputData$default(Companion companion, EventListener.Event event, Data.Builder builder, int n, Object object) {
            if ((n & 1) != 0) {
                builder = new Data.Builder();
            }
            return companion.asWorkerInputData(event, builder);
        }

        public final /* synthetic */ <T> T asEvent(Data $this$asEvent) {
            Object object;
            int $i$f$asEvent = 0;
            Intrinsics.checkParameterIsNotNull((Object)$this$asEvent, (String)"$this$asEvent");
            Serializables serializables = Serializables.INSTANCE;
            byte[] byArray = $this$asEvent.getByteArray(HeapAnalyzerWorker.EVENT_BYTES);
            if (byArray == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"getByteArray(EVENT_BYTES)!!");
            byte[] byteArray$iv = byArray;
            boolean $i$f$fromByteArray = false;
            ByteArrayInputStream inputStream$iv = new ByteArrayInputStream(byteArray$iv);
            try {
                Object object2 = new ObjectInputStream(inputStream$iv).readObject();
                Intrinsics.reifiedOperationMarker((int)2, (String)"T");
                object = object2;
            }
            catch (Throwable ignored$iv) {
                SharkLog this_$iv$iv = SharkLog.INSTANCE;
                boolean $i$f$d = false;
                SharkLog.Logger logger = this_$iv$iv.getLogger();
                if (logger == null) {
                } else {
                    SharkLog.Logger logger$iv$iv = logger;
                    Throwable throwable = ignored$iv;
                    SharkLog.Logger logger2 = logger$iv$iv;
                    boolean bl = false;
                    String string2 = "Could not deserialize bytes, ignoring";
                    logger2.d(throwable, string2);
                }
                object = null;
            }
            Object object3 = object;
            if (object3 == null) {
                Intrinsics.throwNpe();
            }
            return (T)object3;
        }

        @NotNull
        public final ListenableFuture<ForegroundInfo> heapAnalysisForegroundInfoAsync(@NotNull Context $this$heapAnalysisForegroundInfoAsync) {
            Intrinsics.checkParameterIsNotNull((Object)$this$heapAnalysisForegroundInfoAsync, (String)"$this$heapAnalysisForegroundInfoAsync");
            SettableFuture infoFuture = SettableFuture.create();
            Notification.Builder builder = new Notification.Builder($this$heapAnalysisForegroundInfoAsync).setContentTitle((CharSequence)$this$heapAnalysisForegroundInfoAsync.getString(R.string.leak_canary_notification_analysing)).setContentText((CharSequence)"LeakCanary is working.").setProgress(100, 0, true);
            Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"Notification.Builder(thi\u2026setProgress(100, 0, true)");
            Notification.Builder builder2 = builder;
            Notification notification = Notifications.INSTANCE.buildNotification($this$heapAnalysisForegroundInfoAsync, builder2, NotificationType.LEAKCANARY_LOW);
            infoFuture.set((Object)new ForegroundInfo(R.id.leak_canary_notification_analyzing_heap, notification));
            SettableFuture settableFuture = infoFuture;
            Intrinsics.checkExpressionValueIsNotNull((Object)settableFuture, (String)"infoFuture");
            return (ListenableFuture)settableFuture;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

