/*
 * Decompiled with CFR 0.152.
 */
package leakcanary;

import android.app.Application;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import com.squareup.leakcanary.core.R;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import leakcanary.EventListener;
import leakcanary.internal.InternalLeakCanary;
import leakcanary.internal.NotificationType;
import leakcanary.internal.Notifications;
import org.jetbrains.annotations.NotNull;
import shark.HeapAnalysisSuccess;
import shark.Leak;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lleakcanary/NotificationEventListener;", "Lleakcanary/EventListener;", "()V", "appContext", "Landroid/app/Application;", "notificationManager", "Landroid/app/NotificationManager;", "onEvent", "", "event", "Lleakcanary/EventListener$Event;", "showHeapAnalysisResultNotification", "contentTitle", "", "showIntent", "Landroid/app/PendingIntent;", "leakcanary-android-core_release"})
public final class NotificationEventListener
implements EventListener {
    private static final Application appContext;
    private static final NotificationManager notificationManager;
    @NotNull
    public static final NotificationEventListener INSTANCE;

    /*
     * WARNING - void declaration
     */
    @Override
    public void onEvent(@NotNull EventListener.Event event) {
        block5: {
            PendingIntent pendingIntent;
            String string2;
            EventListener.Event event2;
            block7: {
                block6: {
                    block4: {
                        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                        if (!Notifications.INSTANCE.getCanShowNotification()) {
                            return;
                        }
                        event2 = event;
                        if (!(event2 instanceof EventListener.Event.DumpingHeap)) break block4;
                        String string3 = appContext.getString(R.string.leak_canary_notification_dumping);
                        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"appContext.getString(R.s\u2026ary_notification_dumping)");
                        String dumpingHeap = string3;
                        Notification.Builder builder = new Notification.Builder((Context)appContext).setContentTitle((CharSequence)dumpingHeap);
                        Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"Notification.Builder(app\u2026ContentTitle(dumpingHeap)");
                        Notification.Builder builder2 = builder;
                        Notification notification = Notifications.INSTANCE.buildNotification((Context)appContext, builder2, NotificationType.LEAKCANARY_LOW);
                        notificationManager.notify(R.id.leak_canary_notification_dumping_heap, notification);
                        break block5;
                    }
                    if (!(event2 instanceof EventListener.Event.HeapDumpFailed) && !(event2 instanceof EventListener.Event.HeapDump)) break block6;
                    notificationManager.cancel(R.id.leak_canary_notification_dumping_heap);
                    break block5;
                }
                if (!(event2 instanceof EventListener.Event.HeapAnalysisProgress)) break block7;
                int progress = (int)(((EventListener.Event.HeapAnalysisProgress)event).getProgressPercent() * (double)100);
                Notification.Builder builder = new Notification.Builder((Context)appContext).setContentTitle((CharSequence)appContext.getString(R.string.leak_canary_notification_analysing)).setContentText((CharSequence)((EventListener.Event.HeapAnalysisProgress)event).getStep().getHumanReadableName()).setProgress(100, progress, false);
                Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"Notification.Builder(app\u2026ess(100, progress, false)");
                Notification.Builder builder3 = builder;
                Notification notification = Notifications.INSTANCE.buildNotification((Context)appContext, builder3, NotificationType.LEAKCANARY_LOW);
                notificationManager.notify(R.id.leak_canary_notification_analyzing_heap, notification);
                break block5;
            }
            if (!(event2 instanceof EventListener.Event.HeapAnalysisDone)) break block5;
            notificationManager.cancel(R.id.leak_canary_notification_analyzing_heap);
            if (event instanceof EventListener.Event.HeapAnalysisDone.HeapAnalysisSucceeded) {
                HeapAnalysisSuccess heapAnalysis = (HeapAnalysisSuccess)((EventListener.Event.HeapAnalysisDone.HeapAnalysisSucceeded)event).getHeapAnalysis();
                Sequence $this$sumBy$iv = heapAnalysis.getAllLeaks();
                boolean $i$f$sumBy = false;
                int sum$iv = 0;
                for (Object element$iv : $this$sumBy$iv) {
                    void it;
                    Leak leak = (Leak)element$iv;
                    int n = sum$iv;
                    boolean bl = false;
                    int n2 = it.getLeakTraces().size();
                    sum$iv = n + n2;
                }
                int retainedObjectCount = sum$iv;
                int leakTypeCount = heapAnalysis.getApplicationLeaks().size() + heapAnalysis.getLibraryLeaks().size();
                int unreadLeakCount = ((EventListener.Event.HeapAnalysisDone.HeapAnalysisSucceeded)event).getUnreadLeakSignatures().size();
                string2 = appContext.getString(R.string.leak_canary_analysis_success_notification, new Object[]{retainedObjectCount, leakTypeCount, unreadLeakCount});
            } else {
                string2 = appContext.getString(R.string.leak_canary_analysis_failed);
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"if (event is HeapAnalysi\u2026nalysis_failed)\n        }");
            String contentTitle = string2;
            int flags = Build.VERSION.SDK_INT >= 23 ? 0xC000000 : 0x8000000;
            PendingIntent pendingIntent2 = pendingIntent = PendingIntent.getActivity((Context)((Context)appContext), (int)1, (Intent)((EventListener.Event.HeapAnalysisDone)event).getShowIntent(), (int)flags);
            Intrinsics.checkExpressionValueIsNotNull((Object)pendingIntent2, (String)"pendingIntent");
            this.showHeapAnalysisResultNotification(contentTitle, pendingIntent2);
        }
    }

    private final void showHeapAnalysisResultNotification(String contentTitle, PendingIntent showIntent) {
        String string2 = appContext.getString(R.string.leak_canary_notification_message);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"appContext.getString(R.s\u2026ary_notification_message)");
        String contentText = string2;
        Notifications.INSTANCE.showNotification((Context)appContext, contentTitle, contentText, showIntent, R.id.leak_canary_notification_analysis_result, NotificationType.LEAKCANARY_MAX);
    }

    private NotificationEventListener() {
    }

    static {
        NotificationEventListener notificationEventListener;
        INSTANCE = notificationEventListener = new NotificationEventListener();
        appContext = InternalLeakCanary.INSTANCE.getApplication();
        Object object = appContext.getSystemService("notification");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.app.NotificationManager");
        }
        notificationManager = (NotificationManager)object;
    }
}

