/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.javapoet;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import com.squareup.javapoet.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Formatter;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import javax.lang.model.element.Modifier;

final class CodeWriter {
    private final String indent;
    private final Appendable out;
    private int indentLevel;
    private boolean javadoc = false;
    private boolean comment = false;
    private String packageName;
    private final List<TypeSpec> typeSpecStack = new ArrayList<TypeSpec>();
    private final Map<ClassName, String> importedTypes;
    private final Set<ClassName> importableTypes = new LinkedHashSet<ClassName>();
    private final Set<String> referencedNames = new LinkedHashSet<String>();
    private boolean trailingNewline;
    int statementLine = -1;

    CodeWriter(Appendable out) {
        this(out, "  ");
    }

    public CodeWriter(Appendable out, String indent) {
        this(out, indent, Collections.emptyMap());
    }

    public CodeWriter(Appendable out, String indent, Map<ClassName, String> importedTypes) {
        this.out = Util.checkNotNull(out, "out == null", new Object[0]);
        this.indent = Util.checkNotNull(indent, "indent == null", new Object[0]);
        this.importedTypes = Util.checkNotNull(importedTypes, "importedTypes == null", new Object[0]);
    }

    public Map<ClassName, String> importedTypes() {
        return this.importedTypes;
    }

    public CodeWriter indent() {
        return this.indent(1);
    }

    public CodeWriter indent(int levels) {
        this.indentLevel += levels;
        return this;
    }

    public CodeWriter unindent() {
        return this.unindent(1);
    }

    public CodeWriter unindent(int levels) {
        Util.checkArgument(this.indentLevel - levels >= 0, "cannot unindent %s from %s", levels, this.indentLevel);
        this.indentLevel -= levels;
        return this;
    }

    public CodeWriter pushPackage(String packageName) {
        Util.checkState(this.packageName == null, "package already set: %s", this.packageName);
        this.packageName = Util.checkNotNull(packageName, "packageName == null", new Object[0]);
        return this;
    }

    public CodeWriter popPackage() {
        Util.checkState(this.packageName != null, "package already set: %s", this.packageName);
        this.packageName = null;
        return this;
    }

    public CodeWriter pushType(TypeSpec type) {
        this.typeSpecStack.add(type);
        return this;
    }

    public CodeWriter popType() {
        this.typeSpecStack.remove(this.typeSpecStack.size() - 1);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void emitComment(CodeBlock codeBlock) throws IOException {
        this.trailingNewline = true;
        this.comment = true;
        try {
            this.emit(codeBlock);
            this.emit("\n", new Object[0]);
        }
        finally {
            this.comment = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void emitJavadoc(CodeBlock javadocCodeBlock) throws IOException {
        if (javadocCodeBlock.isEmpty()) {
            return;
        }
        this.emit("/**\n", new Object[0]);
        this.javadoc = true;
        try {
            this.emit(javadocCodeBlock);
        }
        finally {
            this.javadoc = false;
        }
        this.emit(" */\n", new Object[0]);
    }

    public void emitAnnotations(List<AnnotationSpec> annotations, boolean inline) throws IOException {
        for (AnnotationSpec annotationSpec : annotations) {
            annotationSpec.emit(this, inline);
            this.emit(inline ? " " : "\n", new Object[0]);
        }
    }

    public void emitModifiers(Set<Modifier> modifiers, Set<Modifier> implicitModifiers) throws IOException {
        if (modifiers.isEmpty()) {
            return;
        }
        for (Modifier modifier : EnumSet.copyOf(modifiers)) {
            if (implicitModifiers.contains((Object)modifier)) continue;
            this.emitAndIndent(modifier.name().toLowerCase(Locale.US));
            this.emitAndIndent(" ");
        }
    }

    public void emitModifiers(Set<Modifier> modifiers) throws IOException {
        this.emitModifiers(modifiers, Collections.emptySet());
    }

    public void emitTypeVariables(List<TypeVariableName> typeVariables) throws IOException {
        if (typeVariables.isEmpty()) {
            return;
        }
        this.emit("<", new Object[0]);
        boolean firstTypeVariable = true;
        for (TypeVariableName typeVariable : typeVariables) {
            if (!firstTypeVariable) {
                this.emit(", ", new Object[0]);
            }
            this.emit("$L", typeVariable.name);
            boolean firstBound = true;
            for (TypeName bound : typeVariable.bounds) {
                this.emit(firstBound ? " extends $T" : " & $T", bound);
                firstBound = false;
            }
            firstTypeVariable = false;
        }
        this.emit(">", new Object[0]);
    }

    public CodeWriter emit(String format, Object ... args) throws IOException {
        return this.emit(CodeBlock.builder().add(format, args).build());
    }

    public CodeWriter emit(CodeBlock codeBlock) throws IOException {
        int a = 0;
        Iterator<String> i$ = codeBlock.formatParts.iterator();
        block22: while (i$.hasNext()) {
            String part;
            switch (part = i$.next()) {
                case "$L": {
                    this.emitLiteral(codeBlock.args.get(a++));
                    continue block22;
                }
                case "$N": {
                    this.emitAndIndent((String)codeBlock.args.get(a++));
                    continue block22;
                }
                case "$S": {
                    String string = (String)codeBlock.args.get(a++);
                    this.emitAndIndent(string != null ? this.stringLiteral(string) : "null");
                    continue block22;
                }
                case "$T": {
                    TypeName typeName = (TypeName)codeBlock.args.get(a++);
                    typeName.emit(this);
                    continue block22;
                }
                case "$$": {
                    this.emitAndIndent("$");
                    continue block22;
                }
                case "$>": {
                    this.indent();
                    continue block22;
                }
                case "$<": {
                    this.unindent();
                    continue block22;
                }
                case "$[": {
                    Util.checkState(this.statementLine == -1, "statements cannot be re-entrant", new Object[0]);
                    this.statementLine = 0;
                    continue block22;
                }
                case "$]": {
                    Util.checkState(this.statementLine != -1, "statement exit has no matching statement enter", new Object[0]);
                    if (this.statementLine > 0) {
                        this.unindent(2);
                    }
                    this.statementLine = -1;
                    continue block22;
                }
            }
            this.emitAndIndent(part);
        }
        return this;
    }

    private void emitLiteral(Object o) throws IOException {
        if (o instanceof TypeSpec) {
            TypeSpec typeSpec = (TypeSpec)o;
            typeSpec.emit(this, null, Collections.emptySet());
        } else if (o instanceof AnnotationSpec) {
            AnnotationSpec annotationSpec = (AnnotationSpec)o;
            annotationSpec.emit(this, true);
        } else if (o instanceof CodeBlock) {
            CodeBlock codeBlock = (CodeBlock)o;
            this.emit(codeBlock);
        } else {
            this.emitAndIndent(String.valueOf(o));
        }
    }

    String lookupName(ClassName className) {
        if (!className.packageName().equals(this.packageName)) {
            if (this.conflictsWithLocalName(className)) {
                return className.toString();
            }
            String importedName = this.importedTypes.get(className);
            if (importedName != null) {
                if (!this.javadoc) {
                    this.importableTypes.add(className);
                }
                this.referencedNames.add(importedName);
                return importedName;
            }
            ClassName enclosingClassName = className.enclosingClassName();
            if (enclosingClassName != null) {
                return this.lookupName(enclosingClassName) + "." + className.simpleName();
            }
            if (!this.javadoc) {
                this.importableTypes.add(className);
            }
            return className.canonicalName;
        }
        List<String> classNames = className.simpleNames();
        int prefixLength = this.commonPrefixLength(classNames);
        if (prefixLength == classNames.size()) {
            return className.simpleName();
        }
        this.referencedNames.add(classNames.get(0));
        return Util.join(".", classNames.subList(prefixLength, classNames.size()));
    }

    private boolean conflictsWithLocalName(ClassName className) {
        for (TypeSpec typeSpec : this.typeSpecStack) {
            if (Objects.equals(typeSpec.name, className.simpleName())) {
                return true;
            }
            for (TypeSpec visibleChild : typeSpec.typeSpecs) {
                if (!Objects.equals(visibleChild.name, className.simpleName())) continue;
                return true;
            }
        }
        return false;
    }

    private int commonPrefixLength(List<String> classNames) {
        int size = Math.min(classNames.size(), this.typeSpecStack.size());
        for (int i = 0; i < size; ++i) {
            String b;
            String a = classNames.get(i);
            if (a.equals(b = this.typeSpecStack.get((int)i).name)) continue;
            return i;
        }
        return size;
    }

    CodeWriter emitAndIndent(String s) throws IOException {
        boolean first = true;
        for (String line : s.split("\n", -1)) {
            if (!first) {
                if ((this.javadoc || this.comment) && this.trailingNewline) {
                    this.emitIndentation();
                    this.out.append(this.javadoc ? " *" : "//");
                }
                this.out.append('\n');
                this.trailingNewline = true;
                if (this.statementLine != -1) {
                    if (this.statementLine == 0) {
                        this.indent(2);
                    }
                    ++this.statementLine;
                }
            }
            first = false;
            if (line.isEmpty()) continue;
            if (this.trailingNewline) {
                this.emitIndentation();
                if (this.javadoc) {
                    this.out.append(" * ");
                } else if (this.comment) {
                    this.out.append("// ");
                }
            }
            this.out.append(line);
            this.trailingNewline = false;
        }
        return this;
    }

    private void emitIndentation() throws IOException {
        for (int j = 0; j < this.indentLevel; ++j) {
            this.out.append(this.indent);
        }
    }

    Map<ClassName, String> suggestedImports() {
        LinkedHashMap<String, ClassName> simpleNameToType = new LinkedHashMap<String, ClassName>();
        for (ClassName className : this.importableTypes) {
            if (this.referencedNames.contains(className.simpleName()) || simpleNameToType.containsKey(className.simpleName())) continue;
            simpleNameToType.put(className.simpleName(), className);
        }
        TreeMap<ClassName, String> typeToSimpleName = new TreeMap<ClassName, String>();
        for (Map.Entry entry : simpleNameToType.entrySet()) {
            typeToSimpleName.put((ClassName)entry.getValue(), (String)entry.getKey());
        }
        return typeToSimpleName;
    }

    String stringLiteral(String value) {
        StringBuilder result = new StringBuilder();
        result.append('\"');
        block9: for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '\"': {
                    result.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    result.append("\\\\");
                    continue block9;
                }
                case '\b': {
                    result.append("\\b");
                    continue block9;
                }
                case '\t': {
                    result.append("\\t");
                    continue block9;
                }
                case '\n': {
                    result.append("\\n");
                    if (i + 1 >= value.length()) continue block9;
                    result.append("\"\n").append(this.indent).append(this.indent).append("+ \"");
                    continue block9;
                }
                case '\f': {
                    result.append("\\f");
                    continue block9;
                }
                case '\r': {
                    result.append("\\r");
                    continue block9;
                }
                default: {
                    if (Character.isISOControl(c)) {
                        new Formatter(result).format("\\u%04x", c);
                        continue block9;
                    }
                    result.append(c);
                }
            }
        }
        result.append('\"');
        return result.toString();
    }
}

