/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.javapoet;

import com.squareup.javapoet.CodeWriter;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;

public final class ClassName
extends TypeName
implements Comparable<ClassName> {
    public static final ClassName OBJECT = ClassName.get(Object.class);
    final List<String> names;
    final String canonicalName;

    private ClassName(List<String> names) {
        for (int i = 1; i < names.size(); ++i) {
            Util.checkArgument(SourceVersion.isName(names.get(i)), "part '%s' is keyword", names.get(i));
        }
        this.names = Util.immutableList(names);
        this.canonicalName = names.get(0).isEmpty() ? Util.join(".", names.subList(1, names.size())) : Util.join(".", names);
    }

    public String packageName() {
        return this.names.get(0);
    }

    public ClassName enclosingClassName() {
        if (this.names.size() == 2) {
            return null;
        }
        return new ClassName(this.names.subList(0, this.names.size() - 1));
    }

    public ClassName nestedClass(String name) {
        Util.checkNotNull(name, "name == null", new Object[0]);
        ArrayList<String> result = new ArrayList<String>(this.names.size() + 1);
        result.addAll(this.names);
        result.add(name);
        return new ClassName(result);
    }

    public List<String> simpleNames() {
        return this.names.subList(1, this.names.size());
    }

    public ClassName peerClass(String name) {
        ArrayList<String> result = new ArrayList<String>(this.names);
        result.set(result.size() - 1, name);
        return new ClassName(result);
    }

    public String simpleName() {
        return this.names.get(this.names.size() - 1);
    }

    public static ClassName get(Class<?> clazz) {
        Util.checkNotNull(clazz, "clazz == null", new Object[0]);
        Util.checkArgument(!clazz.isPrimitive(), "primitive types cannot be represented as a ClassName", new Object[0]);
        Util.checkArgument(!Void.TYPE.equals(clazz), "'void' type cannot be represented as a ClassName", new Object[0]);
        Util.checkArgument(!clazz.isArray(), "array types cannot be represented as a ClassName", new Object[0]);
        ArrayList<String> names = new ArrayList<String>();
        for (Class<?> c = clazz; c != null; c = c.getEnclosingClass()) {
            names.add(c.getSimpleName());
        }
        if (clazz.getPackage() != null) {
            names.add(clazz.getPackage().getName());
        }
        Collections.reverse(names);
        return new ClassName(names);
    }

    public static ClassName bestGuess(String classNameString) {
        ArrayList<String> names = new ArrayList<String>();
        int p = 0;
        while (p < classNameString.length() && Character.isLowerCase(classNameString.codePointAt(p))) {
            Util.checkArgument((p = classNameString.indexOf(46, p) + 1) != 0, "couldn't make a guess for %s", classNameString);
        }
        names.add(p != 0 ? classNameString.substring(0, p - 1) : "");
        for (String part : classNameString.substring(p).split("\\.", -1)) {
            Util.checkArgument(!part.isEmpty() && Character.isUpperCase(part.codePointAt(0)), "couldn't make a guess for %s", classNameString);
            names.add(part);
        }
        Util.checkArgument(names.size() >= 2, "couldn't make a guess for %s", classNameString);
        return new ClassName(names);
    }

    public static ClassName get(String packageName, String simpleName, String ... simpleNames) {
        ArrayList<String> result = new ArrayList<String>();
        result.add(packageName);
        result.add(simpleName);
        Collections.addAll(result, simpleNames);
        return new ClassName(result);
    }

    public static ClassName get(TypeElement element) {
        Util.checkNotNull(element, "element == null", new Object[0]);
        ArrayList<String> names = new ArrayList<String>();
        Element e = element;
        while (ClassName.isClassOrInterface(e)) {
            Util.checkArgument(element.getNestingKind() == NestingKind.TOP_LEVEL || element.getNestingKind() == NestingKind.MEMBER, "unexpected type testing", new Object[0]);
            names.add(e.getSimpleName().toString());
            e = e.getEnclosingElement();
        }
        names.add(ClassName.getPackage(element).getQualifiedName().toString());
        Collections.reverse(names);
        return new ClassName(names);
    }

    private static boolean isClassOrInterface(Element e) {
        return e.getKind().isClass() || e.getKind().isInterface();
    }

    private static PackageElement getPackage(Element type) {
        while (type.getKind() != ElementKind.PACKAGE) {
            type = type.getEnclosingElement();
        }
        return (PackageElement)type;
    }

    public boolean equals(Object o) {
        return o instanceof ClassName && this.canonicalName.equals(((ClassName)o).canonicalName);
    }

    public int hashCode() {
        return this.canonicalName.hashCode();
    }

    @Override
    public int compareTo(ClassName o) {
        return this.canonicalName.compareTo(o.canonicalName);
    }

    @Override
    CodeWriter emit(CodeWriter out) throws IOException {
        return out.emitAndIndent(out.lookupName(this));
    }
}

