/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.duktape;

import com.squareup.duktape.Duktape;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class DuktapeException
extends RuntimeException {
    private static final Pattern STACK_TRACE_PATTERN = Pattern.compile("\\s*([^\\s]+) ([^\\s]+):(\\d+).*$");
    private static final String STACK_TRACE_CLASS_NAME = "JavaScript";

    public DuktapeException(String detailMessage) {
        super(DuktapeException.getErrorMessage(detailMessage));
        DuktapeException.addDuktapeStack(this, detailMessage);
    }

    static void addDuktapeStack(Throwable throwable, String detailMessage) {
        String[] lines = detailMessage.split("\n", -1);
        if (lines.length <= 1) {
            return;
        }
        ArrayList<StackTraceElement> elements = new ArrayList<StackTraceElement>();
        boolean spliced = false;
        for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
            if (!spliced && stackTraceElement.isNativeMethod() && stackTraceElement.getClassName().equals(Duktape.class.getName()) && stackTraceElement.getMethodName().equals("evaluate")) {
                for (int i = 1; i < lines.length; ++i) {
                    StackTraceElement jsElement = DuktapeException.toStackTraceElement(lines[i]);
                    if (jsElement == null) continue;
                    elements.add(jsElement);
                }
                spliced = true;
            }
            elements.add(stackTraceElement);
        }
        throwable.setStackTrace(elements.toArray(new StackTraceElement[elements.size()]));
    }

    private static String getErrorMessage(String detailMessage) {
        int end = detailMessage.indexOf(10);
        return end > 0 ? detailMessage.substring(0, end) : detailMessage;
    }

    private static StackTraceElement toStackTraceElement(String s) {
        Matcher m = STACK_TRACE_PATTERN.matcher(s);
        if (!m.matches()) {
            return null;
        }
        return new StackTraceElement(STACK_TRACE_CLASS_NAME, m.group(1), m.group(2), Integer.parseInt(m.group(3)));
    }
}

