/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.duktape;

import java.io.Closeable;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public final class Duktape
implements Closeable {
    private long context;

    public static Duktape create() {
        long context = Duktape.createContext();
        if (context == 0L) {
            throw new OutOfMemoryError("Cannot create Duktape instance");
        }
        return new Duktape(context);
    }

    private Duktape(long context) {
        this.context = context;
    }

    public synchronized String evaluate(String script, String fileName) {
        return Duktape.evaluate(this.context, script, fileName);
    }

    public String evaluate(String script) {
        return this.evaluate(script, "?");
    }

    public <T> void bind(String name, Class<T> type, T object) {
        if (!type.isInterface()) {
            throw new UnsupportedOperationException("Only interfaces can be bound. Received: " + type);
        }
        if (type.getInterfaces().length > 0) {
            throw new UnsupportedOperationException(type + " must not extend other interfaces");
        }
        if (!type.isInstance(object)) {
            throw new IllegalArgumentException(object.getClass() + " is not an instance of " + type);
        }
        LinkedHashMap<String, Method> methods = new LinkedHashMap<String, Method>();
        for (Method method : type.getMethods()) {
            if (methods.put(method.getName(), method) == null) continue;
            throw new UnsupportedOperationException(method.getName() + " is overloaded in " + type);
        }
        Duktape.bind(this.context, name, object, methods.values().toArray());
    }

    @Override
    public synchronized void close() {
        if (this.context != 0L) {
            long contextToClose = this.context;
            this.context = 0L;
            Duktape.destroyContext(contextToClose);
        }
    }

    protected synchronized void finalize() throws Throwable {
        if (this.context != 0L) {
            Logger.getLogger(this.getClass().getName()).warning("Duktape instance leaked!");
        }
    }

    private static native long createContext();

    private static native void destroyContext(long var0);

    private static native String evaluate(long var0, String var2, String var3);

    private static native void bind(long var0, String var2, Object var3, Object[] var4);

    private static int getLocalTimeZoneOffset(double t) {
        int offsetMillis = TimeZone.getDefault().getOffset((long)t);
        return (int)TimeUnit.MILLISECONDS.toSeconds(offsetMillis);
    }

    static {
        System.loadLibrary("duktape");
    }
}

