/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.widget;

import android.annotation.TargetApi;
import android.graphics.drawable.Drawable;
import android.widget.Spinner;
import org.assertj.android.api.widget.AbstractAbsSpinnerAssert;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;

public class SpinnerAssert
extends AbstractAbsSpinnerAssert<SpinnerAssert, Spinner> {
    public SpinnerAssert(Spinner actual) {
        super(actual, SpinnerAssert.class);
    }

    @TargetApi(value=16)
    public SpinnerAssert hasDropDownHorizontalOffset(int offset) {
        this.isNotNull();
        int actualOffset = ((Spinner)this.actual).getDropDownHorizontalOffset();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualOffset).overridingErrorMessage("Expected drop-down horizontal offset <%s> but was <%s>.", new Object[]{offset, actualOffset})).isEqualTo(offset);
        return this;
    }

    @TargetApi(value=16)
    public SpinnerAssert hasDropDownVerticalOffset(int offset) {
        this.isNotNull();
        int actualOffset = ((Spinner)this.actual).getDropDownVerticalOffset();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualOffset).overridingErrorMessage("Expected drop-down vertical offset <%s> but was <%s>.", new Object[]{offset, actualOffset})).isEqualTo(offset);
        return this;
    }

    @TargetApi(value=16)
    public SpinnerAssert hasDropDownWidth(int width) {
        this.isNotNull();
        int actualWidth = ((Spinner)this.actual).getDropDownWidth();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualWidth).overridingErrorMessage("Expected drop-down width <%s> but was <%s>.", new Object[]{width, actualWidth})).isEqualTo(width);
        return this;
    }

    @TargetApi(value=16)
    public SpinnerAssert hasGravity(int gravity) {
        this.isNotNull();
        int actualGravity = ((Spinner)this.actual).getGravity();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualGravity).overridingErrorMessage("Expected gravity <%s> but was <%s>.", new Object[]{gravity, actualGravity})).isEqualTo(gravity);
        return this;
    }

    @TargetApi(value=16)
    public SpinnerAssert hasPopupBackground(Drawable background) {
        this.isNotNull();
        Drawable actualBackground = ((Spinner)this.actual).getPopupBackground();
        ((AbstractObjectAssert)Assertions.assertThat((Object)actualBackground).overridingErrorMessage("Expected popup background <%s> but was <%s>.", new Object[]{background, actualBackground})).isSameAs((Object)background);
        return this;
    }

    public SpinnerAssert hasPrompt(CharSequence text) {
        this.isNotNull();
        CharSequence actualText = ((Spinner)this.actual).getPrompt();
        ((AbstractCharSequenceAssert)Assertions.assertThat((CharSequence)actualText).overridingErrorMessage("Expected prompt <%s> but was <%s>.", new Object[]{text, actualText})).isEqualTo((Object)text);
        return this;
    }

    public SpinnerAssert hasPrompt(int resId) {
        this.isNotNull();
        return this.hasPrompt(((Spinner)this.actual).getContext().getString(resId));
    }
}

