/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.view.accessibility;

import android.annotation.TargetApi;
import android.view.accessibility.AccessibilityEvent;
import org.assertj.android.api.view.accessibility.AbstractAccessibilityRecordAssert;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;

public class AccessibilityEventAssert
extends AbstractAccessibilityRecordAssert<AccessibilityEventAssert, AccessibilityEvent> {
    public AccessibilityEventAssert(AccessibilityEvent actual) {
        super(actual, AccessibilityEventAssert.class);
    }

    @TargetApi(value=16)
    public AccessibilityEventAssert hasAction(int action) {
        this.isNotNull();
        int actualAction = ((AccessibilityEvent)this.actual).getAction();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualAction).overridingErrorMessage("Expected action <%s> but was <%s>.", new Object[]{action, actualAction})).isEqualTo(action);
        return this;
    }

    public AccessibilityEventAssert hasEventTime(long time) {
        this.isNotNull();
        long actualTime = ((AccessibilityEvent)this.actual).getEventTime();
        ((AbstractLongAssert)Assertions.assertThat((long)actualTime).overridingErrorMessage("Expected event time <%s> but was <%s>.", new Object[]{time, actualTime})).isEqualTo(time);
        return this;
    }

    public AccessibilityEventAssert hasEventType(int type) {
        this.isNotNull();
        int actualType = ((AccessibilityEvent)this.actual).getEventType();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualType).overridingErrorMessage("Expected event type <%s> but was <%s>.", new Object[]{type, actualType})).isEqualTo(type);
        return this;
    }

    @TargetApi(value=16)
    public AccessibilityEventAssert hasMovementGranularity(int granularity) {
        this.isNotNull();
        int actualGranularity = ((AccessibilityEvent)this.actual).getMovementGranularity();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualGranularity).overridingErrorMessage("Expected movement granularity <%s> but was <%s>.", new Object[]{granularity, actualGranularity})).isEqualTo(granularity);
        return this;
    }

    public AccessibilityEventAssert hasPackageName(CharSequence name) {
        this.isNotNull();
        CharSequence actualName = ((AccessibilityEvent)this.actual).getPackageName();
        ((AbstractCharSequenceAssert)Assertions.assertThat((CharSequence)actualName).overridingErrorMessage("Expected package name <%s> but was <%s>.", new Object[]{name, actualName})).isEqualTo((Object)name);
        return this;
    }
}

