/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.view.accessibility;

import android.annotation.TargetApi;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityRecord;
import java.util.List;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;

@TargetApi(value=14)
public abstract class AbstractAccessibilityRecordAssert<S extends AbstractAccessibilityRecordAssert<S, A>, A extends AccessibilityRecord>
extends AbstractAssert<S, A> {
    protected AbstractAccessibilityRecordAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public AbstractAccessibilityRecordAssert hasAddedCount(int count) {
        this.isNotNull();
        int actualCount = ((AccessibilityRecord)this.actual).getAddedCount();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualCount).overridingErrorMessage("Expected added count <%s> but was <%s>.", new Object[]{count, actualCount})).isEqualTo(count);
        return this;
    }

    public AbstractAccessibilityRecordAssert hasBeforeText(CharSequence text) {
        this.isNotNull();
        CharSequence actualText = ((AccessibilityRecord)this.actual).getBeforeText();
        ((AbstractCharSequenceAssert)Assertions.assertThat((CharSequence)actualText).overridingErrorMessage("Expected before text <%s> but was <%s>.", new Object[]{text, actualText})).isEqualTo((Object)text);
        return this;
    }

    public AbstractAccessibilityRecordAssert hasClassName(CharSequence name) {
        this.isNotNull();
        CharSequence actualName = ((AccessibilityRecord)this.actual).getClassName();
        ((AbstractCharSequenceAssert)Assertions.assertThat((CharSequence)actualName).overridingErrorMessage("Expected class name <%s> but was <%s>.", new Object[]{name, actualName})).isEqualTo((Object)name);
        return this;
    }

    public AbstractAccessibilityRecordAssert hasContentDescription(CharSequence description) {
        this.isNotNull();
        CharSequence actualDescription = ((AccessibilityRecord)this.actual).getContentDescription();
        ((AbstractCharSequenceAssert)Assertions.assertThat((CharSequence)actualDescription).overridingErrorMessage("Expected content description <%s> but was <%s>.", new Object[]{description, actualDescription})).isEqualTo((Object)description);
        return this;
    }

    public AbstractAccessibilityRecordAssert hasCurrentItemIndex(int index) {
        this.isNotNull();
        int actualIndex = ((AccessibilityRecord)this.actual).getCurrentItemIndex();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualIndex).overridingErrorMessage("Expected current item index <%s> but was <%s>.", new Object[]{index, actualIndex})).isEqualTo(index);
        return this;
    }

    public AbstractAccessibilityRecordAssert hasFromIndex(int index) {
        this.isNotNull();
        int actualIndex = ((AccessibilityRecord)this.actual).getFromIndex();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualIndex).overridingErrorMessage("Expected from index <%s> but was <%s>.", new Object[]{index, actualIndex})).isEqualTo(index);
        return this;
    }

    public AbstractAccessibilityRecordAssert hasItemCount(int count) {
        this.isNotNull();
        int actualCount = ((AccessibilityRecord)this.actual).getItemCount();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualCount).overridingErrorMessage("Expected item count <%s> but was <%s>.", new Object[]{count, actualCount})).isEqualTo(count);
        return this;
    }

    @TargetApi(value=15)
    public AbstractAccessibilityRecordAssert hasMaximumScrollX(int scroll) {
        this.isNotNull();
        int actualScroll = ((AccessibilityRecord)this.actual).getMaxScrollX();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualScroll).overridingErrorMessage("Expected maximum X scroll <%s> but was <%s>.", new Object[]{scroll, actualScroll})).isEqualTo(scroll);
        return this;
    }

    @TargetApi(value=15)
    public AbstractAccessibilityRecordAssert hasMaximumScrollY(int scroll) {
        this.isNotNull();
        int actualScroll = ((AccessibilityRecord)this.actual).getMaxScrollY();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualScroll).overridingErrorMessage("Expected maximum Y scroll <%s> but was <%s>.", new Object[]{scroll, actualScroll})).isEqualTo(scroll);
        return this;
    }

    public AbstractAccessibilityRecordAssert hasRemovedCount(int count) {
        this.isNotNull();
        int actualCount = ((AccessibilityRecord)this.actual).getRemovedCount();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualCount).overridingErrorMessage("Expected remove count <%s> but was <%s>.", new Object[]{count, actualCount})).isEqualTo(count);
        return this;
    }

    public AbstractAccessibilityRecordAssert hasScrollX(int scroll) {
        this.isNotNull();
        int actualScroll = ((AccessibilityRecord)this.actual).getScrollX();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualScroll).overridingErrorMessage("Expected X scroll <%s> but was <%s>.", new Object[]{scroll, actualScroll})).isEqualTo(scroll);
        return this;
    }

    public AbstractAccessibilityRecordAssert hasScrollY(int scroll) {
        this.isNotNull();
        int actualScroll = ((AccessibilityRecord)this.actual).getScrollY();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualScroll).overridingErrorMessage("Expected maximum Y scroll <%s> but was <%s>.", new Object[]{scroll, actualScroll})).isEqualTo(scroll);
        return this;
    }

    public AbstractAccessibilityRecordAssert hasSource(AccessibilityNodeInfo info) {
        this.isNotNull();
        AccessibilityNodeInfo actualInfo = ((AccessibilityRecord)this.actual).getSource();
        ((AbstractObjectAssert)Assertions.assertThat((Object)actualInfo).overridingErrorMessage("Expected source <%s> but was <%s>.", new Object[]{info, actualInfo})).isSameAs((Object)info);
        return this;
    }

    public AbstractAccessibilityRecordAssert hasText(List<CharSequence> text) {
        this.isNotNull();
        List actualText = ((AccessibilityRecord)this.actual).getText();
        ((AbstractListAssert)Assertions.assertThat((List)actualText).overridingErrorMessage("Expected text <%s> but was <%s>.", new Object[]{text, actualText})).isEqualTo(text);
        return this;
    }

    public AbstractAccessibilityRecordAssert hasToIndex(int index) {
        this.isNotNull();
        int actualIndex = ((AccessibilityRecord)this.actual).getToIndex();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualIndex).overridingErrorMessage("Expected to index <%s> but was <%s>.", new Object[]{index, actualIndex})).isEqualTo(index);
        return this;
    }

    public AbstractAccessibilityRecordAssert hasWindowId(int id) {
        this.isNotNull();
        int actualId = ((AccessibilityRecord)this.actual).getWindowId();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualId).overridingErrorMessage("Expected window ID <%s> but was <%s>.", new Object[]{id, actualId})).isEqualTo(id);
        return this;
    }

    public AbstractAccessibilityRecordAssert isChecked() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((AccessibilityRecord)this.actual).isChecked()).overridingErrorMessage("Expected to be checked but was not.", new Object[0])).isTrue();
        return this;
    }

    public AbstractAccessibilityRecordAssert isNotChecked() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((AccessibilityRecord)this.actual).isChecked()).overridingErrorMessage("Expected to not be checked but was.", new Object[0])).isFalse();
        return this;
    }

    public AbstractAccessibilityRecordAssert isEnabled() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((AccessibilityRecord)this.actual).isEnabled()).overridingErrorMessage("Expected to be enabled but was not.", new Object[0])).isTrue();
        return this;
    }

    public AbstractAccessibilityRecordAssert isNotEnabled() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((AccessibilityRecord)this.actual).isEnabled()).overridingErrorMessage("Expected to not be enabled but was.", new Object[0])).isFalse();
        return this;
    }

    public AbstractAccessibilityRecordAssert isFullScreen() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((AccessibilityRecord)this.actual).isFullScreen()).overridingErrorMessage("Expected to be full screen but was not.", new Object[0])).isTrue();
        return this;
    }

    public AbstractAccessibilityRecordAssert isNotFullScreen() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((AccessibilityRecord)this.actual).isFullScreen()).overridingErrorMessage("Expected to not be full screen but was.", new Object[0])).isFalse();
        return this;
    }

    public AbstractAccessibilityRecordAssert isPassword() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((AccessibilityRecord)this.actual).isPassword()).overridingErrorMessage("Expected to be password but was not.", new Object[0])).isTrue();
        return this;
    }

    public AbstractAccessibilityRecordAssert isNotPassword() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((AccessibilityRecord)this.actual).isPassword()).overridingErrorMessage("Expected to not be password but was.", new Object[0])).isFalse();
        return this;
    }

    public AbstractAccessibilityRecordAssert isScrollable() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((AccessibilityRecord)this.actual).isScrollable()).overridingErrorMessage("Expected to be scrollable but was not.", new Object[0])).isTrue();
        return this;
    }

    public AbstractAccessibilityRecordAssert isNotScrollable() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((AccessibilityRecord)this.actual).isScrollable()).overridingErrorMessage("Expected to not be scrollable but was.", new Object[0])).isFalse();
        return this;
    }
}

