/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.view;

import android.annotation.TargetApi;
import android.view.KeyEvent;
import org.assertj.android.api.view.AbstractInputEventAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractCharacterAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;

public class KeyEventAssert
extends AbstractInputEventAssert<KeyEventAssert, KeyEvent> {
    public KeyEventAssert(KeyEvent actual) {
        super(actual, KeyEventAssert.class);
    }

    public KeyEventAssert hasAction(int action) {
        this.isNotNull();
        int actualAction = ((KeyEvent)this.actual).getAction();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualAction).overridingErrorMessage("Expected action <%s> but was <%s>", new Object[]{action, actualAction})).isEqualTo(action);
        return this;
    }

    public KeyEventAssert hasDisplayLabel(char label) {
        this.isNotNull();
        char actualLabel = ((KeyEvent)this.actual).getDisplayLabel();
        ((AbstractCharacterAssert)Assertions.assertThat((char)actualLabel).overridingErrorMessage("Expected label <%s> but was <%s>", new Object[]{Character.valueOf(label), Character.valueOf(actualLabel)})).isEqualTo(label);
        return this;
    }

    public KeyEventAssert hasDownTime(long time) {
        this.isNotNull();
        long actualTime = ((KeyEvent)this.actual).getDownTime();
        ((AbstractLongAssert)Assertions.assertThat((long)actualTime).overridingErrorMessage("Expected time <%s> but was <%s>", new Object[]{time, actualTime})).isEqualTo(time);
        return this;
    }

    public KeyEventAssert hasKeyCode(int keyCode) {
        this.isNotNull();
        int actualKeyCode = ((KeyEvent)this.actual).getKeyCode();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualKeyCode).overridingErrorMessage("Expected key code <%s> but was <%s>", new Object[]{keyCode, actualKeyCode})).isEqualTo(keyCode);
        return this;
    }

    public KeyEventAssert hasRepeatCount(int count) {
        this.isNotNull();
        int actualCount = ((KeyEvent)this.actual).getRepeatCount();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualCount).overridingErrorMessage("Expected repeat count <%s> but was <%s>", new Object[]{count, actualCount})).isEqualTo(count);
        return this;
    }

    @Override
    @TargetApi(value=9)
    public KeyEventAssert hasSource(int source) {
        this.isNotNull();
        int actualSource = ((KeyEvent)this.actual).getSource();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualSource).overridingErrorMessage("Expected source <%s> but was <%s>", new Object[]{source, actualSource})).isEqualTo(source);
        return this;
    }

    @TargetApi(value=11)
    public KeyEventAssert hasModifiers(int modifiers) {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((KeyEvent)this.actual).hasModifiers(modifiers)).overridingErrorMessage("Expected modifiers <%s> but was not present", new Object[]{modifiers})).isTrue();
        return this;
    }

    @TargetApi(value=11)
    public KeyEventAssert hasNoModifiers() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((KeyEvent)this.actual).hasNoModifiers()).overridingErrorMessage("Expected to have no modifiers but modifiers present", new Object[0])).isTrue();
        return this;
    }
}

