/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.location;

import android.annotation.TargetApi;
import android.location.Location;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractDoubleAssert;
import org.assertj.core.api.AbstractFloatAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;

public class LocationAssert
extends AbstractAssert<LocationAssert, Location> {
    public LocationAssert(Location actual) {
        super((Object)actual, LocationAssert.class);
    }

    public LocationAssert hasAccuracy(float accuracy) {
        this.isNotNull();
        float actualAccuracy = ((Location)this.actual).getAccuracy();
        ((AbstractFloatAssert)Assertions.assertThat((float)actualAccuracy).overridingErrorMessage("Expected accuracy <%s> but was <%s>.", new Object[]{Float.valueOf(accuracy), Float.valueOf(actualAccuracy)})).isEqualTo(accuracy);
        return this;
    }

    public LocationAssert hasAltitude(double altitude) {
        this.isNotNull();
        double actualAltitude = ((Location)this.actual).getAltitude();
        ((AbstractDoubleAssert)Assertions.assertThat((double)actualAltitude).overridingErrorMessage("Expected altitude <%s> but was <%s>.", new Object[]{altitude, actualAltitude})).isEqualTo(altitude);
        return this;
    }

    public LocationAssert hasBearing(float bearing) {
        this.isNotNull();
        float actualBearing = ((Location)this.actual).getBearing();
        ((AbstractFloatAssert)Assertions.assertThat((float)actualBearing).overridingErrorMessage("Expected bearing <%s> but was <%s>.", new Object[]{Float.valueOf(bearing), Float.valueOf(actualBearing)})).isEqualTo(bearing);
        return this;
    }

    @TargetApi(value=17)
    public LocationAssert hasElapsedRealTimeNanos(long nanos) {
        this.isNotNull();
        float actualNanos = ((Location)this.actual).getElapsedRealtimeNanos();
        ((AbstractFloatAssert)Assertions.assertThat((float)actualNanos).overridingErrorMessage("Expected elapsed real-time nanos <%s> but was <%s>.", new Object[]{nanos, Float.valueOf(actualNanos)})).isEqualTo((float)nanos);
        return this;
    }

    public LocationAssert hasLatitude(double latitude) {
        this.isNotNull();
        double actualLatitude = ((Location)this.actual).getLatitude();
        ((AbstractDoubleAssert)Assertions.assertThat((double)actualLatitude).overridingErrorMessage("Expected latitude <%s> but was <%s>.", new Object[]{latitude, actualLatitude})).isEqualTo(latitude);
        return this;
    }

    public LocationAssert hasLongitude(double longitude) {
        this.isNotNull();
        double actualLongitude = ((Location)this.actual).getLongitude();
        ((AbstractDoubleAssert)Assertions.assertThat((double)actualLongitude).overridingErrorMessage("Expected longitude <%s> but was <%s>.", new Object[]{longitude, actualLongitude})).isEqualTo(longitude);
        return this;
    }

    public LocationAssert hasProvider(String name) {
        this.isNotNull();
        String actualName = ((Location)this.actual).getProvider();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualName).overridingErrorMessage("Expected provider <%s> but was <%s>.", new Object[]{name, actualName})).isEqualTo((Object)name);
        return this;
    }

    public LocationAssert hasSpeed(float speed) {
        this.isNotNull();
        float actualSpeed = ((Location)this.actual).getSpeed();
        ((AbstractFloatAssert)Assertions.assertThat((float)actualSpeed).overridingErrorMessage("Expected speed <%s> but was <%s>.", new Object[]{Float.valueOf(speed), Float.valueOf(actualSpeed)})).isEqualTo(speed);
        return this;
    }

    public LocationAssert hasTime(long time) {
        this.isNotNull();
        long actualTime = ((Location)this.actual).getTime();
        ((AbstractLongAssert)Assertions.assertThat((long)actualTime).overridingErrorMessage("Expected time <%s> but was <%s>.", new Object[]{time, actualTime})).isEqualTo(time);
        return this;
    }

    public LocationAssert hasAccuracy() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Location)this.actual).hasAccuracy()).overridingErrorMessage("Expected to have accuracy but did not.", new Object[0])).isTrue();
        return this;
    }

    public LocationAssert hasNoAccuracy() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Location)this.actual).hasAccuracy()).overridingErrorMessage("Expected to not have accuracy but did.", new Object[0])).isFalse();
        return this;
    }

    public LocationAssert hasAltitude() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Location)this.actual).hasAltitude()).overridingErrorMessage("Expected to have altitude but did not.", new Object[0])).isTrue();
        return this;
    }

    public LocationAssert hasNoAltitude() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Location)this.actual).hasAltitude()).overridingErrorMessage("Expected to not have altitude but did.", new Object[0])).isFalse();
        return this;
    }

    public LocationAssert hasBearing() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Location)this.actual).hasBearing()).overridingErrorMessage("Expected to have bearing but did not.", new Object[0])).isTrue();
        return this;
    }

    public LocationAssert hasNoBearing() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Location)this.actual).hasBearing()).overridingErrorMessage("Expected to not have bearing but did.", new Object[0])).isFalse();
        return this;
    }

    public LocationAssert hasSpeed() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Location)this.actual).hasSpeed()).overridingErrorMessage("Expected to have speed but did not.", new Object[0])).isTrue();
        return this;
    }

    public LocationAssert hasNoSpeed() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Location)this.actual).hasSpeed()).overridingErrorMessage("Expected to not have speed but did.", new Object[0])).isFalse();
        return this;
    }

    @TargetApi(value=18)
    public LocationAssert isFromMockProvider() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Location)this.actual).isFromMockProvider()).overridingErrorMessage("Expected to be from mock provider but was not.", new Object[0])).isTrue();
        return this;
    }

    @TargetApi(value=18)
    public LocationAssert isNotFromMockProvider() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Location)this.actual).isFromMockProvider()).overridingErrorMessage("Expected to not be from mock provider but was.", new Object[0])).isFalse();
        return this;
    }
}

