/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.graphics;

import android.annotation.TargetApi;
import android.graphics.Canvas;
import android.graphics.Rect;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;

public class CanvasAssert
extends AbstractAssert<CanvasAssert, Canvas> {
    public CanvasAssert(Canvas actual) {
        super((Object)actual, CanvasAssert.class);
    }

    public CanvasAssert hasClipBounds(Rect bounds) {
        this.isNotNull();
        Rect actualBounds = ((Canvas)this.actual).getClipBounds();
        ((AbstractObjectAssert)Assertions.assertThat((Object)actualBounds).overridingErrorMessage("Expected clip bounds <%s> but was <%s>.", new Object[]{bounds, actualBounds})).isEqualTo((Object)bounds);
        return this;
    }

    public CanvasAssert hasDensity(int density) {
        this.isNotNull();
        int actualDensity = ((Canvas)this.actual).getDensity();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualDensity).overridingErrorMessage("Expected density <%s> but was <%s>.", new Object[]{density, actualDensity})).isEqualTo(density);
        return this;
    }

    public CanvasAssert hasHeight(int height) {
        this.isNotNull();
        int actualHeight = ((Canvas)this.actual).getHeight();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualHeight).overridingErrorMessage("Expected height <%s> but was <%s>.", new Object[]{height, actualHeight})).isEqualTo(height);
        return this;
    }

    @TargetApi(value=14)
    public CanvasAssert hasMaximumBitmapHeight(int height) {
        this.isNotNull();
        int actualHeight = ((Canvas)this.actual).getMaximumBitmapHeight();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualHeight).overridingErrorMessage("Expected maximum bitmap height <%s> but was <%s>.", new Object[]{height, actualHeight})).isEqualTo(height);
        return this;
    }

    @TargetApi(value=14)
    public CanvasAssert hasMaximumBitmapWidth(int width) {
        this.isNotNull();
        int actualHeight = ((Canvas)this.actual).getMaximumBitmapWidth();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualHeight).overridingErrorMessage("Expected maximum bitmap width <%s> but was <%s>.", new Object[]{width, actualHeight})).isEqualTo(width);
        return this;
    }

    public CanvasAssert hasSaveCount(int count) {
        this.isNotNull();
        int actualCount = ((Canvas)this.actual).getSaveCount();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualCount).overridingErrorMessage("Expected save count <%s> but was <%s>.", new Object[]{count, actualCount})).isEqualTo(count);
        return this;
    }

    public CanvasAssert hasWidth(int width) {
        this.isNotNull();
        int actualWidth = ((Canvas)this.actual).getWidth();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualWidth).overridingErrorMessage("Expected width <%s> but was <%s>.", new Object[]{width, actualWidth})).isEqualTo(width);
        return this;
    }

    @TargetApi(value=11)
    public CanvasAssert isHardwareAccelerated() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Canvas)this.actual).isHardwareAccelerated()).overridingErrorMessage("Expected to be hardware accelerated but was not.", new Object[0])).isTrue();
        return this;
    }

    @TargetApi(value=11)
    public CanvasAssert isNotHardwareAccelerated() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Canvas)this.actual).isHardwareAccelerated()).overridingErrorMessage("Expected to not be hardware accelerated but was.", new Object[0])).isFalse();
        return this;
    }

    public CanvasAssert isOpaque() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Canvas)this.actual).isOpaque()).overridingErrorMessage("Expected to be opaque but was not.", new Object[0])).isTrue();
        return this;
    }

    public CanvasAssert isNotOpaque() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Canvas)this.actual).isOpaque()).overridingErrorMessage("Expected to not be opaque but was.", new Object[0])).isFalse();
        return this;
    }
}

