/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.anvil.compiler;

import com.google.auto.service.AutoService;
import com.squareup.anvil.annotations.ExperimentalAnvilApi;
import com.squareup.anvil.compiler.AnvilCommandLineProcessorKt;
import com.squareup.anvil.compiler.AnvilComponentRegistrar;
import com.squareup.anvil.compiler.ClassScanner;
import com.squareup.anvil.compiler.CommandLineOptions;
import com.squareup.anvil.compiler.IrContributionMerger;
import com.squareup.anvil.compiler.api.AnalysisBackend;
import com.squareup.anvil.compiler.api.CodeGenerator;
import com.squareup.anvil.compiler.api.ComponentMergingBackend;
import com.squareup.anvil.compiler.codegen.CodeGenerationExtension;
import com.squareup.anvil.compiler.codegen.ContributesSubcomponentHandlerGenerator;
import com.squareup.anvil.compiler.codegen.incremental.BaseDir;
import com.squareup.anvil.compiler.codegen.reference.RealAnvilModuleDescriptor;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ServiceLoader;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.extensions.IrGenerationExtension;
import org.jetbrains.kotlin.com.intellij.mock.MockProject;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.LoadingOrder;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.compiler.plugin.ComponentRegistrar;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.resolve.jvm.extensions.AnalysisHandlerExtension;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\rH\u0007J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\rH\u0002J\u0018\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001c\u0010\u0014\u001a\u00020\u000b*\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0018\u00b2\u0006\n\u0010\u0019\u001a\u00020\u001aX\u008a\u0084\u0002\u00b2\u0006\n\u0010\u001b\u001a\u00020\u001cX\u008a\u0084\u0002\u00b2\u0006\n\u0010\u001d\u001a\u00020\u001eX\u008a\u0084\u0002"}, d2={"Lcom/squareup/anvil/compiler/AnvilComponentRegistrar;", "Lorg/jetbrains/kotlin/compiler/plugin/ComponentRegistrar;", "()V", "manuallyAddedCodeGenerators", "", "Lcom/squareup/anvil/compiler/api/CodeGenerator;", "supportsK2", "", "getSupportsK2", "()Z", "addCodeGenerators", "", "codeGenerators", "", "loadCodeGenerators", "registerProjectComponents", "project", "Lorg/jetbrains/kotlin/com/intellij/mock/MockProject;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "registerExtensionFirst", "Lorg/jetbrains/kotlin/resolve/jvm/extensions/AnalysisHandlerExtension$Companion;", "extension", "Lorg/jetbrains/kotlin/resolve/jvm/extensions/AnalysisHandlerExtension;", "compiler", "scanner", "Lcom/squareup/anvil/compiler/ClassScanner;", "moduleDescriptorFactory", "Lcom/squareup/anvil/compiler/codegen/reference/RealAnvilModuleDescriptor$Factory;", "irMergesFile", "Ljava/io/File;"})
@AutoService(value={ComponentRegistrar.class})
public final class AnvilComponentRegistrar
implements ComponentRegistrar {
    private final boolean supportsK2;
    @NotNull
    private final List<CodeGenerator> manuallyAddedCodeGenerators = new ArrayList();

    public AnvilComponentRegistrar() {
        this.supportsK2 = true;
    }

    public boolean getSupportsK2() {
        return this.supportsK2;
    }

    public void registerProjectComponents(@NotNull MockProject project, @NotNull CompilerConfiguration configuration) {
        boolean mergingEnabled;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        CommandLineOptions commandLineOptions = CommandLineOptions.Companion.getCommandLineOptions(configuration);
        Lazy scanner$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)registerProjectComponents.scanner.2.INSTANCE);
        Lazy moduleDescriptorFactory$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)registerProjectComponents.moduleDescriptorFactory.2.INSTANCE);
        Lazy irMergesFile$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<File>(configuration){
            final /* synthetic */ CompilerConfiguration $configuration;
            {
                this.$configuration = $configuration;
                super(0);
            }

            @NotNull
            public final File invoke() {
                return (File)this.$configuration.getNotNull(AnvilCommandLineProcessorKt.getIrMergesFileKey());
            }
        }));
        Object object = configuration.getNotNull(AnvilCommandLineProcessorKt.getTrackSourceFilesKey());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getNotNull(...)");
        boolean trackSourceFiles = (Boolean)object;
        boolean bl = mergingEnabled = !commandLineOptions.getGenerateFactoriesOnly() && !commandLineOptions.getDisableComponentMerging();
        if (mergingEnabled && commandLineOptions.getComponentMergingBackend() == ComponentMergingBackend.IR) {
            Project project2 = (Project)project;
            ClassScanner classScanner = AnvilComponentRegistrar.registerProjectComponents$lambda$0((Lazy<ClassScanner>)scanner$delegate);
            RealAnvilModuleDescriptor.Factory factory = AnvilComponentRegistrar.registerProjectComponents$lambda$1((Lazy<RealAnvilModuleDescriptor.Factory>)moduleDescriptorFactory$delegate);
            File file = AnvilComponentRegistrar.registerProjectComponents$lambda$2((Lazy<? extends File>)irMergesFile$delegate);
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"registerProjectComponents$lambda$2(...)");
            IrGenerationExtension.Companion.registerExtension(project2, (Object)new IrContributionMerger(classScanner, factory, trackSourceFiles, file));
        }
        if (commandLineOptions.getBackend() != AnalysisBackend.EMBEDDED) {
            return;
        }
        Object object2 = configuration.getNotNull(AnvilCommandLineProcessorKt.getSrcGenDirKey());
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getNotNull(...)");
        File sourceGenFolder = (File)object2;
        Object object3 = configuration.getNotNull(AnvilCommandLineProcessorKt.getAnvilCacheDirKey());
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"getNotNull(...)");
        File cacheDir = (File)object3;
        Object object4 = configuration.getNotNull(AnvilCommandLineProcessorKt.getGradleProjectDirKey());
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"getNotNull(...)");
        File projectDir = BaseDir.ProjectDir.constructor-impl((File)object4);
        Object object5 = configuration.getNotNull(AnvilCommandLineProcessorKt.getGradleBuildDirKey());
        Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"getNotNull(...)");
        File buildDir = BaseDir.BuildDir.constructor-impl((File)object5);
        List codeGenerators2 = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)this.loadCodeGenerators(), (Iterable)this.manuallyAddedCodeGenerators), (Object)new ContributesSubcomponentHandlerGenerator(AnvilComponentRegistrar.registerProjectComponents$lambda$0((Lazy<ClassScanner>)scanner$delegate)));
        this.registerExtensionFirst(AnalysisHandlerExtension.Companion, project, new CodeGenerationExtension(codeGenerators2, commandLineOptions, AnvilComponentRegistrar.registerProjectComponents$lambda$1((Lazy<RealAnvilModuleDescriptor.Factory>)moduleDescriptorFactory$delegate), projectDir, buildDir, sourceGenFolder, cacheDir, trackSourceFiles, null));
    }

    private final void registerExtensionFirst(AnalysisHandlerExtension.Companion $this$registerExtensionFirst, MockProject project, AnalysisHandlerExtension extension) {
        project.getExtensionArea().getExtensionPoint(AnalysisHandlerExtension.Companion.getExtensionPointName()).registerExtension((Object)extension, LoadingOrder.FIRST, (Disposable)project);
    }

    private final List<CodeGenerator> loadCodeGenerators() {
        ServiceLoader<CodeGenerator> serviceLoader = ServiceLoader.load(CodeGenerator.class, CodeGenerator.class.getClassLoader());
        Intrinsics.checkNotNullExpressionValue(serviceLoader, (String)"load(...)");
        return CollectionsKt.toList((Iterable)serviceLoader);
    }

    @ExperimentalAnvilApi
    public final void addCodeGenerators(@NotNull List<? extends CodeGenerator> codeGenerators2) {
        Intrinsics.checkNotNullParameter(codeGenerators2, (String)"codeGenerators");
        CollectionsKt.addAll((Collection)this.manuallyAddedCodeGenerators, (Iterable)codeGenerators2);
    }

    private static final ClassScanner registerProjectComponents$lambda$0(Lazy<ClassScanner> $scanner$delegate) {
        Lazy<ClassScanner> lazy = $scanner$delegate;
        return (ClassScanner)lazy.getValue();
    }

    private static final RealAnvilModuleDescriptor.Factory registerProjectComponents$lambda$1(Lazy<RealAnvilModuleDescriptor.Factory> $moduleDescriptorFactory$delegate) {
        Lazy<RealAnvilModuleDescriptor.Factory> lazy = $moduleDescriptorFactory$delegate;
        return (RealAnvilModuleDescriptor.Factory)lazy.getValue();
    }

    private static final File registerProjectComponents$lambda$2(Lazy<? extends File> $irMergesFile$delegate) {
        Lazy<? extends File> lazy = $irMergesFile$delegate;
        return (File)lazy.getValue();
    }
}

