/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.anvil.compiler;

import com.google.auto.service.AutoService;
import com.squareup.anvil.compiler.AnvilCommandLineProcessorKt;
import com.squareup.anvil.compiler.api.AnalysisBackend;
import com.squareup.anvil.compiler.api.ComponentMergingBackend;
import java.io.File;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.compiler.plugin.AbstractCliOption;
import org.jetbrains.kotlin.compiler.plugin.CliOption;
import org.jetbrains.kotlin.compiler.plugin.CommandLineProcessor;
import org.jetbrains.kotlin.config.CompilerConfiguration;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lcom/squareup/anvil/compiler/AnvilCommandLineProcessor;", "Lorg/jetbrains/kotlin/compiler/plugin/CommandLineProcessor;", "()V", "pluginId", "", "getPluginId", "()Ljava/lang/String;", "pluginOptions", "", "Lorg/jetbrains/kotlin/compiler/plugin/AbstractCliOption;", "getPluginOptions", "()Ljava/util/Collection;", "processOption", "", "option", "value", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "compiler"})
@AutoService(value={CommandLineProcessor.class})
public final class AnvilCommandLineProcessor
implements CommandLineProcessor {
    @NotNull
    private final String pluginId;
    @NotNull
    private final Collection<AbstractCliOption> pluginOptions;

    public AnvilCommandLineProcessor() {
        this.pluginId = "com.squareup.anvil.compiler";
        Object[] objectArray = new CliOption[]{new CliOption("gradle-project-dir", "<file-path>", "The root directory of the consuming project", false, false), new CliOption("gradle-build-dir", "<file-path>", "The build directory of the consuming project", false, false), new CliOption("src-gen-dir", "<file-path>", "Path to directory in which Anvil specific code should be generated", false, false), new CliOption("anvil-cache-dir", "<file-path>", "Path to directory where Anvil stores its incremental compilation state", false, false), new CliOption("ir-merges-file", "<file-path>", "Path of the file where Anvil records its merged module annotations and component/module interfaces", false, false), new CliOption("generate-dagger-factories", "<true|false>", "Whether Anvil should generate Factory classes that the Dagger annotation processor would generate for @Provides methods and @Inject constructors.", false, false), new CliOption("generate-dagger-factories-only", "<true|false>", "Whether Anvil should generate Factory classes only and no code for contributed code.", false, false), new CliOption("disable-component-merging", "<true|false>", "Whether Anvil should generate code only and not transform code for @MergeComponent or @MergeSubcomponent.", false, false), new CliOption("track-source-files", "<true|false>", "Whether Anvil should track its experimental generated file caching and invalidation", false, false), new CliOption("will-have-dagger-factories", "<true|false>", "Whether Anvil should expect that Dagger's Factory models will be generated by the end of compilation, from Anvil itself or from Dagger's generators.", false, false), new CliOption("analysis-backend", CollectionsKt.joinToString$default((Iterable)((Iterable)EntriesMappings.entries$0), (CharSequence)"|", (CharSequence)"<", (CharSequence)">", (int)0, null, null, (int)56, null), "Controls whether Anvil analysis is running as an embedded plugin or as KSP.", false, false), new CliOption("merging-backend", CollectionsKt.joinToString$default((Iterable)((Iterable)EntriesMappings.entries$1), (CharSequence)"|", (CharSequence)"<", (CharSequence)">", (int)0, null, null, (int)56, null), "Controls whether module merging is running as an IR plugin or as KSP.", false, false)};
        this.pluginOptions = CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public String getPluginId() {
        return this.pluginId;
    }

    @NotNull
    public Collection<AbstractCliOption> getPluginOptions() {
        return this.pluginOptions;
    }

    public void processOption(@NotNull AbstractCliOption option, @NotNull String value2, @NotNull CompilerConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        switch (option.getOptionName()) {
            case "gradle-project-dir": {
                configuration.put(AnvilCommandLineProcessorKt.getGradleProjectDirKey(), (Object)new File(value2));
                break;
            }
            case "gradle-build-dir": {
                configuration.put(AnvilCommandLineProcessorKt.getGradleBuildDirKey(), (Object)new File(value2));
                break;
            }
            case "src-gen-dir": {
                configuration.put(AnvilCommandLineProcessorKt.getSrcGenDirKey(), (Object)new File(value2));
                break;
            }
            case "anvil-cache-dir": {
                configuration.put(AnvilCommandLineProcessorKt.getAnvilCacheDirKey(), (Object)new File(value2));
                break;
            }
            case "ir-merges-file": {
                configuration.put(AnvilCommandLineProcessorKt.getIrMergesFileKey(), (Object)new File(value2));
                break;
            }
            case "generate-dagger-factories": {
                configuration.put(AnvilCommandLineProcessorKt.getGenerateDaggerFactoriesKey(), (Object)Boolean.parseBoolean(value2));
                break;
            }
            case "generate-dagger-factories-only": {
                configuration.put(AnvilCommandLineProcessorKt.getGenerateDaggerFactoriesOnlyKey(), (Object)Boolean.parseBoolean(value2));
                break;
            }
            case "disable-component-merging": {
                configuration.put(AnvilCommandLineProcessorKt.getDisableComponentMergingKey(), (Object)Boolean.parseBoolean(value2));
                break;
            }
            case "will-have-dagger-factories": {
                configuration.put(AnvilCommandLineProcessorKt.getWillHaveDaggerFactoriesKey(), (Object)Boolean.parseBoolean(value2));
                break;
            }
            case "track-source-files": {
                configuration.put(AnvilCommandLineProcessorKt.getTrackSourceFilesKey(), (Object)Boolean.parseBoolean(value2));
                break;
            }
            case "analysis-backend": {
                configuration.put(AnvilCommandLineProcessorKt.getAnalysisBackendKey(), (Object)value2);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<AnalysisBackend> entries$0;
        public static final /* synthetic */ EnumEntries<ComponentMergingBackend> entries$1;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])AnalysisBackend.values()));
            entries$1 = EnumEntriesKt.enumEntries((Enum[])((Enum[])ComponentMergingBackend.values()));
        }
    }
}

