/*
 * Decompiled with CFR 0.152.
 */
package com.stone.log;

import android.text.TextUtils;
import android.util.Log;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Logs {
    public static final int VERBOSE = 1;
    public static final int DEBUG = 2;
    public static final int INFO = 3;
    public static final int WARN = 4;
    public static final int ERROR = 5;
    private static final int JSON_INDENT = 4;
    private static String TAG = "logs";
    private static int level = 2;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final int MAX_SINGLE_LOG_LENGTH = 3072;

    private Logs() {
        throw new UnsupportedOperationException("cannot be instantiated");
    }

    public static void init(int level, String defaultTag) {
        Logs.level = level;
        TAG = defaultTag;
    }

    public static void i(Object str) {
        Logs.i("", str);
    }

    public static void d(Object str) {
        Logs.d("", str);
    }

    public static void v(Object str) {
        Logs.v("", str);
    }

    public static void w(Object str) {
        Logs.w("", str);
    }

    public static void e(Object str) {
        Logs.e("", str);
    }

    public static void i(String tag, Object str) {
        if (level <= 3) {
            String name = Logs.getFunctionName();
            tag = Logs.getTag(tag);
            Logs.log(3, tag, name + " - " + str);
        }
    }

    public static void d(String tag, Object str) {
        if (level <= 2) {
            String name = Logs.getFunctionName();
            tag = Logs.getTag(tag);
            Logs.log(2, tag, name + " - " + str);
        }
    }

    private static String getTag(String tag) {
        return tag + TAG;
    }

    public static void v(String tag, Object str) {
        if (level <= 1) {
            String name = Logs.getFunctionName();
            tag = Logs.getTag(tag);
            Logs.log(1, tag, name + " - " + str);
        }
    }

    public static void w(String tag, Object str) {
        if (level <= 4) {
            String name = Logs.getFunctionName();
            tag = Logs.getTag(tag);
            Logs.log(4, tag, name + " - " + str);
        }
    }

    public static void e(String tag, Object str) {
        if (level <= 5) {
            String name = Logs.getFunctionName();
            tag = Logs.getTag(tag);
            Logs.log(5, tag, name + " - " + str);
        }
    }

    public static void e(Exception ex) {
        if (level <= 5) {
            Log.e((String)TAG, (String)"error", (Throwable)ex);
        }
    }

    public static void e(String tag, String msg, Throwable tr) {
        if (level <= 5) {
            String name = Logs.getFunctionName();
            tag = Logs.getTag(tag);
            Log.e((String)tag, (String)(name + " - " + msg), (Throwable)tr);
        }
    }

    public static void json(Object json) {
        Logs.json(TAG, json, null);
    }

    public static void json(Object json, String url) {
        Logs.json(TAG, json, url);
    }

    private static void log(int level, String tag, Object msg) {
        if (msg == null) {
            Logs.showLog(level, tag, "null");
        } else {
            int length = msg.toString().length();
            int start = 0;
            int end = 3072;
            int count = length / 3072;
            for (int i = 0; i <= count; ++i) {
                if (length > end) {
                    Logs.showLog(level, tag, msg.toString().substring(start, end));
                    start = end;
                    end += 3072;
                    continue;
                }
                Logs.showLog(level, tag, msg.toString().substring(start, length));
                break;
            }
        }
    }

    private static void showLog(int level, String tag, Object msg) {
        switch (level) {
            case 1: {
                Log.v((String)tag, (String)msg.toString());
                break;
            }
            case 2: {
                Log.d((String)tag, (String)msg.toString());
                break;
            }
            case 3: {
                Log.i((String)tag, (String)msg.toString());
                break;
            }
            case 4: {
                Log.w((String)tag, (String)msg.toString());
                break;
            }
            case 5: {
                Log.e((String)tag, (String)msg.toString());
            }
        }
    }

    public static void json(String tag, Object json, String url) {
        if (level <= 2) {
            String name = Logs.getFunctionName();
            Log.d((String)tag, (String)"\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
            if (!TextUtils.isEmpty((CharSequence)url)) {
                Log.i((String)tag, (String)("\u2551 onResponseSuccess URL\uff1a" + url));
            }
            Logs.printJson(tag, name, json.toString());
            Log.d((String)tag, (String)"\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
        }
    }

    private static void printJson(String tag, String name, String json) {
        String[] lines;
        String message;
        try {
            if (json.startsWith("{")) {
                JSONObject jsonObject = new JSONObject(json);
                message = jsonObject.toString(4);
            } else if (json.startsWith("[")) {
                JSONArray jsonArray = new JSONArray(json);
                message = jsonArray.toString(4);
            } else {
                message = json;
            }
        }
        catch (JSONException e) {
            message = json;
        }
        message = name + LINE_SEPARATOR + message;
        for (String line : lines = message.split(LINE_SEPARATOR)) {
            Log.d((String)tag, (String)("\u2551 " + line));
        }
    }

    private static String getFunctionName() {
        return Logs.getFunctionName(false);
    }

    private static String getFunctionName(boolean isThreadBreak) {
        StackTraceElement[] sts = Thread.currentThread().getStackTrace();
        if (sts == null) {
            return "";
        }
        for (StackTraceElement st : sts) {
            if (st.isNativeMethod() || st.getClassName().equals(Thread.class.getName()) || st.getClassName().equals(Logs.class.getName()) || st.getClassName().equals(Logs.class.getName() + "$Companion")) continue;
            if (isThreadBreak) {
                return "[ " + Thread.currentThread().getName() + ": \n(" + st.getFileName() + ":" + st.getLineNumber() + ") " + st.getMethodName() + " ]";
            }
            return "[ " + Thread.currentThread().getName() + ": (" + st.getFileName() + ":" + st.getLineNumber() + ") " + st.getMethodName() + " ]";
        }
        return "";
    }
}

