/*
 * Decompiled with CFR 0.152.
 */
package com.stone.log;

import android.text.TextUtils;
import android.util.Log;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/stone/log/Logs;", "", "()V", "Companion", "logs_release"})
public final class Logs {
    public static final int VERBOSE = 1;
    public static final int DEBUG = 2;
    public static final int INFO = 3;
    public static final int WARN = 4;
    public static final int ERROR = 5;
    private static int level;
    private static final int JSON_INDENT = 4;
    private static String TAG;
    private static final String LINE_SEPARATOR;
    private static final int MAX_SINGLE_LOG_LENGTH = 3072;
    public static final Companion Companion;

    private Logs() {
        throw (Throwable)new UnsupportedOperationException("cannot be instantiated");
    }

    static {
        Companion = new Companion(null);
        level = 2;
        TAG = "logs";
        LINE_SEPARATOR = System.getProperty("line.separator");
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0001J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0001J\u000e\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0001J\u0012\u0010\u0017\u001a\u00020\u00142\n\u0010\u0018\u001a\u00060\u0019j\u0002`\u001aJ\u0016\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0001J\"\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\t2\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0012\u0010\u0010\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\tH\u0002J\u000e\u0010!\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0001J\u0016\u0010!\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0001J\u001a\u0010\"\u001a\u00020\u00142\b\b\u0002\u0010\u0012\u001a\u00020\u00042\b\b\u0002\u0010#\u001a\u00020\tJ\u000e\u0010$\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\u0001J\u0016\u0010$\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\u00012\u0006\u0010%\u001a\u00020\tJ \u0010$\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010$\u001a\u00020\u00012\b\u0010%\u001a\u0004\u0018\u00010\tJ\"\u0010&\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\t2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u0002J \u0010'\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010(\u001a\u00020\t2\u0006\u0010$\u001a\u00020\tH\u0002J \u0010)\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u0001H\u0002J\u000e\u0010*\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0001J\u0016\u0010*\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0001J\u000e\u0010+\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0001J\u0016\u0010+\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0001R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\u0004\u0018\u00010\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/stone/log/Logs$Companion;", "", "()V", "DEBUG", "", "ERROR", "INFO", "JSON_INDENT", "LINE_SEPARATOR", "", "kotlin.jvm.PlatformType", "MAX_SINGLE_LOG_LENGTH", "TAG", "VERBOSE", "WARN", "functionName", "getFunctionName", "()Ljava/lang/String;", "level", "d", "", "str", "tag", "e", "ex", "Ljava/lang/Exception;", "Lkotlin/Exception;", "msg", "tr", "", "isThreadBreak", "", "getTag", "i", "init", "defaultTag", "json", "url", "log", "printJson", "name", "showLog", "v", "w", "logs_release"})
    public static final class Companion {
        public final void init(int level, @NotNull String defaultTag) {
            Intrinsics.checkParameterIsNotNull((Object)defaultTag, (String)"defaultTag");
            level = level;
            TAG = defaultTag;
        }

        public static /* bridge */ /* synthetic */ void init$default(Companion companion, int n, String string, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = 2;
            }
            if ((n2 & 2) != 0) {
                string = "logs";
            }
            companion.init(n, string);
        }

        public final void i(@NotNull Object str) {
            Intrinsics.checkParameterIsNotNull((Object)str, (String)"str");
            this.i("", str);
        }

        public final void d(@NotNull Object str) {
            Intrinsics.checkParameterIsNotNull((Object)str, (String)"str");
            this.d("", str);
        }

        public final void v(@NotNull Object str) {
            Intrinsics.checkParameterIsNotNull((Object)str, (String)"str");
            this.v("", str);
        }

        public final void w(@NotNull Object str) {
            Intrinsics.checkParameterIsNotNull((Object)str, (String)"str");
            this.w("", str);
        }

        public final void e(@NotNull Object str) {
            Intrinsics.checkParameterIsNotNull((Object)str, (String)"str");
            this.e("", str);
        }

        public final void i(@NotNull String tag, @NotNull Object str) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            Intrinsics.checkParameterIsNotNull((Object)str, (String)"str");
            if (level <= 3) {
                String name = this.getFunctionName();
                String t = this.getTag(tag);
                if (name != null) {
                    this.log(3, t, name + " - " + str);
                } else {
                    this.log(3, t, str.toString());
                }
            }
        }

        public final void d(@NotNull String tag, @NotNull Object str) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            Intrinsics.checkParameterIsNotNull((Object)str, (String)"str");
            if (level <= 2) {
                String name = this.getFunctionName();
                String t = this.getTag(tag);
                if (name != null) {
                    this.log(2, t, name + " - " + str);
                } else {
                    this.log(2, t, str.toString());
                }
            }
        }

        private final String getTag(String tag) {
            return tag + TAG;
        }

        public final void v(@NotNull String tag, @NotNull Object str) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            Intrinsics.checkParameterIsNotNull((Object)str, (String)"str");
            if (level <= 1) {
                String name = this.getFunctionName();
                String t = this.getTag(tag);
                if (name != null) {
                    this.log(1, t, name + " - " + str);
                } else {
                    this.log(1, t, str.toString());
                }
            }
        }

        public final void w(@NotNull String tag, @NotNull Object str) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            Intrinsics.checkParameterIsNotNull((Object)str, (String)"str");
            if (level <= 4) {
                String name = this.getFunctionName();
                String t = this.getTag(tag);
                if (name != null) {
                    this.log(4, t, name + " - " + str);
                } else {
                    this.log(4, t, str.toString());
                }
            }
        }

        public final void e(@NotNull String tag, @NotNull Object str) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            Intrinsics.checkParameterIsNotNull((Object)str, (String)"str");
            if (level <= 5) {
                String name = this.getFunctionName();
                String t = this.getTag(tag);
                if (name != null) {
                    this.log(5, t, name + " - " + str);
                } else {
                    this.log(5, t, str.toString());
                }
            }
        }

        public final void e(@NotNull Exception ex) {
            Intrinsics.checkParameterIsNotNull((Object)ex, (String)"ex");
            if (level <= 5) {
                Log.e((String)TAG, (String)"error", (Throwable)ex);
            }
        }

        public final void e(@NotNull String msg, @Nullable String tag, @NotNull Throwable tr) {
            Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
            Intrinsics.checkParameterIsNotNull((Object)tr, (String)"tr");
            if (level <= 5) {
                String line = this.getFunctionName();
                String string = tag;
                if (string == null) {
                    string = TAG;
                }
                StringBuilder stringBuilder = new StringBuilder().append("{Thread:");
                Thread thread = Thread.currentThread();
                Intrinsics.checkExpressionValueIsNotNull((Object)thread, (String)"Thread.currentThread()");
                Log.e((String)string, (String)stringBuilder.append(thread.getName()).append("}").append("[").append(line).append(":] ").append(msg).append("\n").toString(), (Throwable)tr);
            }
        }

        public static /* bridge */ /* synthetic */ void e$default(Companion companion, String string, String string2, Throwable throwable, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = null;
            }
            companion.e(string, string2, throwable);
        }

        public final void json(@NotNull Object json) {
            Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
            this.json(TAG, json, null);
        }

        public final void json(@NotNull Object json, @NotNull String url) {
            Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            this.json(TAG, json, url);
        }

        /*
         * WARNING - void declaration
         */
        private final void log(int level, String tag, Object msg) {
            if (msg != null) {
                int length = msg.toString().length();
                if (length > 3072) {
                    int start = 0;
                    int end = 3072;
                    int n = 0;
                    int count = length / 3072;
                    int n2 = count;
                    if (n <= n2) {
                        while (true) {
                            String string;
                            Companion companion;
                            int n3;
                            String string2;
                            String string3;
                            if (length <= end) {
                                string3 = msg.toString();
                                string2 = tag;
                                n3 = level;
                                companion = this;
                                String string4 = string3;
                                if (string4 == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                                }
                                String string5 = string4.substring(start, length);
                                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                                string = string5;
                                companion.showLog(n3, string2, string);
                            } else {
                                void i;
                                string3 = msg.toString();
                                string2 = tag;
                                n3 = level;
                                companion = this;
                                String string6 = string3;
                                if (string6 == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                                }
                                Intrinsics.checkExpressionValueIsNotNull((Object)string6.substring(start, end), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                                companion.showLog(n3, string2, string);
                                start = end;
                                end += 3072;
                                if (i != n2) {
                                    ++i;
                                    continue;
                                }
                            }
                            break;
                        }
                    }
                } else {
                    this.showLog(level, tag, msg);
                }
            }
        }

        private final void showLog(int level, String tag, Object msg) {
            switch (level) {
                case 1: {
                    Log.v((String)tag, (String)msg.toString());
                    break;
                }
                case 2: {
                    Log.d((String)tag, (String)msg.toString());
                    break;
                }
                case 3: {
                    Log.i((String)tag, (String)msg.toString());
                    break;
                }
                case 4: {
                    Log.w((String)tag, (String)msg.toString());
                    break;
                }
                case 5: {
                    Log.e((String)tag, (String)msg.toString());
                    break;
                }
                default: {
                    Log.d((String)tag, (String)msg.toString());
                }
            }
        }

        public final void json(@NotNull String tag, @NotNull Object json, @Nullable String url) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
            if (level <= 2) {
                String name = this.getFunctionName();
                if (name == null) {
                    name = "";
                }
                Log.d((String)tag, (String)"\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
                if (!TextUtils.isEmpty((CharSequence)url)) {
                    StringBuilder stringBuilder = new StringBuilder().append("\u2551 onResponseSuccess URL\uff1a");
                    String string = url;
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    Log.w((String)tag, (String)stringBuilder.append(string).toString());
                }
                this.printJson(tag, name, json.toString());
                Log.d((String)tag, (String)"\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
            }
        }

        private final void printJson(String tag, String name, String json) {
            List list;
            Collection $receiver$iv;
            String jsonArray;
            try {
                String string;
                if (StringsKt.startsWith$default((String)json, (String)"{", (boolean)false, (int)2, null)) {
                    JSONObject jsonObject = new JSONObject(json);
                    String string2 = jsonObject.toString(4);
                    string = string2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"jsonObject.toString(JSON_INDENT)");
                } else if (StringsKt.startsWith$default((String)json, (String)"[", (boolean)false, (int)2, null)) {
                    jsonArray = new JSONArray(json);
                    String string3 = jsonArray.toString(4);
                    string = string3;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"jsonArray.toString(JSON_INDENT)");
                } else {
                    string = json;
                }
                jsonArray = string;
            }
            catch (JSONException e) {
                jsonArray = json;
            }
            String message = jsonArray;
            message = name + LINE_SEPARATOR + message;
            Object e = message;
            String string = LINE_SEPARATOR;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"LINE_SEPARATOR");
            String string4 = string;
            string4 = new Regex(string4);
            int n = 0;
            e = string4.split((CharSequence)e, n);
            if (!$receiver$iv.isEmpty()) {
                ListIterator iterator$iv = $receiver$iv.listIterator($receiver$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    CharSequence charSequence = it;
                    if (charSequence.length() == 0) continue;
                    list = CollectionsKt.take((Iterable)$receiver$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            $receiver$iv = list;
            Collection collection = $receiver$iv;
            if (collection == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            Collection thisCollection$iv = collection;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            for (String line : stringArray) {
                this.log(2, tag, "\u2551 " + line);
            }
        }

        private final String getFunctionName() {
            return Companion.getFunctionName(false);
        }

        private final String getFunctionName(boolean isThreadBreak) {
            Thread thread = Thread.currentThread();
            Intrinsics.checkExpressionValueIsNotNull((Object)thread, (String)"Thread.currentThread()");
            StackTraceElement[] stackTraceElementArray = thread.getStackTrace();
            if (stackTraceElementArray == null) {
                return null;
            }
            StackTraceElement[] sts = stackTraceElementArray;
            int n = sts.length;
            for (int i = 0; i < n; ++i) {
                String string;
                StackTraceElement st;
                StackTraceElement stackTraceElement = st = sts[i];
                Intrinsics.checkExpressionValueIsNotNull((Object)stackTraceElement, (String)"st");
                if (stackTraceElement.isNativeMethod() || Intrinsics.areEqual((Object)st.getClassName(), (Object)Thread.class.getName()) || Intrinsics.areEqual((Object)st.getClassName(), (Object)Logs.class.getName()) || Intrinsics.areEqual((Object)st.getClassName(), (Object)(Logs.class.getName() + "$Companion"))) continue;
                if (isThreadBreak) {
                    StringBuilder stringBuilder = new StringBuilder().append("[ ");
                    Thread thread2 = Thread.currentThread();
                    Intrinsics.checkExpressionValueIsNotNull((Object)thread2, (String)"Thread.currentThread()");
                    string = stringBuilder.append(thread2.getName()).append(": \n(").append(st.getFileName()).append(":").append(st.getLineNumber()).append(") ").append(st.getMethodName()).append(" ]").toString();
                } else {
                    StringBuilder stringBuilder = new StringBuilder().append("[ ");
                    Thread thread3 = Thread.currentThread();
                    Intrinsics.checkExpressionValueIsNotNull((Object)thread3, (String)"Thread.currentThread()");
                    string = stringBuilder.append(thread3.getName()).append(": (").append(st.getFileName()).append(":").append(st.getLineNumber()).append(") ").append(st.getMethodName()).append(" ]").toString();
                }
                return string;
            }
            return null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

