/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.util.math;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Range<T extends Comparable<? super T>> {
    public static final String FLOOR_INCLUSIVE_DELIMITER = "[";
    public static final String CEILING_INCLUSIVE_DELIMITER = "]";
    public static final String FLOOR_EXCLUSIVE_DELIMITER = "(";
    public static final String CEILING_EXCLUSIVE_DELIMITER = ")";
    public static final String SEPARATOR = ",";
    private final T floor;
    private final T ceiling;
    private final boolean floorInc;
    private final boolean ceilingInc;

    public Range(T floor, boolean floorInc, T ceiling, boolean ceilingInc) {
        this.floor = floor;
        this.floorInc = floorInc;
        this.ceiling = ceiling;
        this.ceilingInc = ceilingInc;
    }

    public boolean contains(T t) {
        int maxCheck;
        int minCheck = this.floorInc ? 0 : 1;
        int n = maxCheck = this.ceilingInc ? 0 : -1;
        return t.compareTo(this.floor) >= minCheck && t.compareTo(this.ceiling) <= maxCheck;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.floorInc ? FLOOR_INCLUSIVE_DELIMITER : FLOOR_EXCLUSIVE_DELIMITER);
        result.append(this.floor.toString());
        result.append(SEPARATOR);
        result.append(this.ceiling.toString());
        result.append(this.ceilingInc ? CEILING_INCLUSIVE_DELIMITER : CEILING_EXCLUSIVE_DELIMITER);
        return result.toString();
    }
}

