/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.util.math;

import com.springsource.util.math.ConcurrentHashSet;
import com.springsource.util.math.ConcurrentRelation;
import com.springsource.util.math.ConcurrentSet;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConcurrentMapRelation<X, Y>
implements ConcurrentRelation<X, Y> {
    private final ConcurrentMap<X, ConcurrentSet<Y>> rel = new ConcurrentHashMap<X, ConcurrentSet<Y>>();

    @Override
    public boolean add(X x, Y y) {
        this.ensure(x);
        return ((ConcurrentSet)this.rel.get(x)).add(y);
    }

    @Override
    public boolean contains(X x, Y y) {
        this.ensure(x);
        return ((ConcurrentSet)this.rel.get(x)).contains(y);
    }

    @Override
    public Set<X> dom() {
        return this.rel.keySet();
    }

    @Override
    public Set<Y> ran() {
        ConcurrentHashSet range = new ConcurrentHashSet();
        for (ConcurrentSet rangeSet : this.rel.values()) {
            range.addAll(rangeSet);
        }
        return range;
    }

    @Override
    public boolean remove(X x, Y y) {
        this.ensure(x);
        return ((ConcurrentSet)this.rel.get(x)).remove(y);
    }

    private void ensure(X x) {
        if (!this.rel.containsKey(x)) {
            this.rel.putIfAbsent(x, new ConcurrentHashSet());
        }
    }

    @Override
    public Set<Y> relationalImage(Set<X> xset) {
        ConcurrentHashSet rImg = new ConcurrentHashSet();
        for (X x : xset) {
            if (!this.rel.containsKey(x)) continue;
            rImg.addAll((Collection)this.rel.get(x));
        }
        return rImg;
    }

    @Override
    public void domSubtract(Set<X> xset) {
        for (X x : xset) {
            this.rel.remove(x);
        }
    }
}

