/*
 * Decompiled with CFR 0.152.
 */
package uk.co.flamingpenguin.jewel.cli;

import uk.co.flamingpenguin.jewel.cli.ArgumentCollection;
import uk.co.flamingpenguin.jewel.cli.ArgumentPresenterImpl;
import uk.co.flamingpenguin.jewel.cli.ArgumentTyperImpl;
import uk.co.flamingpenguin.jewel.cli.ArgumentValidationException;
import uk.co.flamingpenguin.jewel.cli.ArgumentValidatorImpl;
import uk.co.flamingpenguin.jewel.cli.Cli;
import uk.co.flamingpenguin.jewel.cli.OptionsSpecification;
import uk.co.flamingpenguin.jewel.cli.OptionsSpecificationImpl;
import uk.co.flamingpenguin.jewel.cli.ParsedArgumentsBuilder;
import uk.co.flamingpenguin.jewel.cli.TypedArguments;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CliImpl<O>
implements Cli<O> {
    private final OptionsSpecification<O> m_specification;
    private final Class<O> m_klass;

    public CliImpl(Class<O> klass) {
        this.m_specification = new OptionsSpecificationImpl<O>(klass);
        this.m_klass = klass;
    }

    @Override
    public O parseArguments(String ... arguments) throws ArgumentValidationException {
        ArgumentCollection validatedArguments = new ArgumentValidatorImpl<O>(this.m_specification).validateArguments(new ParsedArgumentsBuilder().parseArguments(arguments));
        TypedArguments typedArguments = new ArgumentTyperImpl<O>(this.m_specification).typeArguments(validatedArguments);
        return new ArgumentPresenterImpl<O>(this.m_klass, this.m_specification).presentArguments(typedArguments);
    }

    @Override
    public String getHelpMessage() {
        return this.m_specification.toString();
    }
}

