/*
 * Decompiled with CFR 0.152.
 */
package javaslang.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javaslang.collection.AbstractIterator;
import javaslang.collection.HashMap;
import javaslang.collection.HashSet;
import javaslang.collection.Iterator;
import javaslang.collection.List;
import javaslang.collection.Map;
import javaslang.collection.Seq;
import javaslang.collection.Traversable;
import javaslang.control.Option;

final class Collections {
    Collections() {
    }

    static <C extends Traversable<T>, T> C removeAll(C collection, T element) {
        Objects.requireNonNull(element, "element is null");
        return Collections.removeAll(collection, List.of(element));
    }

    static <C extends Traversable<T>, T> C removeAll(C collection, Iterable<? extends T> elements) {
        Objects.requireNonNull(elements, "elements is null");
        HashSet removed = HashSet.ofAll(elements);
        return (C)collection.filter(e -> !removed.contains(e));
    }

    static <C extends Traversable<T>, T> C retainAll(C collection, Iterable<? extends T> elements) {
        Objects.requireNonNull(elements, "elements is null");
        HashSet<? extends T> removed = HashSet.ofAll(elements);
        return (C)collection.filter(removed::contains);
    }

    public static <T, C, R extends Iterable<T>> Map<C, R> groupBy(Traversable<T> collection, Function<? super T, ? extends C> classifier, Function<? super Iterable<T>, R> mapper) {
        Objects.requireNonNull(collection, "collection is null");
        Objects.requireNonNull(classifier, "classifier is null");
        Objects.requireNonNull(mapper, "mapper is null");
        java.util.HashMap<Object, Collection> mutableResults = new java.util.HashMap<Object, Collection>();
        for (Object value : collection) {
            C key = classifier.apply(value);
            mutableResults.computeIfAbsent(key, k -> new ArrayList()).add(value);
        }
        Map results = HashMap.empty();
        for (Map.Entry entry : mutableResults.entrySet()) {
            results = results.put(entry.getKey(), mapper.apply(entry.getValue()));
        }
        return results;
    }

    static Option<Integer> indexOption(int index) {
        return Option.when(index >= 0, index);
    }

    static boolean equals(Iterable<?> iterable1, Iterable<?> iterable2) {
        java.util.Iterator<?> iter1 = iterable1.iterator();
        java.util.Iterator<?> iter2 = iterable2.iterator();
        while (iter1.hasNext() && iter2.hasNext()) {
            if (Objects.equals(iter1.next(), iter2.next())) continue;
            return false;
        }
        return iter1.hasNext() == iter2.hasNext();
    }

    static int hash(Iterable<?> iterable) {
        int hashCode = 1;
        for (Object o : iterable) {
            hashCode = 31 * hashCode + Objects.hashCode(o);
        }
        return hashCode;
    }

    static <T, U, C extends Iterable<U>, R extends Traversable<U>> R scanLeft(Iterable<? extends T> elements, U zero, BiFunction<? super U, ? super T, ? extends U> operation, C cumulativeResult, BiFunction<C, U, C> combiner, Function<C, R> finisher) {
        U acc = zero;
        cumulativeResult = (Iterable)combiner.apply(cumulativeResult, acc);
        for (T a : elements) {
            acc = operation.apply(acc, a);
            cumulativeResult = (Iterable)combiner.apply(cumulativeResult, acc);
        }
        return (R)((Traversable)finisher.apply(cumulativeResult));
    }

    static <T, U, C extends Iterable<U>, R extends Traversable<U>> R scanRight(Iterable<? extends T> elements, U zero, BiFunction<? super T, ? super U, ? extends U> operation, C cumulativeResult, BiFunction<C, U, C> combiner, Function<C, R> finisher) {
        Iterator<? extends T> reversedElements = Collections.seq(elements).reverseIterator();
        return Collections.scanLeft(reversedElements, zero, (u, t) -> operation.apply(t, u), cumulativeResult, combiner, finisher);
    }

    static <T, S extends Seq<T>> Iterator<S> crossProduct(S empty, S seq, int power) {
        if (power < 0) {
            throw new IllegalArgumentException("negative power");
        }
        return Iterator.range(0, power).foldLeft(Iterator.of(empty), (product, ignored) -> product.flatMap(el -> seq.map(t -> el.append(t))));
    }

    static <C extends Traversable<T>, T> C tabulate(int n, Function<? super Integer, ? extends T> f, C empty, Function<T[], C> of) {
        Objects.requireNonNull(f, "f is null");
        Objects.requireNonNull(empty, "empty is null");
        Objects.requireNonNull(of, "of is null");
        if (n <= 0) {
            return empty;
        }
        Object[] elements = new Object[n];
        for (int i = 0; i < n; ++i) {
            elements[i] = f.apply(i);
        }
        return (C)((Traversable)of.apply((Object[][])elements));
    }

    static <C extends Traversable<T>, T> C fill(int n, Supplier<? extends T> s2, C empty, Function<T[], C> of) {
        Objects.requireNonNull(s2, "s is null");
        Objects.requireNonNull(empty, "empty is null");
        Objects.requireNonNull(of, "of is null");
        return Collections.tabulate(n, anything -> s2.get(), empty, of);
    }

    static <T> Iterator<T> tabulate(final int n, final Function<? super Integer, ? extends T> f) {
        Objects.requireNonNull(f, "f is null");
        if (n <= 0) {
            return Iterator.empty();
        }
        return new AbstractIterator<T>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < n;
            }

            @Override
            protected T getNext() {
                return f.apply(this.i++);
            }
        };
    }

    static <T> Iterator<T> fill(int n, Supplier<? extends T> s2) {
        Objects.requireNonNull(s2, "s is null");
        return Collections.tabulate(n, anything -> s2.get());
    }

    private static <T> Seq<T> seq(Iterable<? extends T> iterable) {
        if (iterable instanceof Seq) {
            return (Seq)iterable;
        }
        return List.ofAll(iterable);
    }
}

