/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.state;

import com.spotify.styx.model.ExecutionDescription;
import com.spotify.styx.model.TriggerParameters;
import com.spotify.styx.state.Message;
import com.spotify.styx.state.StateData;
import com.spotify.styx.state.Trigger;
import io.norberg.automatter.AutoMatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public final class StateDataBuilder {
    private int tries;
    private int consecutiveFailures;
    private double retryCost;
    private Optional<Long> retryDelayMillis;
    private Optional<Integer> lastExit;
    private Optional<Trigger> trigger;
    private Optional<String> triggerId;
    private Optional<String> executionId;
    private Optional<String> runnerId;
    private Optional<ExecutionDescription> executionDescription;
    private Optional<Set<String>> resourceIds;
    private Optional<TriggerParameters> triggerParameters;
    private List<Message> messages;

    public StateDataBuilder() {
        this.retryDelayMillis = Optional.empty();
        this.lastExit = Optional.empty();
        this.trigger = Optional.empty();
        this.triggerId = Optional.empty();
        this.executionId = Optional.empty();
        this.runnerId = Optional.empty();
        this.executionDescription = Optional.empty();
        this.resourceIds = Optional.empty();
        this.triggerParameters = Optional.empty();
    }

    private StateDataBuilder(StateData v) {
        this.tries = v.tries();
        this.consecutiveFailures = v.consecutiveFailures();
        this.retryCost = v.retryCost();
        this.retryDelayMillis = v.retryDelayMillis();
        this.lastExit = v.lastExit();
        this.trigger = v.trigger();
        this.triggerId = v.triggerId();
        this.executionId = v.executionId();
        this.runnerId = v.runnerId();
        this.executionDescription = v.executionDescription();
        this.resourceIds = v.resourceIds();
        this.triggerParameters = v.triggerParameters();
        List<Message> _messages = v.messages();
        this.messages = _messages == null ? null : new ArrayList<Message>(_messages);
    }

    private StateDataBuilder(StateDataBuilder v) {
        this.tries = v.tries;
        this.consecutiveFailures = v.consecutiveFailures;
        this.retryCost = v.retryCost;
        this.retryDelayMillis = v.retryDelayMillis;
        this.lastExit = v.lastExit;
        this.trigger = v.trigger;
        this.triggerId = v.triggerId;
        this.executionId = v.executionId;
        this.runnerId = v.runnerId;
        this.executionDescription = v.executionDescription;
        this.resourceIds = v.resourceIds;
        this.triggerParameters = v.triggerParameters;
        this.messages = v.messages == null ? null : new ArrayList<Message>(v.messages);
    }

    public int tries() {
        return this.tries;
    }

    public StateDataBuilder tries(int tries) {
        this.tries = tries;
        return this;
    }

    public int consecutiveFailures() {
        return this.consecutiveFailures;
    }

    public StateDataBuilder consecutiveFailures(int consecutiveFailures) {
        this.consecutiveFailures = consecutiveFailures;
        return this;
    }

    public double retryCost() {
        return this.retryCost;
    }

    public StateDataBuilder retryCost(double retryCost) {
        this.retryCost = retryCost;
        return this;
    }

    public Optional<Long> retryDelayMillis() {
        return this.retryDelayMillis;
    }

    public StateDataBuilder retryDelayMillis(Long retryDelayMillis) {
        return this.retryDelayMillis(Optional.ofNullable(retryDelayMillis));
    }

    public StateDataBuilder retryDelayMillis(Optional<? extends Long> retryDelayMillis) {
        if (retryDelayMillis == null) {
            throw new NullPointerException("retryDelayMillis");
        }
        this.retryDelayMillis = retryDelayMillis;
        return this;
    }

    public Optional<Integer> lastExit() {
        return this.lastExit;
    }

    public StateDataBuilder lastExit(Integer lastExit) {
        return this.lastExit(Optional.ofNullable(lastExit));
    }

    public StateDataBuilder lastExit(Optional<? extends Integer> lastExit) {
        if (lastExit == null) {
            throw new NullPointerException("lastExit");
        }
        this.lastExit = lastExit;
        return this;
    }

    public Optional<Trigger> trigger() {
        return this.trigger;
    }

    public StateDataBuilder trigger(Trigger trigger) {
        return this.trigger(Optional.ofNullable(trigger));
    }

    public StateDataBuilder trigger(Optional<? extends Trigger> trigger) {
        if (trigger == null) {
            throw new NullPointerException("trigger");
        }
        this.trigger = trigger;
        return this;
    }

    public Optional<String> triggerId() {
        return this.triggerId;
    }

    public StateDataBuilder triggerId(String triggerId) {
        return this.triggerId(Optional.ofNullable(triggerId));
    }

    public StateDataBuilder triggerId(Optional<? extends String> triggerId) {
        if (triggerId == null) {
            throw new NullPointerException("triggerId");
        }
        this.triggerId = triggerId;
        return this;
    }

    public Optional<String> executionId() {
        return this.executionId;
    }

    public StateDataBuilder executionId(String executionId) {
        return this.executionId(Optional.ofNullable(executionId));
    }

    public StateDataBuilder executionId(Optional<? extends String> executionId) {
        if (executionId == null) {
            throw new NullPointerException("executionId");
        }
        this.executionId = executionId;
        return this;
    }

    public Optional<String> runnerId() {
        return this.runnerId;
    }

    public StateDataBuilder runnerId(String runnerId) {
        return this.runnerId(Optional.ofNullable(runnerId));
    }

    public StateDataBuilder runnerId(Optional<? extends String> runnerId) {
        if (runnerId == null) {
            throw new NullPointerException("runnerId");
        }
        this.runnerId = runnerId;
        return this;
    }

    public Optional<ExecutionDescription> executionDescription() {
        return this.executionDescription;
    }

    public StateDataBuilder executionDescription(ExecutionDescription executionDescription) {
        return this.executionDescription(Optional.ofNullable(executionDescription));
    }

    public StateDataBuilder executionDescription(Optional<? extends ExecutionDescription> executionDescription) {
        if (executionDescription == null) {
            throw new NullPointerException("executionDescription");
        }
        this.executionDescription = executionDescription;
        return this;
    }

    public Optional<Set<String>> resourceIds() {
        return this.resourceIds;
    }

    public StateDataBuilder resourceIds(Set<String> resourceIds) {
        return this.resourceIds(Optional.ofNullable(resourceIds));
    }

    public StateDataBuilder resourceIds(Optional<? extends Set<String>> resourceIds) {
        if (resourceIds == null) {
            throw new NullPointerException("resourceIds");
        }
        this.resourceIds = resourceIds;
        return this;
    }

    public Optional<TriggerParameters> triggerParameters() {
        return this.triggerParameters;
    }

    public StateDataBuilder triggerParameters(TriggerParameters triggerParameters) {
        return this.triggerParameters(Optional.ofNullable(triggerParameters));
    }

    public StateDataBuilder triggerParameters(Optional<? extends TriggerParameters> triggerParameters) {
        if (triggerParameters == null) {
            throw new NullPointerException("triggerParameters");
        }
        this.triggerParameters = triggerParameters;
        return this;
    }

    public List<Message> messages() {
        if (this.messages == null) {
            this.messages = new ArrayList<Message>();
        }
        return this.messages;
    }

    public StateDataBuilder messages(List<? extends Message> messages) {
        return this.messages((Collection<? extends Message>)messages);
    }

    public StateDataBuilder messages(Collection<? extends Message> messages) {
        if (messages == null) {
            throw new NullPointerException("messages");
        }
        for (Message message : messages) {
            if (message != null) continue;
            throw new NullPointerException("messages: null item");
        }
        this.messages = new ArrayList<Message>(messages);
        return this;
    }

    public StateDataBuilder messages(Iterable<? extends Message> messages) {
        if (messages == null) {
            throw new NullPointerException("messages");
        }
        if (messages instanceof Collection) {
            return this.messages((Collection)messages);
        }
        return this.messages(messages.iterator());
    }

    public StateDataBuilder messages(Iterator<? extends Message> messages) {
        if (messages == null) {
            throw new NullPointerException("messages");
        }
        this.messages = new ArrayList<Message>();
        while (messages.hasNext()) {
            Message item = messages.next();
            if (item == null) {
                throw new NullPointerException("messages: null item");
            }
            this.messages.add(item);
        }
        return this;
    }

    @SafeVarargs
    public final StateDataBuilder messages(Message ... messages) {
        if (messages == null) {
            throw new NullPointerException("messages");
        }
        return this.messages(Arrays.asList(messages));
    }

    public StateDataBuilder addMessage(Message message) {
        if (message == null) {
            throw new NullPointerException("message");
        }
        if (this.messages == null) {
            this.messages = new ArrayList<Message>();
        }
        this.messages.add(message);
        return this;
    }

    public StateDataBuilder builder() {
        return new StateDataBuilder(this);
    }

    public StateData build() {
        List<Message> _messages = this.messages != null ? Collections.unmodifiableList(new ArrayList<Message>(this.messages)) : Collections.emptyList();
        return new Value(this.tries, this.consecutiveFailures, this.retryCost, this.retryDelayMillis, this.lastExit, this.trigger, this.triggerId, this.executionId, this.runnerId, this.executionDescription, this.resourceIds, this.triggerParameters, _messages);
    }

    public static StateDataBuilder from(StateData v) {
        return new StateDataBuilder(v);
    }

    public static StateDataBuilder from(StateDataBuilder v) {
        return new StateDataBuilder(v);
    }

    private static final class Value
    implements StateData {
        private final int tries;
        private final int consecutiveFailures;
        private final double retryCost;
        private final Optional<Long> retryDelayMillis;
        private final Optional<Integer> lastExit;
        private final Optional<Trigger> trigger;
        private final Optional<String> triggerId;
        private final Optional<String> executionId;
        private final Optional<String> runnerId;
        private final Optional<ExecutionDescription> executionDescription;
        private final Optional<Set<String>> resourceIds;
        private final Optional<TriggerParameters> triggerParameters;
        private final List<Message> messages;

        private Value(@AutoMatter.Field(value="tries") int tries, @AutoMatter.Field(value="consecutiveFailures") int consecutiveFailures, @AutoMatter.Field(value="retryCost") double retryCost, @AutoMatter.Field(value="retryDelayMillis") Optional<Long> retryDelayMillis, @AutoMatter.Field(value="lastExit") Optional<Integer> lastExit, @AutoMatter.Field(value="trigger") Optional<Trigger> trigger, @AutoMatter.Field(value="triggerId") Optional<String> triggerId, @AutoMatter.Field(value="executionId") Optional<String> executionId, @AutoMatter.Field(value="runnerId") Optional<String> runnerId, @AutoMatter.Field(value="executionDescription") Optional<ExecutionDescription> executionDescription, @AutoMatter.Field(value="resourceIds") Optional<Set<String>> resourceIds, @AutoMatter.Field(value="triggerParameters") Optional<TriggerParameters> triggerParameters, @AutoMatter.Field(value="messages") List<Message> messages) {
            if (retryDelayMillis == null) {
                throw new NullPointerException("retryDelayMillis");
            }
            if (lastExit == null) {
                throw new NullPointerException("lastExit");
            }
            if (trigger == null) {
                throw new NullPointerException("trigger");
            }
            if (triggerId == null) {
                throw new NullPointerException("triggerId");
            }
            if (executionId == null) {
                throw new NullPointerException("executionId");
            }
            if (runnerId == null) {
                throw new NullPointerException("runnerId");
            }
            if (executionDescription == null) {
                throw new NullPointerException("executionDescription");
            }
            if (resourceIds == null) {
                throw new NullPointerException("resourceIds");
            }
            if (triggerParameters == null) {
                throw new NullPointerException("triggerParameters");
            }
            this.tries = tries;
            this.consecutiveFailures = consecutiveFailures;
            this.retryCost = retryCost;
            this.retryDelayMillis = retryDelayMillis;
            this.lastExit = lastExit;
            this.trigger = trigger;
            this.triggerId = triggerId;
            this.executionId = executionId;
            this.runnerId = runnerId;
            this.executionDescription = executionDescription;
            this.resourceIds = resourceIds;
            this.triggerParameters = triggerParameters;
            this.messages = messages != null ? messages : Collections.emptyList();
        }

        @Override
        @AutoMatter.Field
        public int tries() {
            return this.tries;
        }

        @Override
        @AutoMatter.Field
        public int consecutiveFailures() {
            return this.consecutiveFailures;
        }

        @Override
        @AutoMatter.Field
        public double retryCost() {
            return this.retryCost;
        }

        @Override
        @AutoMatter.Field
        public Optional<Long> retryDelayMillis() {
            return this.retryDelayMillis;
        }

        @Override
        @AutoMatter.Field
        public Optional<Integer> lastExit() {
            return this.lastExit;
        }

        @Override
        @AutoMatter.Field
        public Optional<Trigger> trigger() {
            return this.trigger;
        }

        @Override
        @AutoMatter.Field
        public Optional<String> triggerId() {
            return this.triggerId;
        }

        @Override
        @AutoMatter.Field
        public Optional<String> executionId() {
            return this.executionId;
        }

        @Override
        @AutoMatter.Field
        public Optional<String> runnerId() {
            return this.runnerId;
        }

        @Override
        @AutoMatter.Field
        public Optional<ExecutionDescription> executionDescription() {
            return this.executionDescription;
        }

        @Override
        @AutoMatter.Field
        public Optional<Set<String>> resourceIds() {
            return this.resourceIds;
        }

        @Override
        @AutoMatter.Field
        public Optional<TriggerParameters> triggerParameters() {
            return this.triggerParameters;
        }

        @Override
        @AutoMatter.Field
        public List<Message> messages() {
            return this.messages;
        }

        @Override
        public StateDataBuilder builder() {
            return new StateDataBuilder(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof StateData)) {
                return false;
            }
            StateData that = (StateData)o;
            if (this.tries != that.tries()) {
                return false;
            }
            if (this.consecutiveFailures != that.consecutiveFailures()) {
                return false;
            }
            if (Double.compare(this.retryCost, that.retryCost()) != 0) {
                return false;
            }
            if (this.retryDelayMillis != null ? !this.retryDelayMillis.equals(that.retryDelayMillis()) : that.retryDelayMillis() != null) {
                return false;
            }
            if (this.lastExit != null ? !this.lastExit.equals(that.lastExit()) : that.lastExit() != null) {
                return false;
            }
            if (this.trigger != null ? !this.trigger.equals(that.trigger()) : that.trigger() != null) {
                return false;
            }
            if (this.triggerId != null ? !this.triggerId.equals(that.triggerId()) : that.triggerId() != null) {
                return false;
            }
            if (this.executionId != null ? !this.executionId.equals(that.executionId()) : that.executionId() != null) {
                return false;
            }
            if (this.runnerId != null ? !this.runnerId.equals(that.runnerId()) : that.runnerId() != null) {
                return false;
            }
            if (this.executionDescription != null ? !this.executionDescription.equals(that.executionDescription()) : that.executionDescription() != null) {
                return false;
            }
            if (this.resourceIds != null ? !this.resourceIds.equals(that.resourceIds()) : that.resourceIds() != null) {
                return false;
            }
            if (this.triggerParameters != null ? !this.triggerParameters.equals(that.triggerParameters()) : that.triggerParameters() != null) {
                return false;
            }
            return !(this.messages != null ? !this.messages.equals(that.messages()) : that.messages() != null);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.tries;
            result = 31 * result + this.consecutiveFailures;
            long temp = Double.doubleToLongBits(this.retryCost);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            result = 31 * result + (this.retryDelayMillis != null ? this.retryDelayMillis.hashCode() : 0);
            result = 31 * result + (this.lastExit != null ? this.lastExit.hashCode() : 0);
            result = 31 * result + (this.trigger != null ? this.trigger.hashCode() : 0);
            result = 31 * result + (this.triggerId != null ? this.triggerId.hashCode() : 0);
            result = 31 * result + (this.executionId != null ? this.executionId.hashCode() : 0);
            result = 31 * result + (this.runnerId != null ? this.runnerId.hashCode() : 0);
            result = 31 * result + (this.executionDescription != null ? this.executionDescription.hashCode() : 0);
            result = 31 * result + (this.resourceIds != null ? this.resourceIds.hashCode() : 0);
            result = 31 * result + (this.triggerParameters != null ? this.triggerParameters.hashCode() : 0);
            result = 31 * result + (this.messages != null ? this.messages.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "StateData{tries=" + this.tries + ", consecutiveFailures=" + this.consecutiveFailures + ", retryCost=" + this.retryCost + ", retryDelayMillis=" + this.retryDelayMillis + ", lastExit=" + this.lastExit + ", trigger=" + this.trigger + ", triggerId=" + this.triggerId + ", executionId=" + this.executionId + ", runnerId=" + this.runnerId + ", executionDescription=" + this.executionDescription + ", resourceIds=" + this.resourceIds + ", triggerParameters=" + this.triggerParameters + ", messages=" + this.messages + "}";
        }
    }
}

