/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.serialization;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.spotify.styx.model.Event;
import com.spotify.styx.serialization.PersistentEvent;
import com.spotify.styx.serialization.PersistentTrigger;
import com.spotify.styx.state.Trigger;
import com.spotify.styx.util.TypeWrapperModule;
import io.norberg.automatter.jackson.AutoMatterModule;
import java.io.IOException;
import okio.ByteString;

public final class Json {
    private static final TypeWrapperModule ADT_MODULE = new TypeWrapperModule().setupWrapping(Event.class, PersistentEvent.class, PersistentEvent::wrap, PersistentEvent::toEvent).setupWrapping(Trigger.class, PersistentTrigger.class, PersistentTrigger::wrap, PersistentTrigger::toTrigger);
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE).enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS).registerModule(ADT_MODULE).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).registerModule(new JavaTimeModule()).registerModule(new Jdk8Module()).registerModule(new AutoMatterModule());
    public static final ObjectMapper YAML_MAPPER = new ObjectMapper(new YAMLFactory()).setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE).enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).registerModule(ADT_MODULE).registerModule(new Jdk8Module()).registerModule(new JavaTimeModule()).registerModule(new AutoMatterModule());

    private Json() {
        throw new UnsupportedOperationException();
    }

    public static ByteString serialize(Object value) throws JsonProcessingException {
        return ByteString.of(OBJECT_MAPPER.writeValueAsBytes(value));
    }

    public static <T> T deserialize(ByteString json, Class<T> clazz) throws IOException {
        return OBJECT_MAPPER.readValue(json.toByteArray(), clazz);
    }

    public static Event deserializeEvent(ByteString json) throws IOException {
        return OBJECT_MAPPER.readValue(json.toByteArray(), Event.class);
    }

    public static Trigger deserializeTrigger(ByteString json) throws IOException {
        return OBJECT_MAPPER.readValue(json.toByteArray(), Trigger.class);
    }

    public static String deterministicStringUnchecked(Object value) {
        ObjectWriter writer = OBJECT_MAPPER.writer().with(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS);
        try {
            return writer.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

