/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.auto.value.AutoValue;
import com.spotify.styx.model.AutoValue_Schedule;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.Locale;
import java.util.Optional;

@AutoValue
public abstract class Schedule {
    public static final Schedule HOURS = Schedule.parse("@hourly");
    public static final Schedule DAYS = Schedule.parse("@daily");
    public static final Schedule WEEKS = Schedule.parse("@weekly");
    public static final Schedule MONTHS = Schedule.parse("@monthly");
    public static final Schedule YEARS = Schedule.parse("@yearly");

    public abstract String expression();

    public WellKnown wellKnown() {
        return Schedule.toWellKnown(this.expression());
    }

    private static WellKnown toWellKnown(String expression) {
        switch (expression.toLowerCase(Locale.US)) {
            case "@hourly": 
            case "hourly": 
            case "hours": {
                return WellKnown.HOURLY;
            }
            case "@daily": 
            case "daily": 
            case "days": {
                return WellKnown.DAILY;
            }
            case "@weekly": 
            case "weekly": 
            case "weeks": {
                return WellKnown.WEEKLY;
            }
            case "@monthly": 
            case "monthly": 
            case "months": {
                return WellKnown.MONTHLY;
            }
            case "@annually": 
            case "annually": 
            case "@yearly": 
            case "yearly": 
            case "years": {
                return WellKnown.YEARLY;
            }
        }
        return WellKnown.UNKNOWN;
    }

    public String toString() {
        switch (this.wellKnown()) {
            case HOURLY: {
                return "HOURS";
            }
            case DAILY: {
                return "DAYS";
            }
            case WEEKLY: {
                return "WEEKS";
            }
            case MONTHLY: {
                return "MONTHS";
            }
            case YEARLY: {
                return "YEARS";
            }
        }
        return this.expression();
    }

    @JsonValue
    public String toJson() {
        return this.toString().toLowerCase(Locale.US);
    }

    @JsonCreator
    public static Schedule parse(String expression) {
        String normalizedExpression;
        switch (Schedule.toWellKnown(expression)) {
            case HOURLY: {
                normalizedExpression = "@hourly";
                break;
            }
            case DAILY: {
                normalizedExpression = "@daily";
                break;
            }
            case WEEKLY: {
                normalizedExpression = "@weekly";
                break;
            }
            case MONTHLY: {
                normalizedExpression = "@monthly";
                break;
            }
            case YEARLY: {
                normalizedExpression = "@yearly";
                break;
            }
            default: {
                normalizedExpression = expression;
            }
        }
        return new AutoValue_Schedule(normalizedExpression);
    }

    public static enum WellKnown {
        HOURLY(ChronoUnit.HOURS),
        DAILY(ChronoUnit.DAYS),
        WEEKLY(ChronoUnit.WEEKS),
        MONTHLY(ChronoUnit.MONTHS),
        YEARLY(ChronoUnit.YEARS),
        UNKNOWN(null);

        private final Optional<TemporalUnit> unit;

        public Optional<TemporalUnit> unit() {
            return this.unit;
        }

        private WellKnown(TemporalUnit unit) {
            this.unit = Optional.ofNullable(unit);
        }
    }
}

