/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.api;

import com.spotify.styx.api.RunStateDataPayload;
import io.norberg.automatter.AutoMatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class RunStateDataPayloadBuilder {
    private List<RunStateDataPayload.RunStateData> activeStates;

    public RunStateDataPayloadBuilder() {
    }

    private RunStateDataPayloadBuilder(RunStateDataPayload v) {
        List<RunStateDataPayload.RunStateData> _activeStates = v.activeStates();
        this.activeStates = _activeStates == null ? null : new ArrayList<RunStateDataPayload.RunStateData>(_activeStates);
    }

    private RunStateDataPayloadBuilder(RunStateDataPayloadBuilder v) {
        this.activeStates = v.activeStates == null ? null : new ArrayList<RunStateDataPayload.RunStateData>(v.activeStates);
    }

    public List<RunStateDataPayload.RunStateData> activeStates() {
        if (this.activeStates == null) {
            this.activeStates = new ArrayList<RunStateDataPayload.RunStateData>();
        }
        return this.activeStates;
    }

    public RunStateDataPayloadBuilder activeStates(List<? extends RunStateDataPayload.RunStateData> activeStates) {
        return this.activeStates((Collection<? extends RunStateDataPayload.RunStateData>)activeStates);
    }

    public RunStateDataPayloadBuilder activeStates(Collection<? extends RunStateDataPayload.RunStateData> activeStates) {
        if (activeStates == null) {
            throw new NullPointerException("activeStates");
        }
        for (RunStateDataPayload.RunStateData runStateData : activeStates) {
            if (runStateData != null) continue;
            throw new NullPointerException("activeStates: null item");
        }
        this.activeStates = new ArrayList<RunStateDataPayload.RunStateData>(activeStates);
        return this;
    }

    public RunStateDataPayloadBuilder activeStates(Iterable<? extends RunStateDataPayload.RunStateData> activeStates) {
        if (activeStates == null) {
            throw new NullPointerException("activeStates");
        }
        if (activeStates instanceof Collection) {
            return this.activeStates((Collection)activeStates);
        }
        return this.activeStates(activeStates.iterator());
    }

    public RunStateDataPayloadBuilder activeStates(Iterator<? extends RunStateDataPayload.RunStateData> activeStates) {
        if (activeStates == null) {
            throw new NullPointerException("activeStates");
        }
        this.activeStates = new ArrayList<RunStateDataPayload.RunStateData>();
        while (activeStates.hasNext()) {
            RunStateDataPayload.RunStateData item = activeStates.next();
            if (item == null) {
                throw new NullPointerException("activeStates: null item");
            }
            this.activeStates.add(item);
        }
        return this;
    }

    @SafeVarargs
    public final RunStateDataPayloadBuilder activeStates(RunStateDataPayload.RunStateData ... activeStates) {
        if (activeStates == null) {
            throw new NullPointerException("activeStates");
        }
        return this.activeStates(Arrays.asList(activeStates));
    }

    public RunStateDataPayloadBuilder addActiveState(RunStateDataPayload.RunStateData activeState) {
        if (activeState == null) {
            throw new NullPointerException("activeState");
        }
        if (this.activeStates == null) {
            this.activeStates = new ArrayList<RunStateDataPayload.RunStateData>();
        }
        this.activeStates.add(activeState);
        return this;
    }

    public RunStateDataPayload build() {
        List<RunStateDataPayload.RunStateData> _activeStates = this.activeStates != null ? Collections.unmodifiableList(new ArrayList<RunStateDataPayload.RunStateData>(this.activeStates)) : Collections.emptyList();
        return new Value(_activeStates);
    }

    public static RunStateDataPayloadBuilder from(RunStateDataPayload v) {
        return new RunStateDataPayloadBuilder(v);
    }

    public static RunStateDataPayloadBuilder from(RunStateDataPayloadBuilder v) {
        return new RunStateDataPayloadBuilder(v);
    }

    private static final class Value
    implements RunStateDataPayload {
        private final List<RunStateDataPayload.RunStateData> activeStates;

        private Value(@AutoMatter.Field(value="activeStates") List<RunStateDataPayload.RunStateData> activeStates) {
            this.activeStates = activeStates != null ? activeStates : Collections.emptyList();
        }

        @Override
        @AutoMatter.Field
        public List<RunStateDataPayload.RunStateData> activeStates() {
            return this.activeStates;
        }

        public RunStateDataPayloadBuilder builder() {
            return new RunStateDataPayloadBuilder(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RunStateDataPayload)) {
                return false;
            }
            RunStateDataPayload that = (RunStateDataPayload)o;
            return !(this.activeStates != null ? !this.activeStates.equals(that.activeStates()) : that.activeStates() != null);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.activeStates != null ? this.activeStates.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "RunStateDataPayload{activeStates=" + this.activeStates + "}";
        }
    }
}

