/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.logging.logback;

import ch.qos.logback.classic.pattern.SyslogStartConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.util.LevelToSyslogSeverity;
import ch.qos.logback.core.net.SyslogAppenderBase;
import com.google.common.base.Optional;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class MillisecondPrecisionSyslogStartConverter
extends SyslogStartConverter {
    private long lastTimestamp = -1L;
    private String timestampStr = null;
    private SimpleDateFormat simpleFormat;
    private String localHostName;
    private int facility;
    private static final String os = System.getProperty("os.name");

    @Override
    public void start() {
        int errorCount = 0;
        String facilityStr = this.getFirstOption();
        if (facilityStr == null) {
            this.addError("was expecting a facility string as an option");
            return;
        }
        this.facility = SyslogAppenderBase.facilityStringToint(facilityStr);
        this.localHostName = Optional.fromNullable(this.getContext().getProperty("hostname")).or(this.getLocalHostname());
        try {
            this.simpleFormat = os.equals("Mac OS X") ? new SimpleDateFormat("MMM dd HH:mm:ss", new DateFormatSymbols(Locale.US)) : new SimpleDateFormat("MMM dd HH:mm:ss.SSS", new DateFormatSymbols(Locale.US));
        }
        catch (IllegalArgumentException e) {
            this.addError("Could not instantiate SimpleDateFormat", e);
            ++errorCount;
        }
        if (errorCount == 0) {
            super.start();
        }
    }

    @Override
    public String convert(ILoggingEvent event) {
        StringBuilder sb = new StringBuilder();
        int pri = this.facility + LevelToSyslogSeverity.convert(event);
        sb.append("<");
        sb.append(pri);
        sb.append(">");
        sb.append(this.computeTimeStampString(event.getTimeStamp()));
        sb.append(' ');
        sb.append(this.localHostName);
        sb.append(' ');
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String computeTimeStampString(long now) {
        MillisecondPrecisionSyslogStartConverter millisecondPrecisionSyslogStartConverter = this;
        synchronized (millisecondPrecisionSyslogStartConverter) {
            if (now != this.lastTimestamp) {
                this.lastTimestamp = now;
                this.timestampStr = this.simpleFormat.format(new Date(now));
            }
            return this.timestampStr;
        }
    }
}

