/*
 * Decompiled with CFR 0.152.
 */
package com.getsentry.raven.connection;

import com.getsentry.raven.connection.Connection;
import com.getsentry.raven.connection.EventSendFailureCallback;
import com.getsentry.raven.environment.RavenEnvironment;
import com.getsentry.raven.event.Event;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncConnection
implements Connection {
    private static final Logger logger = LoggerFactory.getLogger(AsyncConnection.class);
    private final long shutdownTimeout;
    private final Connection actualConnection;
    private final ExecutorService executorService;
    private final ShutDownHook shutDownHook = new ShutDownHook();
    private boolean gracefulShutdown;
    private volatile boolean closed;

    public AsyncConnection(Connection actualConnection, ExecutorService executorService, boolean gracefulShutdown, long shutdownTimeout) {
        this.actualConnection = actualConnection;
        this.executorService = executorService == null ? Executors.newSingleThreadExecutor() : executorService;
        if (gracefulShutdown) {
            this.gracefulShutdown = gracefulShutdown;
            this.addShutdownHook();
        }
        this.shutdownTimeout = shutdownTimeout;
    }

    private void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(this.shutDownHook);
    }

    @Override
    public void send(Event event) {
        if (!this.closed) {
            this.executorService.execute(new EventSubmitter(event));
        }
    }

    @Override
    public void addEventSendFailureCallback(EventSendFailureCallback eventSendFailureCallback) {
        this.actualConnection.addEventSendFailureCallback(eventSendFailureCallback);
    }

    @Override
    public void close() throws IOException {
        if (this.gracefulShutdown) {
            this.shutDownHook.enabled = false;
        }
        this.doClose();
    }

    private void doClose() throws IOException {
        logger.info("Gracefully shutdown sentry threads.");
        this.closed = true;
        this.executorService.shutdown();
        try {
            if (this.shutdownTimeout == -1L) {
                long waitBetweenLoggingMs = 5000L;
                while (!this.executorService.awaitTermination(waitBetweenLoggingMs, TimeUnit.MILLISECONDS)) {
                    logger.info("Still waiting on async executor to terminate.");
                }
            } else if (!this.executorService.awaitTermination(this.shutdownTimeout, TimeUnit.MILLISECONDS)) {
                logger.warn("Graceful shutdown took too much time, forcing the shutdown.");
                List<Runnable> tasks = this.executorService.shutdownNow();
                logger.info("{} tasks failed to execute before the shutdown.", (Object)tasks.size());
            }
            logger.info("Shutdown finished.");
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.error("Graceful shutdown interrupted, forcing the shutdown.");
            List<Runnable> tasks = this.executorService.shutdownNow();
            logger.info("{} tasks failed to execute before the shutdown.", (Object)tasks.size());
        }
        finally {
            this.actualConnection.close();
        }
    }

    private final class ShutDownHook
    extends Thread {
        private volatile boolean enabled = true;

        private ShutDownHook() {
        }

        @Override
        public void run() {
            if (!this.enabled) {
                return;
            }
            RavenEnvironment.startManagingThread();
            try {
                logger.info("Automatic shutdown of the async connection");
                AsyncConnection.this.doClose();
            }
            catch (Exception e) {
                logger.error("An exception occurred while closing the connection.", e);
            }
            finally {
                RavenEnvironment.stopManagingThread();
            }
        }
    }

    private final class EventSubmitter
    implements Runnable {
        private final Event event;

        private EventSubmitter(Event event) {
            this.event = event;
        }

        @Override
        public void run() {
            RavenEnvironment.startManagingThread();
            try {
                AsyncConnection.this.actualConnection.send(this.event);
            }
            catch (Exception e) {
                logger.error("An exception occurred while sending the event to Sentry.", e);
            }
            finally {
                RavenEnvironment.stopManagingThread();
            }
        }
    }
}

